<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Loan Default Notice - Morio Sacco</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
        .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 8px 8px; }
        .loan-details { background: white; padding: 20px; border-radius: 6px; margin: 20px 0; border-left: 4px solid #dc3545; }
        .warning { background: #fff3cd; border: 1px solid #ffeaa7; color: #856404; padding: 15px; border-radius: 4px; margin: 20px 0; }
        .footer { text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #dee2e6; color: #6c757d; font-size: 12px; }
        .highlight { font-weight: bold; color: #dc3545; }
        .amount { font-size: 18px; font-weight: bold; color: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Morio Sacco</h1>
            <h2>Loan Default Notice</h2>
        </div>

        <div class="content">
            <p>Dear <?php echo e($user->full_name); ?>,</p>

            <div class="warning">
                <strong>⚠️ IMPORTANT NOTICE:</strong> Your loan has been marked as defaulted due to non-payment beyond the agreed return date.
            </div>

            <div class="loan-details">
                <h3>Loan Details</h3>
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Loan ID:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><?php echo e($loan->id); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Application Date:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><?php echo e($application_date ? $application_date->format('M j, Y') : 'N/A'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Return Date:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><?php echo e($return_date->format('M j, Y')); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Principal Amount:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;">KSh <?php echo e(number_format($loan->amount, 0)); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Interest Rate:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><?php echo e($loan->interest_rate); ?>%</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Total Amount:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;">KSh <?php echo e(number_format($loan->total_amount, 0)); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;"><strong>Amount Paid:</strong></td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #dee2e6;">KSh <?php echo e(number_format($loan->paid_amount, 0)); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0;"><strong>Outstanding Balance:</strong></td>
                        <td style="padding: 8px 0;" class="amount">KSh <?php echo e(number_format($outstanding_balance, 0)); ?></td>
                    </tr>
                </table>
            </div>

            <p>This loan was due for full repayment by <strong><?php echo e($return_date->format('M j, Y')); ?></strong>, but remains unpaid. As per our loan agreement terms, this loan has now been marked as defaulted.</p>

            <p><strong>What happens next:</strong></p>
            <ul>
                <li>The outstanding balance of <span class="highlight">KSh <?php echo e(number_format($outstanding_balance, 0)); ?></span> is now considered in default</li>
                <li>Additional penalties and interest may apply</li>
                <li>Your credit standing with Morio Sacco may be affected</li>
                <li>Legal action may be taken if the outstanding amount is not settled</li>
            </ul>

            <p><strong>Immediate Action Required:</strong></p>
            <p>Please contact our loan department immediately to discuss settlement options and avoid further penalties.</p>

            <div style="background: #e9ecef; padding: 15px; border-radius: 4px; margin: 20px 0;">
                <strong>Contact Information:</strong><br>
                Morio Sacco Loan Department<br>
                Phone: +254 XXX XXX XXX<br>
                Email: loans@morio-sacco.co.ke<br>
                Office Hours: Monday - Friday, 8:00 AM - 5:00 PM
            </div>

            <p>We appreciate your past business with Morio Sacco and hope to resolve this matter amicably.</p>

            <p>Best regards,<br>
            <strong>Morio Sacco Management</strong></p>
        </div>

        <div class="footer">
            <p>This is an automated message from Morio Sacco Management System.<br>
            Please do not reply to this email. For assistance, use the contact information above.</p>
            <p>&copy; <?php echo e(date('Y')); ?> Morio Sacco. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\emails\loan-default-notification.blade.php ENDPATH**/ ?>