<?php $__env->startSection('title', 'System Configuration'); ?>

<?php $__env->startSection('content'); ?>
<style>
/* Custom System Settings Tab Styling */
.nav-tabs .nav-link {
    color: #247f1b !important; /* Primary green color */
    border-color: #247f1b #247f1b #dee2e6 !important;
    background-color: transparent !important;
    font-weight: 500;
    transition: all 0.3s ease;
}

.nav-tabs .nav-link:hover {
    color: #1e6b16 !important; /* Darker green on hover */
    background-color: rgba(36, 127, 27, 0.1) !important;
    border-color: #247f1b !important;
}

.nav-tabs .nav-link.active {
    color: #dc3545 !important; /* Red color for active tab */
    background-color: rgba(220, 53, 69, 0.1) !important;
    border-color: #dc3545 #dc3545 #fff !important;
    border-bottom-color: #fff !important;
}

.nav-tabs .nav-link.active:hover {
    color: #c82333 !important; /* Darker red on hover for active tab */
}
</style>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <form action="<?php echo e(route('system-settings.update')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Configure System Settings</h3>
                        <div class="card-tools">
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-save"></i> Save
                            </button>
                        </div>
                    </div>

                    <div class="card-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>" id="<?php echo e($categoryKey); ?>-tab" data-toggle="tab" href="#<?php echo e($categoryKey); ?>" role="tab">
                                    <i class="<?php echo e($category['icon']); ?>"></i> <?php echo e($category['title']); ?>

                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content mt-3" id="settingsTabContent">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?>" id="<?php echo e($categoryKey); ?>" role="tabpanel">
                                <?php if($categoryKey === 'database'): ?>
                                    <!-- Database Management Section -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5 class="card-title mb-0">
                                                        <i class="fas fa-database mr-2"></i>Database Backup & Restore
                                                    </h5>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <!-- Export Section -->
                                                        <div class="col-md-6">
                                                            <div class="border rounded p-4 text-center">
                                                                <i class="fas fa-download fa-3x text-success mb-3"></i>
                                                                <h5>Export Database</h5>
                                                                <p class="text-muted">Create a backup of your entire database including all tables and data.</p>
                                                                <a href="<?php echo e(route('system-settings.export-database')); ?>" class="btn btn-success btn-lg">
                                                                    <i class="fas fa-download mr-2"></i>Export Database
                                                                </a>
                                                                <div class="mt-3">
                                                                    <small class="text-muted">
                                                                        <i class="fas fa-info-circle mr-1"></i>
                                                                        Backup files are automatically deleted after download for security.
                                                                    </small>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Import Section -->
                                                        <div class="col-md-6">
                                                            <div class="border rounded p-4 text-center">
                                                                <i class="fas fa-upload fa-3x text-warning mb-3"></i>
                                                                <h5>Restore Database</h5>
                                                                <p class="text-muted">Restore your database from a previously exported backup file.</p>
                                                                <form action="<?php echo e(route('system-settings.import-database')); ?>" method="POST" enctype="multipart/form-data">
                                                                    <?php echo csrf_field(); ?>
                                                                    <div class="form-group mb-3">
                                                                        <label for="backup_file" class="form-label">Select Backup File</label>
                                                                        <input type="file" class="form-control <?php $__errorArgs = ['backup_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                               id="backup_file" name="backup_file" accept=".sql" required>
                                                                        <div class="form-text">Only .sql files are accepted</div>
                                                                        <?php $__errorArgs = ['backup_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                    <button type="submit" class="btn btn-warning btn-lg"
                                                                            onclick="return confirm('Are you sure you want to restore the database? This will overwrite all current data.')">
                                                                        <i class="fas fa-upload mr-2"></i>Restore Database
                                                                    </button>
                                                                    <div class="mt-3">
                                                                        <small class="text-danger">
                                                                            <i class="fas fa-exclamation-triangle mr-1"></i>
                                                                            Warning: This action cannot be undone. Make sure you have a recent backup.
                                                                        </small>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Backup Information -->
                                                    <div class="row mt-4">
                                                        <div class="col-md-12">
                                                            <div class="alert alert-info">
                                                                <h6><i class="fas fa-info-circle mr-2"></i>Backup Information</h6>
                                                                <ul class="mb-0">
                                                                    <li>Regular backups are essential for data safety</li>
                                                                    <li>Backup files contain all your database tables and data</li>
                                                                    <li>Store backup files securely in multiple locations</li>
                                                                    <li>Test restore functionality periodically</li>
                                                                    <li>Backup before making major system changes</li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="row">
                                        <?php $__currentLoopData = $category['settings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $settingKey => $settingConfig): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="<?php echo e($settingKey); ?>">
                                                    <?php echo e($settingConfig['label']); ?>

                                                    <?php if(isset($settingConfig['description']) && $settingConfig['description']): ?>
                                                    <small class="form-text text-muted"><?php echo e($settingConfig['description']); ?></small>
                                                    <?php endif; ?>
                                                </label>

                                                <?php if($settingConfig['type'] === 'file'): ?>
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" id="<?php echo e($settingKey); ?>" name="files[<?php echo e($settingKey); ?>]" accept="image/*">
                                                            <label class="custom-file-label" for="<?php echo e($settingKey); ?>">Choose file</label>
                                                        </div>
                                                    </div>
                                                    <?php if($settings->get($categoryKey, collect())->where('key', $settingKey)->first()): ?>
                                                        <div class="mt-2">
                                                            <small class="text-muted">Current: <?php echo e($settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value); ?></small>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php elseif($settingConfig['type'] === 'select'): ?>
                                                    <select class="form-control" id="<?php echo e($settingKey); ?>" name="settings[<?php echo e($settingKey); ?>]">
                                                        <?php if(isset($settingConfig['options']) && is_array($settingConfig['options'])): ?>
                                                            <?php $__currentLoopData = $settingConfig['options']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optionValue => $optionLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($optionValue); ?>"
                                                                        <?php echo e(($settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value ?? $settingConfig['default'] ?? '') == $optionValue ? 'selected' : ''); ?>>
                                                                    <?php echo e($optionLabel); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                    </select>
                                                <?php elseif($settingConfig['type'] === 'text'): ?>
                                                    <textarea class="form-control" id="<?php echo e($settingKey); ?>" name="settings[<?php echo e($settingKey); ?>]" rows="3"
                                                              placeholder="<?php echo e($settingConfig['default'] ?? ''); ?>"><?php echo e($settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value ?? $settingConfig['default'] ?? ''); ?></textarea>
                                                <?php else: ?>
                                                    <input type="<?php echo e($settingConfig['type'] === 'number' ? 'number' : 'text'); ?>"
                                                           class="form-control" id="<?php echo e($settingKey); ?>" name="settings[<?php echo e($settingKey); ?>]"
                                                           value="<?php echo e($settings->get($categoryKey, collect())->where('key', $settingKey)->first()->value ?? $settingConfig['default'] ?? ''); ?>"
                                                           placeholder="<?php echo e($settingConfig['default'] ?? ''); ?>">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="card-footer">
                        <?php if($categories && !empty($categories)): ?>
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-save"></i> Save
                            </button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-secondary btn-sm ml-2">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>


</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('plugins.Datatables', true); ?>

<?php $__env->startSection('js'); ?>
<script>
$(document).ready(function() {
    // File input label update
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });

    // Form validation
    $('form').on('submit', function(e) {
        // Add any custom validation here if needed
        return true;
    });
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\system-settings\index.blade.php ENDPATH**/ ?>