<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Loan Report - <?php echo e(date('Y-m-d')); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 10px;
        }

        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }

        .header h2 {
            color: #247f1b;
            margin: 5px 0;
            font-size: 14px;
        }

        .header p {
            margin: 2px 0;
            color: #666;
        }

        .filters {
            margin-bottom: 20px;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 4px;
        }

        .filters h3 {
            margin: 0 0 10px 0;
            font-size: 12px;
            color: #247f1b;
        }

        .filters p {
            margin: 2px 0;
            font-size: 9px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 8px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            text-align: center;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .amount {
            text-align: right;
            font-weight: bold;
        }

        .status {
            text-align: center;
        }

        .badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 7px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .badge-success { background-color: #28a745; color: white; }
        .badge-warning { background-color: #ffc107; color: black; }
        .badge-danger { background-color: #dc3545; color: white; }
        .badge-info { background-color: #17a2b8; color: white; }
        .badge-primary { background-color: #247f1b; color: white; }
        .badge-secondary { background-color: #6c757d; color: white; }

        .summary {
            margin-top: 20px;
            padding: 15px;
            background: #247f1b;
            color: white;
            border-radius: 4px;
        }

        .summary h3 {
            margin: 0 0 10px 0;
            font-size: 14px;
            text-align: center;
        }

        .summary-grid {
            display: table;
            width: 100%;
        }

        .summary-item {
            display: table-cell;
            width: 20%;
            text-align: center;
            padding: 5px;
        }

        .summary-value {
            font-size: 12px;
            font-weight: bold;
        }

        .summary-label {
            font-size: 8px;
            opacity: 0.9;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 15px;
            font-size: 8px;
            color: #666;
        }

        .page-break {
            page-break-before: always;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            color: #666;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <h2>Loan Report</h2>
        <p>Generated on <?php echo e(date('l, F j, Y \a\t g:i A')); ?></p>
    </div>

    <?php if(request()->hasAny(['status', 'user_id'])): ?>
    <div class="filters">
        <h3>Applied Filters:</h3>
        <?php if(request('status')): ?> <p><strong>Status:</strong> <?php echo e(ucfirst(request('status'))); ?></p> <?php endif; ?>
        <?php if(request('user_id')): ?>
            <?php $user = \App\Models\User::find(request('user_id')) ?>
            <p><strong>Member:</strong> <?php echo e($user ? $user->full_name : 'N/A'); ?></p>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <?php if($loans->count() > 0): ?>
    <table>
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 15%;">Member</th>
                <th style="width: 10%;">Amount</th>
                <th style="width: 8%;">Interest</th>
                <th style="width: 8%;">Term</th>
                <th style="width: 12%;">Total Amount</th>
                <th style="width: 10%;">Monthly Payment</th>
                <th style="width: 8%;">Status</th>
                <th style="width: 10%;">Approved</th>
                <th style="width: 12%;">Application Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td style="text-align: center;"><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($loan->user->full_name ?? 'N/A'); ?></td>
                <td class="amount">KSh <?php echo e(number_format($loan->amount, 2)); ?></td>
                <td style="text-align: center;"><?php echo e($loan->interest_rate); ?>%</td>
                <td style="text-align: center;"><?php echo e($loan->term_months); ?>m</td>
                <td class="amount">KSh <?php echo e(number_format($loan->total_amount, 2)); ?></td>
                <td class="amount">KSh <?php echo e(number_format($loan->monthly_payment, 2)); ?></td>
                <td class="status">
                    <span class="badge badge-<?php echo e($loan->status === 'approved' ? 'success' : ($loan->status === 'pending' ? 'warning' : ($loan->status === 'rejected' ? 'danger' : ($loan->status === 'active' ? 'info' : 'secondary')))); ?>">
                        <?php echo e(ucfirst($loan->status)); ?>

                    </span>
                </td>
                <td><?php echo e($loan->approved_at ? $loan->approved_at->format('d M Y') : '-'); ?></td>
                <td><?php echo e($loan->created_at->format('d M Y')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <!-- Summary Section -->
    <div class="summary">
        <h3>Loan Portfolio Summary</h3>
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-value"><?php echo e($loans->count()); ?></div>
                <div class="summary-label">Total Loans</div>
            </div>
            <div class="summary-item">
                <div class="summary-value"><?php echo e($loans->where('status', 'approved')->count()); ?></div>
                <div class="summary-label">Approved</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KSh <?php echo e(number_format($loans->sum('amount'), 2)); ?></div>
                <div class="summary-label">Total Principal</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KSh <?php echo e(number_format($loans->sum('total_amount'), 2)); ?></div>
                <div class="summary-label">Total Amount</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KSh <?php echo e(number_format($loans->avg('amount'), 2)); ?></div>
                <div class="summary-label">Average Loan</div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="no-data">
        <h3>No Loans Found</h3>
        <p>No loans match the specified criteria.</p>
    </div>
    <?php endif; ?>

    <div class="footer">
        <p><strong><?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?> Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> <?php echo e(\App\Models\SystemSetting::get('contact_phone', '+254 700 000 000')); ?> |
            <i class="fas fa-envelope"></i> <?php echo e(\App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke')); ?> |
            <i class="fas fa-map-marker-alt"></i> <?php echo e(\App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya')); ?>

        </p>
        <p>
            <i class="fas fa-globe"></i> <?php echo e(\App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke')); ?> |
            Report generated on <?php echo e(now()->format('l, F j, Y \a\t g:i A')); ?> | Page 1 of 1 | Confidential Document
        </p>
        <p>This is an official report. Please keep for your records.</p>
    </div>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\loans\exports\pdf.blade.php ENDPATH**/ ?>