

<?php $__env->startSection('title', 'Deposit to Savings Account'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <div class="card card-success">
                <div class="card-header">
                    <h3 class="card-title">Deposit Funds</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('savings.show', $saving)); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Account
                        </a>
                    </div>
                </div>

                <form action="<?php echo e(route('savings.deposit', $saving)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <!-- Account Information -->
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-primary">
                                    <div class="card-header">
                                        <h5 class="card-title">Account Information</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <dl class="row">
                                                    <dt class="col-sm-5">Member:</dt>
                                                    <dd class="col-sm-7"><?php echo e($saving->user->full_name); ?></dd>

                                                    <dt class="col-sm-5">Account Type:</dt>
                                                    <dd class="col-sm-7">
                                                        <span class="badge badge-<?php echo e($saving->type_color); ?>">
                                                            <?php echo e($saving->type_label); ?>

                                                        </span>
                                                    </dd>
                                                </dl>
                                            </div>
                                            <div class="col-md-6">
                                                <dl class="row">
                                                    <dt class="col-sm-5">Current Balance:</dt>
                                                    <dd class="col-sm-7">
                                                        <span class="h5 text-success">KSh <?php echo e(number_format($saving->current_balance, 2)); ?></span>
                                                    </dd>

                                                    <dt class="col-sm-5">Account Status:</dt>
                                                    <dd class="col-sm-7">
                                                        <span class="badge badge-<?php echo e($saving->status_color); ?>">
                                                            <?php echo e($saving->status_label); ?>

                                                        </span>
                                                    </dd>
                                                </dl>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Deposit Form -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Deposit Amount (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control form-control-lg <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('amount')); ?>" min="1" step="0.01" required>
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">Enter the amount you want to deposit</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">Transaction Notes</label>
                                    <textarea name="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                              rows="3" placeholder="Optional notes about this deposit"><?php echo e(old('notes')); ?></textarea>
                                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Preview -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-info">
                                    <div class="card-header">
                                        <h5 class="card-title">Transaction Preview</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Current Balance</span>
                                                        <span class="info-box-number" id="current-balance">KSh <?php echo e(number_format($saving->current_balance, 2)); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="info-box bg-success">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Deposit Amount</span>
                                                        <span class="info-box-number" id="deposit-amount">KSh 0.00</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="info-box bg-primary">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">New Balance</span>
                                                        <span class="info-box-number" id="new-balance">KSh <?php echo e(number_format($saving->current_balance, 2)); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="fas fa-plus-circle"></i> Process Deposit
                        </button>
                        <a href="<?php echo e(route('savings.show', $saving)); ?>" class="btn btn-secondary btn-lg">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Quick Stats -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Account Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="description-block">
                                <span class="description-header">KSh <?php echo e(number_format($saving->current_balance, 2)); ?></span>
                                <span class="description-text">CURRENT BALANCE</span>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-6">
                            <div class="description-block">
                                <span class="description-header"><?php echo e($saving->transactions()->where('type', 'deposit')->count()); ?></span>
                                <span class="description-text">DEPOSITS</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="description-block">
                                <span class="description-header"><?php echo e($saving->transactions()->where('type', 'withdrawal')->count()); ?></span>
                                <span class="description-text">WITHDRAWALS</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Transactions</h3>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php $__empty_1 = true; $__currentLoopData = $saving->transactions()->limit(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <span class="badge badge-<?php echo e($transaction->type_color); ?>"><?php echo e($transaction->type_label); ?></span>
                                    <small class="text-muted"><?php echo e($transaction->transaction_date->format('d M Y')); ?></small>
                                </div>
                                <div class="text-right">
                                    <span class="font-weight-bold <?php echo e($transaction->type === 'deposit' ? 'text-success' : 'text-danger'); ?>">
                                        <?php echo e($transaction->formatted_amount); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="list-group-item text-center text-muted">
                            <small>No transactions yet</small>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
$(document).ready(function() {
    function updatePreview() {
        var currentBalance = <?php echo e($saving->current_balance); ?>;
        var depositAmount = parseFloat($('#amount').val()) || 0;
        var newBalance = currentBalance + depositAmount;

        $('#deposit-amount').text('KSh ' + depositAmount.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        $('#new-balance').text('KSh ' + newBalance.toLocaleString('en-KE', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
    }

    $('#amount').on('input', updatePreview);
    updatePreview(); // Initial calculation
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\savings\deposit.blade.php ENDPATH**/ ?>