<?php $__env->startSection('title', 'Savings Account Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Minimalist Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="bg-white border rounded-4 shadow-sm p-4">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <div class="d-flex align-items-center">
                            <div class="bg-light rounded-3 p-3 me-4">
                                <i class="fas fa-piggy-bank fa-2x text-secondary"></i>
                            </div>
                            <div>
                                <h2 class="mb-1 fw-bold text-dark">Savings Account</h2>
                                <p class="mb-2 text-muted">Account #<?php echo e($saving->id); ?></p>
                                <div class="d-flex align-items-center">
                                    <h3 class="mb-0 me-3 fw-bold text-primary">KSh <?php echo e(number_format($saving->current_balance, 0)); ?></h3>
                                    <span class="badge bg-success fs-6"><?php echo e($saving->status_label); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-center">
                        <?php if($saving->user->membership && $saving->user->membership->passport_photo): ?>
                            <img src="<?php echo e(asset('storage/memberships/' . $saving->user->membership->passport_photo)); ?>"
                                 alt="Member Photo"
                                 class="rounded-circle border shadow-sm mb-2"
                                 style="width: 80px; height: 80px; object-fit: cover;">
                        <?php else: ?>
                            <div class="bg-light rounded-circle d-inline-flex align-items-center justify-content-center border mb-2"
                                 style="width: 80px; height: 80px;">
                                <i class="fas fa-user fa-2x text-secondary"></i>
                            </div>
                        <?php endif; ?>
                        <h6 class="fw-bold mb-1"><?php echo e($saving->user->full_name ?? 'N/A'); ?></h6>
                        <small class="text-muted">ID: <?php echo e($saving->user->id_number ?? 'N/A'); ?></small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Compact Stats Widgets -->
    <div class="row mb-4 g-2">
        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="bg-white border rounded-3 shadow-sm p-3 h-100">
                <div class="d-flex align-items-center justify-content-between mb-2">
                    <div class="bg-light rounded-2 p-2">
                        <i class="fas fa-tag text-primary fa-sm"></i>
                    </div>
                    <div class="text-end">
                        <div class="text-muted" style="font-size: 0.75rem;">Account Type</div>
                    </div>
                </div>
                <h5 class="fw-bold text-dark mb-1" style="font-size: 1rem;"><?php echo e($saving->type_label); ?></h5>
                <span class="badge bg-primary" style="font-size: 0.7rem;"><?php echo e($saving->status_label); ?></span>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="bg-white border rounded-3 shadow-sm p-3 h-100">
                <div class="d-flex align-items-center justify-content-between mb-2">
                    <div class="bg-light rounded-2 p-2">
                        <i class="fas fa-arrow-up text-success fa-sm"></i>
                    </div>
                    <div class="text-end">
                        <div class="text-muted" style="font-size: 0.75rem;"><?php echo e($saving->transactions->where('type', 'deposit')->count()); ?> txns</div>
                    </div>
                </div>
                <h5 class="fw-bold text-success mb-1" style="font-size: 1rem;">KSh <?php echo e(number_format($saving->transactions->where('type', 'deposit')->sum('amount'), 0)); ?></h5>
                <div class="text-muted" style="font-size: 0.75rem;">Total Deposits</div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="bg-white border rounded-3 shadow-sm p-3 h-100">
                <div class="d-flex align-items-center justify-content-between mb-2">
                    <div class="bg-light rounded-2 p-2">
                        <i class="fas fa-arrow-down text-warning fa-sm"></i>
                    </div>
                    <div class="text-end">
                        <div class="text-muted" style="font-size: 0.75rem;"><?php echo e($saving->transactions->where('type', 'withdrawal')->count()); ?> txns</div>
                    </div>
                </div>
                <h5 class="fw-bold text-warning mb-1" style="font-size: 1rem;">KSh <?php echo e(number_format($saving->transactions->where('type', 'withdrawal')->sum('amount'), 0)); ?></h5>
                <div class="text-muted" style="font-size: 0.75rem;">Total Withdrawals</div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="bg-white border rounded-3 shadow-sm p-3 h-100">
                <div class="d-flex align-items-center justify-content-between mb-2">
                    <div class="bg-light rounded-2 p-2">
                        <i class="fas fa-calendar text-info fa-sm"></i>
                    </div>
                    <div class="text-end">
                        <div class="text-muted" style="font-size: 0.75rem;">Since <?php echo e($saving->created_at->format('M Y')); ?></div>
                    </div>
                </div>
                <h5 class="fw-bold text-info mb-1" style="font-size: 1rem;"><?php echo e($saving->created_at->diffInDays(now())); ?> Days</h5>
                <div class="text-muted" style="font-size: 0.75rem;">Account Age</div>
            </div>
        </div>
    </div>

    <!-- Clean Member Info -->
    <div class="row mb-4 g-3">
        <div class="col-md-6">
            <div class="bg-white border rounded-4 shadow-sm p-4 h-100">
                <div class="d-flex align-items-center mb-4">
                    <i class="fas fa-user-circle text-primary fa-2x me-3"></i>
                    <div>
                        <h5 class="fw-bold mb-0">Personal Information</h5>
                        <small class="text-muted">Member details</small>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Full Name</small>
                            <strong class="d-block"><?php echo e($saving->user->full_name ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">ID Number</small>
                            <strong class="d-block"><?php echo e($saving->user->id_number ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Phone</small>
                            <strong class="d-block"><?php echo e($saving->user->phone_number ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Email</small>
                            <small class="d-block fw-bold"><?php echo e($saving->user->email ?? 'N/A'); ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="bg-white border rounded-4 shadow-sm p-4 h-100">
                <div class="d-flex align-items-center mb-4">
                    <i class="fas fa-building text-success fa-2x me-3"></i>
                    <div>
                        <h5 class="fw-bold mb-0">Membership Details</h5>
                        <small class="text-muted">Branch & membership info</small>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Membership #</small>
                            <strong class="d-block"><?php echo e($saving->user->membership->membership_number ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Branch</small>
                            <strong class="d-block"><?php echo e($saving->user->branch->name ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Member Since</small>
                            <strong class="d-block"><?php echo e($saving->user->membership->created_at->format('M Y') ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="border rounded-3 p-3 text-center">
                            <small class="text-muted d-block">Total Accounts</small>
                            <strong class="d-block text-success fs-4"><?php echo e($saving->user->savings->count()); ?></strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Compact Actions -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="bg-light border rounded-4 p-3">
                <h6 class="fw-bold text-center mb-3">Quick Actions</h6>
                <div class="d-flex justify-content-center flex-wrap gap-2">
                    <a href="<?php echo e(route('savings.deposit.form', $saving)); ?>" class="btn btn-primary rounded-pill px-3 py-2" style="font-size: 0.875rem;">
                        <i class="fas fa-plus me-1"></i> Add Savings
                    </a>
                    <?php if($saving->current_balance > 0): ?>
                    <a href="<?php echo e(route('savings.withdraw.form', $saving)); ?>" class="btn btn-warning rounded-pill px-3 py-2" style="font-size: 0.875rem;">
                        <i class="fas fa-minus me-1"></i> Withdraw
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('savings.download.plan', $saving)); ?>" class="btn btn-success rounded-pill px-3 py-2" style="font-size: 0.875rem;" target="_blank">
                        <i class="fas fa-download me-1"></i> Download
                    </a>
                    <a href="<?php echo e(route('savings.edit', $saving)); ?>" class="btn btn-secondary rounded-pill px-3 py-2" style="font-size: 0.875rem;">
                        <i class="fas fa-edit me-1"></i> Edit
                    </a>
                    <a href="<?php echo e(route('savings.index')); ?>" class="btn btn-outline-dark rounded-pill px-3 py-2" style="font-size: 0.875rem;">
                        <i class="fas fa-arrow-left me-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

<?php if($saving->notes): ?>
<!-- Notes Section -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title"><i class="fas fa-sticky-note"></i> Account Notes</h5>
            </div>
            <div class="card-body">
                <div class="border p-3 bg-light rounded">
                    <?php echo e($saving->notes); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Transaction History -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-history"></i> Transaction History</h3>
                <div class="card-tools">
                    <span class="badge badge-primary"><?php echo e($saving->transactions->count()); ?> transactions</span>
                </div>
            </div>
            <div class="card-body table-responsive p-0">
                <?php if($saving->transactions->count() > 0): ?>
                <table class="table table-hover text-nowrap table-sm compact-table">
                    <thead class="thead-light">
                        <tr>
                            <th class="compact-th">Date</th>
                            <th class="compact-th">Transaction #</th>
                            <th class="compact-th">Type</th>
                            <th class="compact-th">Amount</th>
                            <th class="compact-th">Balance After</th>
                            <th class="compact-th">Processed By</th>
                            <th class="compact-th">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $saving->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="compact-row">
                            <td class="compact-td"><?php echo e($transaction->transaction_date->format('d M Y H:i')); ?></td>
                            <td class="compact-td">
                                <code><?php echo e($transaction->transaction_number); ?></code>
                            </td>
                            <td class="compact-td">
                                <span class="badge badge-sm badge-<?php echo e($transaction->type_color); ?>">
                                    <?php echo e($transaction->type_label); ?>

                                </span>
                            </td>
                            <td class="compact-td">
                                <span class="font-weight-bold <?php echo e($transaction->type === 'deposit' ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e($transaction->formatted_amount); ?>

                                </span>
                            </td>
                            <td class="compact-td">KSh <?php echo e(number_format($transaction->balance_after, 0)); ?></td>
                            <td class="compact-td"><?php echo e($transaction->processor->name ?? 'System'); ?></td>
                            <td class="compact-td">
                                <a href="<?php echo e(route('savings.transaction.receipt', $transaction)); ?>" class="btn btn-outline-sleek btn-xs" title="View Receipt">
                                    <i class="fas fa-receipt"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php else: ?>
                <div class="text-center py-4">
                    <div class="text-muted">
                        <i class="fas fa-inbox fa-3x mb-3"></i>
                        <h5>No Transactions Yet</h5>
                        <p>Start by making a deposit or withdrawal to see transaction history.</p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Account Timeline -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-timeline"></i> Account Timeline</h3>
            </div>
            <div class="card-body">
                <div class="timeline">
                    <div class="time-label">
                        <span class="bg-primary"><?php echo e($saving->created_at->format('d M Y')); ?></span>
                    </div>
                    <div>
                        <i class="fas fa-plus bg-green"></i>
                        <div class="timeline-item">
                            <span class="time"><i class="fas fa-clock"></i> <?php echo e($saving->created_at->format('H:i')); ?></span>
                            <h3 class="timeline-header">Savings Account Created</h3>
                            <div class="timeline-body">
                                Initial deposit of KSh <?php echo e(number_format($saving->amount, 2)); ?> for <?php echo e($saving->type_label); ?>

                            </div>
                        </div>
                    </div>

                    <?php if($saving->status === 'withdrawn'): ?>
                    <div class="time-label">
                        <span class="bg-warning"><?php echo e(now()->format('d M Y')); ?></span>
                    </div>
                    <div>
                        <i class="fas fa-money-bill-wave bg-orange"></i>
                        <div class="timeline-item">
                            <span class="time"><i class="fas fa-clock"></i> <?php echo e(now()->format('H:i')); ?></span>
                            <h3 class="timeline-header">Account Withdrawn</h3>
                            <div class="timeline-body">
                                Savings account has been withdrawn
                            </div>
                        </div>
                    </div>
                    <?php elseif($saving->status === 'matured'): ?>
                    <div class="time-label">
                        <span class="bg-success"><?php echo e(now()->format('d M Y')); ?></span>
                    </div>
                    <div>
                        <i class="fas fa-check-circle bg-green"></i>
                        <div class="timeline-item">
                            <span class="time"><i class="fas fa-clock"></i> <?php echo e(now()->format('H:i')); ?></span>
                            <h3 class="timeline-header">Account Matured</h3>
                            <div class="timeline-body">
                                Fixed deposit account has matured and is ready for withdrawal
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div>
                        <i class="fas fa-clock bg-gray"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
<?php $__env->stopSection(); ?>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.border-left-danger {
    border-left: 4px solid #e74a3b !important;
}

.border-left-secondary {
    border-left: 4px solid #858796 !important;
}

.border-left-dark {
    border-left: 4px solid #5a5c69 !important;
}

.border-left-light {
    border-left: 4px solid #f8f9fc !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact savings card styling */
.compact-savings-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-savings-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-savings-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-savings-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-danger {
    color: #e74a3b !important;
}

.text-secondary {
    color: #858796 !important;
}

.text-dark {
    color: #5a5c69 !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

/* Sleek Button Styling */
.btn-sleek {
    border: none !important;
    border-radius: 12px !important;
    padding: 12px 24px !important;
    font-weight: 600 !important;
    font-size: 14px !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
    position: relative !important;
    overflow: hidden !important;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
}

.btn-sleek:before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.btn-sleek:hover:before {
    left: 100%;
}

.btn-sleek:hover {
    transform: translateY(-2px) !important;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15) !important;
}

.btn-sleek:active {
    transform: translateY(0) !important;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2) !important;
}

/* Primary Button */
.btn-sleek.btn-primary {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%) !important;
    color: white !important;
}

.btn-sleek.btn-primary:hover {
    background: linear-gradient(135deg, #0056b3 0%, #004085 100%) !important;
}

/* Success Button */
.btn-sleek.btn-success {
    background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%) !important;
    color: white !important;
}

.btn-sleek.btn-success:hover {
    background: linear-gradient(135deg, #1e7e34 0%, #155724 100%) !important;
}

/* Warning Button */
.btn-sleek.btn-warning {
    background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%) !important;
    color: #212529 !important;
}

.btn-sleek.btn-warning:hover {
    background: linear-gradient(135deg, #e0a800 0%, #d39e00 100%) !important;
}

/* Secondary Button */
.btn-sleek.btn-secondary {
    background: linear-gradient(135deg, #6c757d 0%, #545b62 100%) !important;
    color: white !important;
}

.btn-sleek.btn-secondary:hover {
    background: linear-gradient(135deg, #545b62 0%, #3d4142 100%) !important;
}

/* Dark Button */
.btn-sleek.btn-dark {
    background: linear-gradient(135deg, #343a40 0%, #23272b 100%) !important;
    color: white !important;
}

.btn-sleek.btn-dark:hover {
    background: linear-gradient(135deg, #23272b 0%, #1d2124 100%) !important;
}

/* Large Button Enhancements */
.btn-sleek.btn-lg {
    padding: 15px 30px !important;
    font-size: 16px !important;
    border-radius: 15px !important;
}

/* Outline Sleek Buttons with Different Colors */
.btn-outline-success-sleek {
    background: transparent !important;
    border: 2px solid #28a745 !important;
    color: #28a745 !important;
    padding: 8px 16px !important;
    font-size: 13px !important;
    border-radius: 8px !important;
    font-weight: 600 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s ease !important;
}

.btn-outline-success-sleek:hover {
    background: #28a745 !important;
    color: white !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3) !important;
}

.btn-outline-warning-sleek {
    background: transparent !important;
    border: 2px solid #ffc107 !important;
    color: #ffc107 !important;
    padding: 8px 16px !important;
    font-size: 13px !important;
    border-radius: 8px !important;
    font-weight: 600 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s ease !important;
}

.btn-outline-warning-sleek:hover {
    background: #ffc107 !important;
    color: #212529 !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 15px rgba(255, 193, 7, 0.3) !important;
}

.btn-outline-primary-sleek {
    background: transparent !important;
    border: 2px solid #007bff !important;
    color: #007bff !important;
    padding: 8px 16px !important;
    font-size: 13px !important;
    border-radius: 8px !important;
    font-weight: 600 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s ease !important;
}

.btn-outline-primary-sleek:hover {
    background: #007bff !important;
    color: white !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3) !important;
}

.btn-outline-info-sleek {
    background: transparent !important;
    border: 2px solid #17a2b8 !important;
    color: #17a2b8 !important;
    padding: 8px 16px !important;
    font-size: 13px !important;
    border-radius: 8px !important;
    font-weight: 600 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s ease !important;
}

.btn-outline-info-sleek:hover {
    background: #17a2b8 !important;
    color: white !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 15px rgba(23, 162, 184, 0.3) !important;
}

.btn-outline-dark-sleek {
    background: transparent !important;
    border: 2px solid #343a40 !important;
    color: #343a40 !important;
    padding: 8px 16px !important;
    font-size: 13px !important;
    border-radius: 8px !important;
    font-weight: 600 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s ease !important;
}

.btn-outline-dark-sleek:hover {
    background: #343a40 !important;
    color: white !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 15px rgba(52, 58, 64, 0.3) !important;
}

.btn-outline-sleek {
    background: transparent !important;
    border: 2px solid #28a745 !important;
    color: #28a745 !important;
    padding: 8px 16px !important;
    font-size: 13px !important;
    border-radius: 8px !important;
    font-weight: 600 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
    transition: all 0.3s ease !important;
}

.btn-outline-sleek:hover {
    border-color: #dc3545 !important;
    color: #dc3545 !important;
    background: transparent !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3) !important;
}

.btn-outline-sleek i {
    margin-right: 6px !important;
}

/* Icon Spacing */
.btn-sleek i {
    margin-right: 8px !important;
}

/* Button Styling */
.btn {
    border-radius: 8px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.btn-lg {
    padding: 0.75rem 1.5rem;
    font-size: 1rem;
}

/* Timeline Enhancements */
.timeline .timeline-item {
    transition: all 0.3s ease !important;
}

.timeline .timeline-item:hover {
    background-color: rgba(0, 0, 0, 0.02) !important;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }

    .btn-group .btn {
        margin-bottom: 0.5rem;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\savings\show.blade.php ENDPATH**/ ?>