<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Morio Sacco')); ?> - Member Portal</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Custom CSS -->
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        .member-sidebar {
            background: linear-gradient(180deg, #247f1b 0%, #2d8a1f 100%);
            min-height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            width: 250px;
            z-index: 1000;
        }

        .member-sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8) !important;
            transition: all 0.3s ease;
        }

        .member-sidebar .nav-link:hover {
            color: white !important;
            background-color: rgba(255, 255, 255, 0.1) !important;
        }

        .member-sidebar .nav-link.active {
            background-color: #ff3c30 !important;
            color: white !important;
        }

        .member-content {
            margin-left: 250px;
            min-height: 100vh;
        }

        .member-header {
            background: white;
            border-bottom: 1px solid #e9ecef;
            padding: 1rem 2rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        @media (max-width: 768px) {
            .member-sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }

            .member-sidebar.show {
                transform: translateX(0);
            }

            .member-content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100">
        <!-- Sidebar -->
        <nav class="member-sidebar">
            <div class="p-4">
                <div class="flex items-center mb-8">
                    <img src="<?php echo e(asset('images/morio-sacco-logo.png')); ?>" alt="Morio Sacco" class="h-10 w-auto mr-3">
                    <div class="text-white">
                        <div class="font-bold text-lg">Morio Sacco</div>
                        <div class="text-xs opacity-75">Member Portal</div>
                    </div>
                </div>

                <ul class="space-y-2">
                    <li>
                        <a href="<?php echo e(route('member.dashboard')); ?>" class="nav-link block px-4 py-3 rounded-lg <?php echo e(request()->routeIs('member.dashboard') ? 'active' : ''); ?>">
                            <i class="fas fa-tachometer-alt mr-3"></i> Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('member.loans.index')); ?>" class="nav-link block px-4 py-3 rounded-lg <?php echo e(request()->routeIs('member.loans.*') ? 'active' : ''); ?>">
                            <i class="fas fa-money-bill-wave mr-3"></i> My Loans
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('member.savings.index')); ?>" class="nav-link block px-4 py-3 rounded-lg <?php echo e(request()->routeIs('member.savings.*') ? 'active' : ''); ?>">
                            <i class="fas fa-piggy-bank mr-3"></i> My Savings
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('member.money-market.index')); ?>" class="nav-link block px-4 py-3 rounded-lg <?php echo e(request()->routeIs('member.money-market.*') ? 'active' : ''); ?>">
                            <i class="fas fa-chart-line mr-3"></i> Money Market
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('member.profile')); ?>" class="nav-link block px-4 py-3 rounded-lg <?php echo e(request()->routeIs('member.profile*') ? 'active' : ''); ?>">
                            <i class="fas fa-user mr-3"></i> My Profile
                        </a>
                    </li>
                    <li class="pt-4 border-t border-white/20">
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="nav-link w-full text-left px-4 py-3 rounded-lg hover:bg-white/10">
                                <i class="fas fa-sign-out-alt mr-3"></i> Logout
                            </button>
                        </form>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="member-content">
            <!-- Header -->
            <header class="member-header">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800"><?php echo e($title ?? 'Dashboard'); ?></h1>
                        <p class="text-gray-600">Welcome back, <?php echo e(auth()->user()->first_name); ?>!</p>
                    </div>
                    <div class="flex items-center space-x-4">
                        <div class="text-right">
                            <div class="text-sm text-gray-600"><?php echo e(auth()->user()->full_name); ?></div>
                            <div class="text-xs text-gray-500">Member ID: <?php echo e(auth()->user()->membership->membership_number ?? 'N/A'); ?></div>
                        </div>
                        <div class="w-10 h-10 bg-primary rounded-full flex items-center justify-center text-white font-bold">
                            <?php echo e(strtoupper(substr(auth()->user()->first_name, 0, 1))); ?>

                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="p-6">
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <!-- Success Message -->
    <?php if(session('success')): ?>
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: '<?php echo e(session("success")); ?>',
            timer: 3000,
            showConfirmButton: false
        });
    </script>
    <?php endif; ?>

    <!-- Error Message -->
    <?php if(session('error')): ?>
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '<?php echo e(session("error")); ?>',
            timer: 3000,
            showConfirmButton: false
        });
    </script>
    <?php endif; ?>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white text-center py-4 mt-8">
        <div class="container mx-auto">
            <?php echo \App\Models\SystemSetting::get('system_footer', '&copy; ' . date('Y') . ' Morio Sacco. All rights reserved.'); ?>

        </div>
    </footer>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\member\layout.blade.php ENDPATH**/ ?>