<?php $__env->startSection('title', 'Occupations'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Occupations Management</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
<!-- Compact Statistics Cards - Occupation Management Overview -->
<div class="row mb-3">
    <!-- Total Occupations -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-occupations-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Occupations
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($occupations->total()); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-briefcase mr-1"></i>
                            Available occupations
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                            <i class="fas fa-briefcase"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Occupations -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-occupations-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Active Occupations
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($occupations->where('is_active', true)->count()); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-check-circle mr-1"></i>
                            Currently available
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Inactive Occupations -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-occupations-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Inactive Occupations
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($occupations->where('is_active', false)->count()); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-pause-circle mr-1"></i>
                            Temporarily disabled
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                            <i class="fas fa-pause-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Used by Members -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-occupations-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Used by Members
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(\App\Models\Membership::distinct('occupation')->count('occupation')); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-users mr-1"></i>
                            Unique occupations in use
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Occupations Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Occupation List</h3>
                    <div class="card-tools">
                        <div class="btn-group" role="group">
                            <a href="<?php echo e(route('occupations.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Add New Occupation
                            </a>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-download"></i> Export
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="<?php echo e(route('occupations.export.pdf')); ?>" target="_blank">
                                        <i class="fas fa-file-pdf text-danger"></i> Export as PDF
                                    </a>
                                    <a class="dropdown-item" href="<?php echo e(route('occupations.export.excel')); ?>">
                                        <i class="fas fa-file-excel text-success"></i> Export as Excel
                                    </a>
                                    <a class="dropdown-item" href="<?php echo e(route('occupations.export.csv')); ?>">
                                        <i class="fas fa-file-csv text-info"></i> Export as CSV
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th">ID</th>
                                <th class="compact-th">Name</th>
                                <th class="compact-th d-none d-lg-table-cell">Description</th>
                                <th class="compact-th d-none d-md-table-cell">Sort</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th d-none d-md-table-cell">Created</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $occupations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $occupation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="compact-row">
                                <td class="compact-td"><?php echo e($occupation->id); ?></td>
                                <td class="compact-td">
                                    <div class="font-weight-medium"><?php echo e(Str::limit($occupation->name, 20)); ?></div>
                                </td>
                                <td class="compact-td d-none d-lg-table-cell"><?php echo e($occupation->description ? Str::limit($occupation->description, 30) : 'N/A'); ?></td>
                                <td class="compact-td d-none d-md-table-cell"><?php echo e($occupation->sort_order); ?></td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-<?php echo e($occupation->is_active ? 'success' : 'secondary'); ?>">
                                        <?php echo e($occupation->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </td>
                                <td class="compact-td d-none d-md-table-cell"><?php echo e($occupation->created_at->format('d M')); ?></td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="<?php echo e(route('occupations.show', $occupation)); ?>" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('occupations.edit', $occupation)); ?>" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('occupations.toggle-status', $occupation)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <button type="submit" class="btn btn-<?php echo e($occupation->is_active ? 'secondary' : 'success'); ?> btn-xs"
                                                    title="<?php echo e($occupation->is_active ? 'Deactivate' : 'Activate'); ?>">
                                                <i class="fas fa-<?php echo e($occupation->is_active ? 'pause' : 'play'); ?>"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('occupations.destroy', $occupation)); ?>" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this occupation?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-briefcase fa-3x mb-3"></i>
                                        <h5>No Occupations Found</h5>
                                        <p>Start by adding your first occupation to the system.</p>
                                        <a href="<?php echo e(route('occupations.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add First Occupation
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($occupations->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($occupations->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact occupations card styling - smaller than shares page */
.compact-occupations-card {
    height: 70px;
    margin-bottom: 0.5rem !important;
}

.compact-occupations-card .card-body {
    padding: 0.5rem 0.75rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-occupations-card .h6 {
    font-size: 1rem;
    line-height: 1.2;
}

.compact-occupations-card .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.compact-occupations-card .bg-primary,
.compact-occupations-card .bg-success,
.compact-occupations-card .bg-warning,
.compact-occupations-card .bg-info {
    width: 30px !important;
    height: 30px !important;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});

<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\occupations\index.blade.php ENDPATH**/ ?>