<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Morio Sacco - Shares Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 10px;
        }
        .title {
            font-size: 24px;
            font-weight: bold;
            color: #247f1b;
            margin: 10px 0;
        }
        .subtitle {
            font-size: 14px;
            color: #666;
        }
        .report-info {
            margin-bottom: 30px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .info-label {
            font-weight: bold;
            width: 150px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .qr-code {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 80px;
            height: 80px;
        }
        .stats {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .stats h4 {
            margin-top: 0;
            color: #247f1b;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">Morio Sacco</div>
        <div class="subtitle">Shares Report</div>
        <div class="subtitle">Generated on <?php echo e(date('F j, Y \a\t g:i A')); ?></div>
    </div>

    <div class="report-info">
        <div class="info-row">
            <span class="info-label">Total Share Purchases:</span>
            <span><?php echo e($shares->count()); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Total Shares:</span>
            <span><?php echo e(number_format($shares->sum('number_of_shares'))); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Total Value:</span>
            <span>KES <?php echo e(number_format($shares->sum('total_value'), 2)); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Report Date:</span>
            <span><?php echo e(date('Y-m-d H:i:s')); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Generated By:</span>
            <span><?php echo e(auth()->user()->full_name ?? 'System'); ?></span>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Member Name</th>
                <th>Membership #</th>
                <th>Shares</th>
                <th>Share Value</th>
                <th>Total Value</th>
                <th>Purchase Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $shares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $share): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($share->id); ?></td>
                <td><?php echo e($share->user->full_name ?? 'N/A'); ?></td>
                <td><?php echo e($share->user->membership_number ?? 'N/A'); ?></td>
                <td><?php echo e(number_format($share->number_of_shares)); ?></td>
                <td>KES <?php echo e(number_format($share->share_value, 2)); ?></td>
                <td>KES <?php echo e(number_format($share->total_value, 2)); ?></td>
                <td><?php echo e($share->purchase_date ? $share->purchase_date->format('Y-m-d') : 'N/A'); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="stats">
        <h4>Summary Statistics</h4>
        <div class="info-row">
            <span class="info-label">Average Shares per Purchase:</span>
            <span><?php echo e($shares->count() > 0 ? round($shares->avg('number_of_shares'), 1) : 0); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Average Share Value:</span>
            <span>KES <?php echo e($shares->count() > 0 ? number_format($shares->avg('share_value'), 2) : '0.00'); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Largest Purchase:</span>
            <span><?php echo e($shares->sortByDesc('total_value')->first()->user->full_name ?? 'N/A'); ?> (KES <?php echo e(number_format($shares->max('total_value'), 2)); ?>)</span>
        </div>
        <div class="info-row">
            <span class="info-label">Most Recent Purchase:</span>
            <span><?php echo e($shares->sortByDesc('purchase_date')->first()->user->full_name ?? 'N/A'); ?> (<?php echo e($shares->sortByDesc('purchase_date')->first()->purchase_date->format('M d, Y') ?? 'N/A'); ?>)</span>
        </div>
    </div>

    <div class="footer">
        <p><strong><?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?> Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> <?php echo e(\App\Models\SystemSetting::get('contact_phone', '+254 700 000 000')); ?> |
            <i class="fas fa-envelope"></i> <?php echo e(\App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke')); ?> |
            <i class="fas fa-map-marker-alt"></i> <?php echo e(\App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya')); ?>

        </p>
        <p>
            <i class="fas fa-globe"></i> <?php echo e(\App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke')); ?> |
            Report generated on <?php echo e(now()->format('l, F j, Y \a\t g:i A')); ?> | Confidential Document
        </p>
        <p>© <?php echo e(date('Y')); ?> <?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?>. All rights reserved.</p>
    </div>

    <!-- QR Code for App URL -->
    <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo e(urlencode(config('app.url'))); ?>" alt="QR Code" class="qr-code">
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\shares\exports\pdf.blade.php ENDPATH**/ ?>