

<?php $__env->startSection('title', 'Add M-Pesa Credentials'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa API Configuration</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('mpesa-credentials.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Credentials
                        </a>
                    </div>
                </div>
                <form action="<?php echo e(route('mpesa-credentials.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <h5><i class="icon fas fa-exclamation-triangle"></i> Security Notice</h5>
                            <p>Keep your M-Pesa credentials secure. Never share them publicly or commit them to version control.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="consumer_key">Consumer Key <span class="text-danger">*</span></label>
                                    <input type="text" name="consumer_key" id="consumer_key"
                                           class="form-control <?php $__errorArgs = ['consumer_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('consumer_key')); ?>" required>
                                    <small class="form-text text-muted">From Safaricom Developer Portal</small>
                                    <?php $__errorArgs = ['consumer_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="consumer_secret">Consumer Secret <span class="text-danger">*</span></label>
                                    <input type="password" name="consumer_secret" id="consumer_secret"
                                           class="form-control <?php $__errorArgs = ['consumer_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('consumer_secret')); ?>" required>
                                    <small class="form-text text-muted">From Safaricom Developer Portal</small>
                                    <?php $__errorArgs = ['consumer_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="shortcode">Shortcode <span class="text-danger">*</span></label>
                                    <input type="text" name="shortcode" id="shortcode"
                                           class="form-control <?php $__errorArgs = ['shortcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('shortcode')); ?>" required>
                                    <small class="form-text text-muted">Your M-Pesa business shortcode</small>
                                    <?php $__errorArgs = ['shortcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="passkey">Passkey <span class="text-danger">*</span></label>
                                    <input type="text" name="passkey" id="passkey"
                                           class="form-control <?php $__errorArgs = ['passkey'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           value="<?php echo e(old('passkey')); ?>" required>
                                    <small class="form-text text-muted">Your M-Pesa passkey</small>
                                    <?php $__errorArgs = ['passkey'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="environment">Environment <span class="text-danger">*</span></label>
                                    <select name="environment" id="environment" class="form-control <?php $__errorArgs = ['environment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="sandbox" <?php echo e(old('environment', 'sandbox') == 'sandbox' ? 'selected' : ''); ?>>Sandbox (Testing)</option>
                                        <option value="production" <?php echo e(old('environment') == 'production' ? 'selected' : ''); ?>>Production (Live)</option>
                                    </select>
                                    <small class="form-text text-muted">Use sandbox for testing, production for live payments</small>
                                    <?php $__errorArgs = ['environment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_active">Status</label>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" name="is_active" id="is_active"
                                               class="custom-control-input" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="is_active">Active</label>
                                    </div>
                                    <small class="form-text text-muted">Only one set of credentials can be active at a time</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="alert alert-info">
                                <h6><i class="icon fas fa-info-circle"></i> Environment Information</h6>
                                <div id="sandbox-info" style="<?php echo e(old('environment', 'sandbox') == 'sandbox' ? '' : 'display: none;'); ?>">
                                    <strong>Sandbox (Testing) Environment:</strong>
                                    <ul class="mb-0 mt-1">
                                        <li>Use for development and testing</li>
                                        <li>No real money transactions</li>
                                        <li>Test credentials from developer portal</li>
                                    </ul>
                                </div>
                                <div id="production-info" style="<?php echo e(old('environment') == 'production' ? '' : 'display: none;'); ?>">
                                    <strong>Production (Live) Environment:</strong>
                                    <ul class="mb-0 mt-1">
                                        <li>Use for real customer payments</li>
                                        <li>Real money transactions</li>
                                        <li>Production credentials required</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save M-Pesa Credentials
                        </button>
                        <a href="<?php echo e(route('mpesa-credentials.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const environmentSelect = document.getElementById('environment');
    const sandboxInfo = document.getElementById('sandbox-info');
    const productionInfo = document.getElementById('production-info');

    environmentSelect.addEventListener('change', function() {
        if (this.value === 'sandbox') {
            sandboxInfo.style.display = 'block';
            productionInfo.style.display = 'none';
        } else {
            sandboxInfo.style.display = 'none';
            productionInfo.style.display = 'block';
        }
    });
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\mpesa-credentials\create.blade.php ENDPATH**/ ?>