

<?php $__env->startSection('title', 'Loan Performance Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Export Options -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="btn-group">
                <a href="<?php echo e(route('reports.loanPerformance', ['export' => 'pdf', 'format' => 'pdf'])); ?>"
                   class="btn btn-danger" target="_blank">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="<?php echo e(route('reports.loanPerformance', ['export' => 'excel', 'format' => 'excel'])); ?>"
                   class="btn btn-success" target="_blank">
                    <i class="fas fa-file-excel"></i> Export Excel
                </a>
            </div>
        </div>
    </div>

    <!-- Loan Status Analysis -->
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-chart-bar mr-2"></i>Loans by Status
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Amount</th>
                                    <th class="text-right">Average Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data['by_status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $stats): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <span class="badge badge-<?php echo e($status === 'approved' ? 'success' : ($status === 'pending' ? 'warning' : ($status === 'active' ? 'info' : 'danger'))); ?>">
                                            <?php echo e(ucfirst($status)); ?>

                                        </span>
                                    </td>
                                    <td class="text-center"><?php echo e(number_format($stats['count'])); ?></td>
                                    <td class="text-right">KSh <?php echo e(number_format($stats['total_amount'], 2)); ?></td>
                                    <td class="text-right">KSh <?php echo e(number_format($stats['average_amount'], 2)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loan Term Analysis -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-clock mr-2"></i>Loans by Term
                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Term (Months)</th>
                                    <th class="text-center">Count</th>
                                    <th class="text-right">Total Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data['by_term']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term => $stats): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($term); ?> months</td>
                                    <td class="text-center"><?php echo e(number_format($stats['count'])); ?></td>
                                    <td class="text-right">KSh <?php echo e(number_format($stats['total_amount'], 2)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Repayment Performance -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-hand-holding-usd mr-2"></i>Repayment Performance
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box bg-success">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Disbursed</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format($data['repayment_performance']['total_disbursed'], 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-info">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Repaid</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format($data['repayment_performance']['total_repaid'], 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-warning">
                                <div class="info-box-content">
                                    <span class="info-box-text">Outstanding Balance</span>
                                    <span class="info-box-number">
                                        KSh <?php echo e(number_format($data['repayment_performance']['outstanding_balance'], 2)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Repayment Rate -->
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card card-outline card-primary">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h5>Repayment Rate</h5>
                                            <?php
                                                $repaymentRate = $data['repayment_performance']['total_disbursed'] > 0
                                                    ? ($data['repayment_performance']['total_repaid'] / $data['repayment_performance']['total_disbursed']) * 100
                                                    : 0;
                                            ?>
                                            <div class="progress">
                                                <div class="progress-bar bg-success" role="progressbar"
                                                     style="width: <?php echo e($repaymentRate); ?>%"
                                                     aria-valuenow="<?php echo e($repaymentRate); ?>"
                                                     aria-valuemin="0" aria-valuemax="100">
                                                    <?php echo e(number_format($repaymentRate, 1)); ?>%
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <h5>Portfolio Health</h5>
                                            <?php
                                                $healthScore = 100 - (($data['repayment_performance']['outstanding_balance'] / max($data['repayment_performance']['total_disbursed'], 1)) * 100);
                                            ?>
                                            <div class="progress">
                                                <div class="progress-bar <?php echo e($healthScore > 70 ? 'bg-success' : ($healthScore > 50 ? 'bg-warning' : 'bg-danger')); ?>"
                                                     role="progressbar"
                                                     style="width: <?php echo e(max(0, $healthScore)); ?>%"
                                                     aria-valuenow="<?php echo e($healthScore); ?>"
                                                     aria-valuemin="0" aria-valuemax="100">
                                                    <?php echo e(number_format(max(0, $healthScore), 1)); ?>%
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Risk Analysis -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-exclamation-triangle mr-2"></i>Risk Analysis
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-box bg-warning">
                                <div class="info-box-content">
                                    <span class="info-box-text">Overdue Loans</span>
                                    <span class="info-box-number"><?php echo e(number_format($data['default_risk']['overdue_loans'])); ?></span>
                                    <div class="progress">
                                        <div class="progress-bar bg-warning" role="progressbar"
                                             style="width: <?php echo e(count($data['by_status']) > 0 ? ($data['default_risk']['overdue_loans'] / collect($data['by_status'])->sum('count')) * 100 : 0); ?>%"
                                             aria-valuenow="<?php echo e($data['default_risk']['overdue_loans']); ?>"
                                             aria-valuemin="0" aria-valuemax="100">
                                        </div>
                                    </div>
                                    <span class="progress-description">
                                        Loans overdue by 6+ months
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box bg-danger">
                                <div class="info-box-content">
                                    <span class="info-box-text">High-Value Loans</span>
                                    <span class="info-box-number"><?php echo e(number_format($data['default_risk']['high_value_loans'])); ?></span>
                                    <div class="progress">
                                        <div class="progress-bar bg-danger" role="progressbar"
                                             style="width: <?php echo e(count($data['by_status']) > 0 ? ($data['default_risk']['high_value_loans'] / collect($data['by_status'])->sum('count')) * 100 : 0); ?>%"
                                             aria-valuenow="<?php echo e($data['default_risk']['high_value_loans']); ?>"
                                             aria-valuemin="0" aria-valuemax="100">
                                        </div>
                                    </div>
                                    <span class="progress-description">
                                        Loans over KSh 100,000
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Loan Portfolio Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3><?php echo e(collect($data['by_status'])->sum('count')); ?></h3>
                                    <p>Total Loans</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>KSh <?php echo e(number_format(collect($data['by_status'])->sum('total_amount'), 2)); ?></h3>
                                    <p>Total Loan Amount</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3><?php echo e(collect($data['by_status'])->where('status', 'active')->sum('count')); ?></h3>
                                    <p>Active Loans</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-play"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>
                                        KSh <?php echo e(number_format(collect($data['by_status'])->sum('total_amount') / max(collect($data['by_status'])->sum('count'), 1), 2)); ?>

                                    </h3>
                                    <p>Average Loan Size</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calculator"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\reports\loan-performance.blade.php ENDPATH**/ ?>