<div class="container-fluid">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-primary" style="background: linear-gradient(45deg, #247f1b, #17a2b8); border: none; color: white;">
                <h4><i class="fas fa-user"></i> Welcome to Your Dashboard, <?php echo e(auth()->user()->full_name); ?>!</h4>
                <p class="mb-0">Manage your Sacco account, view your finances, and access member services.</p>
            </div>
        </div>
    </div>

    <!-- Account Overview -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>KES <?php echo e(number_format($stats['savings'], 0)); ?></h3>
                    <p>Total Savings</p>
                </div>
                <div class="icon">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <a href="<?php echo e(route('savings.index')); ?>" class="small-box-footer">
                    View Details <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>KES <?php echo e(number_format($stats['shares'], 0)); ?></h3>
                    <p>Share Capital</p>
                </div>
                <div class="icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <a href="<?php echo e(route('shares.index')); ?>" class="small-box-footer">
                    View Shares <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e($stats['loans']->count()); ?></h3>
                    <p>Active Loans</p>
                </div>
                <div class="icon">
                    <i class="fas fa-hand-holding-usd"></i>
                </div>
                <a href="<?php echo e(route('loans.index')); ?>" class="small-box-footer">
                    View Loans <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>KES <?php echo e(number_format($stats['dividends'], 0)); ?></h3>
                    <p>Dividends Earned</p>
                </div>
                <div class="icon">
                    <i class="fas fa-gift"></i>
                </div>
                <a href="<?php echo e(route('dividends.index')); ?>" class="small-box-footer">
                    View Dividends <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Activity and Quick Actions -->
    <div class="row">
        <!-- Recent Transactions -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Transactions</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $stats['recent_transactions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <span class="badge badge-<?php echo e($transaction->type == 'loan_repayment' ? 'warning' : ($transaction->type == 'savings_deposit' ? 'success' : 'info')); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <strong>KES <?php echo e(number_format($transaction->amount, 2)); ?></strong>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo e($transaction->status == 'completed' ? 'success' : ($transaction->status == 'pending' ? 'warning' : 'danger')); ?>">
                                            <?php echo e(ucfirst($transaction->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('transactions.show', $transaction)); ?>" class="btn btn-sm btn-info">View</a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">No recent transactions</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-sm btn-primary">View All Transactions</a>
                </div>
            </div>

            <!-- Recent Loans -->
            <?php if($stats['loans']->count() > 0): ?>
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Your Recent Loans</h3>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Loan ID</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Applied Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $stats['loans']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>#<?php echo e($loan->id); ?></td>
                                    <td>KES <?php echo e(number_format($loan->amount, 2)); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($loan->status == 'active' ? 'success' : ($loan->status == 'approved' ? 'info' : 'warning')); ?>">
                                            <?php echo e(ucfirst($loan->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($loan->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('loans.show', $loan)); ?>" class="btn btn-sm btn-info">View</a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Member Actions and Info -->
        <div class="col-md-4">
            <!-- Membership Status -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Membership Status</h3>
                </div>
                <div class="card-body">
                    <?php if($stats['membership']): ?>
                    <div class="text-center">
                        <div class="mb-3">
                            <span class="badge badge-<?php echo e($stats['membership']->status == 'active' ? 'success' : 'warning'); ?> badge-lg">
                                <?php echo e(ucfirst($stats['membership']->status)); ?> Member
                            </span>
                        </div>
                        <p><strong>Member Since:</strong><br><?php echo e($stats['membership']->created_at->format('F Y')); ?></p>
                        <p><strong>Member ID:</strong><br><?php echo e($stats['membership']->user->id_number ?? 'N/A'); ?></p>
                    </div>
                    <?php else: ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-user-times fa-2x mb-2"></i>
                        <p>Membership information not available</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Quick Actions</h3>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('loans.create')); ?>" class="btn btn-warning">
                            <i class="fas fa-hand-holding-usd"></i> Apply for Loan
                        </a>
                        <a href="<?php echo e(route('savings.create')); ?>" class="btn btn-success">
                            <i class="fas fa-plus"></i> Make Deposit
                        </a>
                        <a href="<?php echo e(route('transactions.create')); ?>" class="btn btn-info">
                            <i class="fas fa-exchange-alt"></i> Transfer Funds
                        </a>
                        <a href="<?php echo e(route('users.show', auth()->id())); ?>" class="btn btn-secondary">
                            <i class="fas fa-user-edit"></i> Update Profile
                        </a>
                    </div>
                </div>
            </div>

            <!-- Account Summary -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Account Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 border-right">
                            <h5 class="text-success"><?php echo e($stats['loans']->where('status', 'active')->count()); ?></h5>
                            <small class="text-muted">Active Loans</small>
                        </div>
                        <div class="col-6">
                            <h5 class="text-info"><?php echo e($stats['recent_transactions']->count()); ?></h5>
                            <small class="text-muted">This Month</small>
                        </div>
                    </div>
                    <hr>
                    <div class="text-center">
                        <h6 class="text-primary">Total Portfolio Value</h6>
                        <h4 class="text-success">
                            KES <?php echo e(number_format($stats['savings'] + $stats['shares'] + $stats['dividends'], 0)); ?>

                        </h4>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Member Services -->
    <div class="row mt-3">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Member Services</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-file-invoice-dollar fa-2x text-primary mb-2"></i>
                                <br><small>Loan Statement</small>
                            </a>
                        </div>
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-id-card fa-2x text-success mb-2"></i>
                                <br><small>ID Card</small>
                            </a>
                        </div>
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-envelope fa-2x text-info mb-2"></i>
                                <br><small>Contact Support</small>
                            </a>
                        </div>
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-question-circle fa-2x text-warning mb-2"></i>
                                <br><small>Help & FAQ</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\dashboards\member.blade.php ENDPATH**/ ?>