<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Occupations Report - Morio Sacco</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .report-info {
            margin-bottom: 20px;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 10px;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            background-color: #f8f9fa;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .summary h3 {
            margin: 0 0 10px 0;
            color: #247f1b;
            font-size: 14px;
        }
        .stats {
            display: table;
            width: 100%;
        }
        .stat-item {
            display: table-cell;
            text-align: center;
            padding: 0 10px;
        }
        .stat-number {
            font-size: 18px;
            font-weight: bold;
            color: #247f1b;
        }
        .stat-label {
            font-size: 10px;
            color: #666;
            text-transform: uppercase;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <p>Occupations Report</p>
        <p>Generated on <?php echo e(date('d M Y H:i:s')); ?></p>
    </div>

    <div class="summary">
        <h3>Report Summary</h3>
        <div class="stats">
            <div class="stat-item">
                <div class="stat-number"><?php echo e($occupations->count()); ?></div>
                <div class="stat-label">Total Occupations</div>
            </div>
            <div class="stat-item">
                <div class="stat-number"><?php echo e($occupations->where('is_active', true)->count()); ?></div>
                <div class="stat-label">Active Occupations</div>
            </div>
            <div class="stat-item">
                <div class="stat-number"><?php echo e($occupations->sum('memberships_count')); ?></div>
                <div class="stat-label">Total Members</div>
            </div>
        </div>
    </div>

    <div class="report-info">
        <strong>Report Details:</strong> This report shows all occupations with their member counts and details.
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 5%;">ID</th>
                <th style="width: 20%;">Occupation Name</th>
                <th style="width: 30%;">Description</th>
                <th style="width: 10%;">Members</th>
                <th style="width: 8%;">Sort Order</th>
                <th style="width: 8%;">Status</th>
                <th style="width: 12%;">Created Date</th>
                <th style="width: 7%;">Usage %</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $occupations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $occupation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($occupation->id); ?></td>
                <td><?php echo e($occupation->name); ?></td>
                <td><?php echo e($occupation->description ?: 'No description provided'); ?></td>
                <td style="text-align: center; font-weight: bold;"><?php echo e($occupation->memberships_count); ?></td>
                <td style="text-align: center;"><?php echo e($occupation->sort_order); ?></td>
                <td>
                    <span style="color: <?php echo e($occupation->is_active ? '#28a745' : '#dc3545'); ?>; font-weight: bold;">
                        <?php echo e($occupation->is_active ? 'Active' : 'Inactive'); ?>

                    </span>
                </td>
                <td><?php echo e($occupation->created_at->format('d M Y')); ?></td>
                <td style="text-align: center;">
                    <?php
                        $totalMembers = $occupations->sum('memberships_count');
                        $percentage = $totalMembers > 0 ? round(($occupation->memberships_count / $totalMembers) * 100, 1) : 0;
                    ?>
                    <?php echo e($percentage); ?>%
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p><strong>Morio Sacco Management System</strong></p>
        <p>Report generated automatically on <?php echo e(date('d M Y \a\t H:i:s')); ?></p>
        <p>Confidential - For Internal Use Only</p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\occupations\exports\pdf.blade.php ENDPATH**/ ?>