<?php $__env->startSection('title', 'Memberships'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Memberships Management</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
<!-- Compact Statistics Cards - Dynamic Data from Member Behavior -->
<div class="row mb-3">
    <!-- Total Members Registered -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-memberships-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Members
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($totalMembers); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-users mr-1"></i>
                            Registered members
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Members with Savings -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-memberships-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Active Savers
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($membersWithSavings); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-piggy-bank mr-1"></i>
                            With savings accounts
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-piggy-bank"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Members with Loans -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-memberships-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Loan Recipients
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($membersWithLoans); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-money-bill-wave mr-1"></i>
                            With active loans
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Members without Activity -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-memberships-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Inactive Members
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($totalMembers - $membersWithSavings - $membersWithLoans); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-slash mr-1"></i>
                            No financial activity
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-slash"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Members Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Registered Members</h3>
                    <div class="card-tools">
                        <div class="btn-group" role="group">
                            <a href="<?php echo e(route('memberships.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Add New Member
                            </a>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-download"></i> Export
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="<?php echo e(route('memberships.export.pdf')); ?>" target="_blank">
                                        <i class="fas fa-file-pdf text-danger"></i> Export as PDF
                                    </a>
                                    <a class="dropdown-item" href="<?php echo e(route('memberships.export.excel')); ?>">
                                        <i class="fas fa-file-excel text-success"></i> Export as Excel
                                    </a>
                                    <a class="dropdown-item" href="<?php echo e(route('memberships.export.csv')); ?>">
                                        <i class="fas fa-file-csv text-info"></i> Export as CSV
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bulk Actions -->
                <div class="card-header border-0" id="bulk-actions" style="display: none;">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <span id="selected-count">0</span> members selected
                        </div>
                        <div class="col-md-6 text-right">
                            <form action="<?php echo e(route('memberships.bulk-generate-credentials')); ?>" method="POST" id="bulk-credentials-form" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="member_ids" id="bulk-member-ids">
                                <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Generate new login credentials for selected members?')">
                                    <i class="fas fa-key"></i> Generate Credentials
                                </button>
                            </form>
                            <button type="button" class="btn btn-secondary btn-sm ml-2" onclick="clearSelection()">
                                <i class="fas fa-times"></i> Clear Selection
                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th"><input type="checkbox" id="select-all"></th>
                                <th class="compact-th">ID</th>
                                <th class="compact-th">Membership #</th>
                                <th class="compact-th">Member Name</th>
                                <th class="compact-th d-none d-md-table-cell">Gender</th>
                                <th class="compact-th d-none d-lg-table-cell">Phone</th>
                                <th class="compact-th d-none d-md-table-cell">Branch</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th d-none d-lg-table-cell">Share Capital</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="compact-row">
                                <td class="compact-td"><input type="checkbox" class="member-checkbox" value="<?php echo e($membership->id); ?>"></td>
                                <td class="compact-td"><?php echo e($membership->id); ?></td>
                                <td class="compact-td"><?php echo e($membership->membership_number); ?></td>
                                <td class="compact-td">
                                    <div class="font-weight-medium"><?php echo e(Str::limit($membership->user->full_name ?? 'N/A', 18)); ?></div>
                                </td>
                                <td class="compact-td d-none d-md-table-cell">
                                    <span class="badge badge-sm badge-<?php echo e($membership->gender === 'male' ? 'info' : 'secondary'); ?>">
                                        <?php echo e(ucfirst($membership->gender)); ?>

                                    </span>
                                </td>
                                <td class="compact-td d-none d-lg-table-cell"><?php echo e($membership->user->phone_number ?? 'N/A'); ?></td>
                                <td class="compact-td d-none d-md-table-cell"><?php echo e(Str::limit($membership->user->branch->name ?? 'N/A', 12)); ?></td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-<?php echo e($membership->status === 'active' ? 'success' : ($membership->status === 'inactive' ? 'warning' : 'danger')); ?>">
                                        <?php echo e(ucfirst($membership->status)); ?>

                                    </span>
                                </td>
                                <td class="compact-td d-none d-lg-table-cell">KSh <?php echo e(number_format($membership->share_capital, 0)); ?></td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="<?php echo e(route('memberships.show', $membership)); ?>" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('memberships.edit', $membership)); ?>" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('memberships.generate-credentials', $membership)); ?>" method="POST" class="d-inline"
                                              onsubmit="return confirm('This will generate new login credentials and send them to the member\'s email. Continue?')">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-success btn-xs" title="Generate Credentials">
                                                <i class="fas fa-key"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('memberships.destroy', $membership)); ?>" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this member? This action cannot be undone.')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-users fa-3x mb-3"></i>
                                        <h5>No Members Registered Yet</h5>
                                        <p>Start by adding your first member to the system.</p>
                                        <a href="<?php echo e(route('memberships.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add First Member
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($memberships->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($memberships->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-danger {
    border-left: 4px solid #e74a3b !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact memberships card styling */
.compact-memberships-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-memberships-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-memberships-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-memberships-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-danger {
    color: #e74a3b !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<script>
$(document).ready(function() {
    // Handle select all checkbox
    $('#select-all').on('change', function() {
        $('.member-checkbox').prop('checked', $(this).prop('checked'));
        updateBulkActions();
    });

    // Handle individual checkboxes
    $(document).on('change', '.member-checkbox', function() {
        var totalCheckboxes = $('.member-checkbox').length;
        var checkedCheckboxes = $('.member-checkbox:checked').length;

        $('#select-all').prop('checked', totalCheckboxes === checkedCheckboxes);
        updateBulkActions();
    });

    function updateBulkActions() {
        var selectedCount = $('.member-checkbox:checked').length;
        var selectedIds = $('.member-checkbox:checked').map(function() {
            return $(this).val();
        }).get();

        if (selectedCount > 0) {
            $('#bulk-actions').show();
            $('#selected-count').text(selectedCount);
            $('#bulk-member-ids').val(selectedIds.join(','));
        } else {
            $('#bulk-actions').hide();
        }
    }

    // Clear selection function
    window.clearSelection = function() {
        $('.member-checkbox').prop('checked', false);
        $('#select-all').prop('checked', false);
        updateBulkActions();
    };
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\memberships\index.blade.php ENDPATH**/ ?>