<div class="container-fluid">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-warning" style="background: linear-gradient(45deg, #ffc107, #fd7e14); border: none; color: #000;">
                <h4><i class="fas fa-hand-holding-usd"></i> Loan Manager Dashboard</h4>
                <p class="mb-0">Welcome back, <?php echo e(auth()->user()->full_name); ?>! Manage loans and savings efficiently.</p>
            </div>
        </div>
    </div>

    <!-- Loan Statistics -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e(number_format($stats['pending_loans'])); ?></h3>
                    <p>Pending Approvals</p>
                </div>
                <div class="icon">
                    <i class="fas fa-clock"></i>
                </div>
                <a href="<?php echo e(route('loans.index')); ?>?status=pending" class="small-box-footer">
                    Review Now <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo e(number_format($stats['approved_loans'])); ?></h3>
                    <p>Approved Loans</p>
                </div>
                <div class="icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <a href="<?php echo e(route('loans.index')); ?>?status=approved" class="small-box-footer">
                    View Details <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e(number_format($stats['active_loans'])); ?></h3>
                    <p>Active Loans</p>
                </div>
                <div class="icon">
                    <i class="fas fa-play-circle"></i>
                </div>
                <a href="<?php echo e(route('loans.index')); ?>?status=active" class="small-box-footer">
                    Monitor <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3>KES <?php echo e(number_format($stats['total_loan_amount'], 0)); ?></h3>
                    <p>Total Loan Portfolio</p>
                </div>
                <div class="icon">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <a href="<?php echo e(route('reports.index')); ?>" class="small-box-footer">
                    View Report <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Loans and Actions -->
    <div class="row">
        <!-- Recent Loan Applications -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Loan Applications</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Applicant</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Applied Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $stats['recent_loans']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loan->user->full_name ?? 'N/A'); ?></td>
                                    <td>KES <?php echo e(number_format($loan->amount, 2)); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($loan->status == 'approved' ? 'success' : ($loan->status == 'pending' ? 'warning' : 'danger')); ?>">
                                            <?php echo e(ucfirst($loan->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($loan->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <?php if($loan->status == 'pending'): ?>
                                        <a href="<?php echo e(route('loans.show', $loan)); ?>" class="btn btn-sm btn-warning">Review</a>
                                        <?php else: ?>
                                        <a href="<?php echo e(route('loans.show', $loan)); ?>" class="btn btn-sm btn-info">View</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">No recent loan applications</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <a href="<?php echo e(route('loans.index')); ?>" class="btn btn-sm btn-primary">View All Loans</a>
                    <?php if($stats['loan_approvals_needed'] > 0): ?>
                    <span class="badge badge-danger ml-2"><?php echo e($stats['loan_approvals_needed']); ?> pending approvals</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Quick Actions for Loan Manager -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Loan Management Actions</h3>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('loans.index')); ?>?status=pending" class="btn btn-warning">
                            <i class="fas fa-clipboard-check"></i> Review Pending Loans
                        </a>
                        <a href="<?php echo e(route('loans.create')); ?>" class="btn btn-success">
                            <i class="fas fa-plus"></i> Create New Loan
                        </a>
                        <a href="<?php echo e(route('savings.index')); ?>" class="btn btn-info">
                            <i class="fas fa-piggy-bank"></i> Manage Savings
                        </a>
                        <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-chart-line"></i> Loan Reports
                        </a>
                    </div>
                </div>
            </div>

            <!-- Loan Portfolio Summary -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Portfolio Summary</h3>
                </div>
                <div class="card-body">
                    <div class="progress-group">
                        <span class="float-right"><b><?php echo e($stats['active_loans']); ?></b> Active</span>
                        <span>Loan Status Distribution</span>
                        <div class="progress progress-sm">
                            <div class="progress-bar bg-success" style="width: <?php echo e($stats['active_loans'] > 0 ? ($stats['active_loans'] / max($stats['active_loans'] + $stats['approved_loans'] + $stats['pending_loans'], 1)) * 100 : 0); ?>%"></div>
                            <div class="progress-bar bg-warning" style="width: <?php echo e($stats['approved_loans'] > 0 ? ($stats['approved_loans'] / max($stats['active_loans'] + $stats['approved_loans'] + $stats['pending_loans'], 1)) * 100 : 0); ?>%"></div>
                            <div class="progress-bar bg-danger" style="width: <?php echo e($stats['pending_loans'] > 0 ? ($stats['pending_loans'] / max($stats['active_loans'] + $stats['approved_loans'] + $stats['pending_loans'], 1)) * 100 : 0); ?>%"></div>
                        </div>
                    </div>
                    <div class="mt-3">
                        <small class="text-muted">
                            <span class="badge badge-success">Active</span>
                            <span class="badge badge-warning ml-1">Approved</span>
                            <span class="badge badge-danger ml-1">Pending</span>
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Risk Assessment Alert -->
    <?php if($stats['pending_loans'] > 10): ?>
    <div class="row mt-3">
        <div class="col-12">
            <div class="alert alert-danger">
                <h5><i class="icon fas fa-exclamation-triangle"></i> High Volume Alert!</h5>
                You have <?php echo e($stats['pending_loans']); ?> pending loan applications requiring attention.
                <a href="<?php echo e(route('loans.index')); ?>?status=pending" class="alert-link">Review them now</a>.
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\dashboards\loan_manager.blade.php ENDPATH**/ ?>