<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Users Report - Morio Sacco</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #247f1b;
        }
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }
        .badge-success {
            background-color: #28a745;
            color: white;
        }
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        .badge-warning {
            background-color: #ffc107;
            color: black;
        }
        .badge-info {
            background-color: #17a2b8;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <h2>Users Report</h2>
        <p>Generated on: <?php echo e(date('F d, Y H:i:s')); ?></p>
        <p>Total Users: <?php echo e($users->count()); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Full Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>ID Number</th>
                <th>Role</th>
                <th>Branch</th>
                <th>Status</th>
                <th>Joined Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($user->id); ?></td>
                <td><?php echo e($user->full_name); ?></td>
                <td><?php echo e($user->email); ?></td>
                <td><?php echo e($user->phone_number); ?></td>
                <td><?php echo e($user->id_number); ?></td>
                <td>
                    <span class="badge <?php echo e($user->role == 'admin' ? 'badge-danger' : ($user->role == 'manager' ? 'badge-warning' : 'badge-success')); ?>">
                        <?php echo e(ucfirst($user->role)); ?>

                    </span>
                </td>
                <td><?php echo e($user->branch ? $user->branch->name : 'No Branch'); ?></td>
                <td>
                    <span class="badge <?php echo e($user->email_verified_at ? 'badge-success' : 'badge-warning'); ?>">
                        <?php echo e($user->email_verified_at ? 'Verified' : 'Unverified'); ?>

                    </span>
                </td>
                <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p><strong><?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?> Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> <?php echo e(\App\Models\SystemSetting::get('contact_phone', '+254 700 000 000')); ?> |
            <i class="fas fa-envelope"></i> <?php echo e(\App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke')); ?> |
            <i class="fas fa-map-marker-alt"></i> <?php echo e(\App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya')); ?>

        </p>
        <p>
            <i class="fas fa-globe"></i> <?php echo e(\App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke')); ?> |
            Report generated on <?php echo e(now()->format('l, F j, Y \a\t g:i A')); ?> | Confidential Document
        </p>
        <p>For Internal Use Only</p>
    </div>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\users\pdf.blade.php ENDPATH**/ ?>