<?php $__env->startSection('title', 'Money Market Account Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <!-- Account Header -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        Account: <?php echo e($moneyMarketAccount->account_number); ?>

                        <span class="badge <?php echo e($moneyMarketAccount->getStatusBadgeClass()); ?> ml-2">
                            <?php echo e(ucfirst($moneyMarketAccount->status)); ?>

                        </span>
                    </h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('money-market-accounts.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                        <?php if($moneyMarketAccount->status === 'active'): ?>
                        <a href="<?php echo e(route('money-market-accounts.edit', $moneyMarketAccount)); ?>" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Account Information -->
                        <div class="col-md-6">
                            <h5>Account Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Account Number:</th>
                                    <td><?php echo e($moneyMarketAccount->account_number); ?></td>
                                </tr>
                                <tr>
                                    <th>Member:</th>
                                    <td><?php echo e($moneyMarketAccount->membership->user->full_name ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <th>Membership Number:</th>
                                    <td><?php echo e($moneyMarketAccount->membership->membership_number); ?></td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        <span class="badge <?php echo e($moneyMarketAccount->getStatusBadgeClass()); ?>">
                                            <?php echo e(ucfirst($moneyMarketAccount->status)); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Currency:</th>
                                    <td><?php echo e($moneyMarketAccount->currency_code); ?></td>
                                </tr>
                            </table>
                        </div>

                        <!-- Investment Details -->
                        <div class="col-md-6">
                            <h5>Investment Details</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Principal Amount:</th>
                                    <td><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code)); ?></td>
                                </tr>
                                <tr>
                                    <th>Interest Rate:</th>
                                    <td><?php echo e(number_format($moneyMarketAccount->interest_rate, 2)); ?>% per annum</td>
                                </tr>
                                <tr>
                                    <th>Term:</th>
                                    <td><?php echo e($moneyMarketAccount->term_months); ?> months</td>
                                </tr>
                                <tr>
                                    <th>Start Date:</th>
                                    <td><?php echo e($moneyMarketAccount->start_date->format('M d, Y')); ?></td>
                                </tr>
                                <tr>
                                    <th>Maturity Date:</th>
                                    <td><?php echo e($moneyMarketAccount->maturity_date->format('M d, Y')); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <hr>

                    <!-- Financial Summary -->
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Financial Summary</h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Principal Amount</span>
                                            <span class="info-box-number"><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->principal_amount, $moneyMarketAccount->currency_code)); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-success">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Interest Earned</span>
                                            <span class="info-box-number"><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->interest_earned, $moneyMarketAccount->currency_code)); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-primary">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Amount</span>
                                            <span class="info-box-number"><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->total_amount, $moneyMarketAccount->currency_code)); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-warning">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Days to Maturity</span>
                                            <span class="info-box-number"><?php echo e(max(0, $moneyMarketAccount->daysUntilMaturity())); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if($moneyMarketAccount->notes): ?>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Notes</h5>
                            <p><?php echo e($moneyMarketAccount->notes); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Action Buttons -->
                    <?php if($moneyMarketAccount->status === 'active' || $moneyMarketAccount->status === 'matured'): ?>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Actions</h5>
                            <div class="btn-group">
                                <?php if($moneyMarketAccount->status === 'active' || $moneyMarketAccount->status === 'matured'): ?>
                                <button type="button" class="btn btn-danger" onclick="withdrawAccount()">
                                    <i class="fas fa-money-bill-wave"></i> Withdraw Funds
                                </button>
                                <?php endif; ?>

                                <?php if($moneyMarketAccount->isMatured() && $moneyMarketAccount->status === 'active'): ?>
                                <button type="button" class="btn btn-success ml-2" onclick="markAsMatured()">
                                    <i class="fas fa-check"></i> Mark as Matured
                                </button>
                                <?php endif; ?>

                                <button type="button" class="btn btn-info ml-2" onclick="updateInterest()">
                                    <i class="fas fa-calculator"></i> Update Interest
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Withdrawal History -->
                    <?php if($moneyMarketAccount->withdrawn_at): ?>
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h5>Withdrawal Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">Withdrawal Date:</th>
                                    <td><?php echo e($moneyMarketAccount->withdrawn_at->format('M d, Y H:i')); ?></td>
                                </tr>
                                <tr>
                                    <th>Withdrawal Amount:</th>
                                    <td><?php echo e(\App\Helpers\CurrencyHelper::format($moneyMarketAccount->withdrawal_amount, $moneyMarketAccount->currency_code)); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
function withdrawAccount() {
    const amount = prompt('Enter withdrawal amount (leave empty for full amount):', '<?php echo e($moneyMarketAccount->total_amount); ?>');
    if (amount !== null) {
        $.post('<?php echo e(route("money-market-accounts.withdraw", $moneyMarketAccount)); ?>', {
            _token: '<?php echo e(csrf_token()); ?>',
            withdrawal_amount: amount || '<?php echo e($moneyMarketAccount->total_amount); ?>'
        }).done(function(response) {
            location.reload();
        }).fail(function(xhr) {
            alert('Error: ' + (xhr.responseJSON?.message || 'Withdrawal failed'));
        });
    }
}

function markAsMatured() {
    if (confirm('Mark this account as matured?')) {
        $.post('<?php echo e(route("money-market-accounts.mark-matured", $moneyMarketAccount)); ?>', {
            _token: '<?php echo e(csrf_token()); ?>'
        }).done(function(response) {
            location.reload();
        });
    }
}

function updateInterest() {
    if (confirm('Update interest earned for this account?')) {
        $.post('<?php echo e(route("money-market-accounts.update-interest")); ?>', {
            _token: '<?php echo e(csrf_token()); ?>'
        }).done(function(response) {
            location.reload();
        });
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\money-market-accounts\show.blade.php ENDPATH**/ ?>