<?php $__env->startSection('title', 'Loan Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header Section -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Loan Application #<?php echo e($loan->id); ?></h1>
                <p class="mt-2 text-gray-600">Applied on <?php echo e($loan->created_at->format('F d, Y \a\t H:i')); ?></p>
            </div>
            <div class="flex items-center space-x-4">
                <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium
                    <?php if($loan->status === 'approved'): ?> bg-green-100 text-green-800
                    <?php elseif($loan->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                    <?php elseif($loan->status === 'rejected'): ?> bg-red-100 text-red-800
                    <?php elseif($loan->status === 'active'): ?> bg-blue-100 text-blue-800
                    <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                    <i class="fas
                        <?php if($loan->status === 'approved'): ?> fa-check-circle
                        <?php elseif($loan->status === 'pending'): ?> fa-clock
                        <?php elseif($loan->status === 'rejected'): ?> fa-times-circle
                        <?php elseif($loan->status === 'active'): ?> fa-play-circle
                        <?php else: ?> fa-question-circle <?php endif; ?> mr-2"></i>
                    <?php echo e(ucfirst($loan->status)); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-8">
            <!-- Loan Overview Cards -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 hover:shadow-md transition-shadow">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-money-bill-wave text-blue-600 text-lg"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Principal</p>
                            <p class="text-lg font-bold text-gray-900 truncate">KSh <?php echo e(number_format($loan->amount, 0)); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 hover:shadow-md transition-shadow">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-percent text-orange-600 text-lg"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Interest Rate</p>
                            <p class="text-lg font-bold text-gray-900"><?php echo e($loan->interest_rate); ?>%</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 hover:shadow-md transition-shadow">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-calendar text-purple-600 text-lg"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Term</p>
                            <p class="text-lg font-bold text-gray-900"><?php echo e($loan->term_months); ?> months</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 hover:shadow-md transition-shadow">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                                <i class="fas fa-coins text-green-600 text-lg"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Monthly</p>
                            <p class="text-lg font-bold text-gray-900 truncate">KSh <?php echo e(number_format($loan->monthly_payment, 0)); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Amount Highlight -->
            <div class="bg-gradient-to-r from-blue-600 to-purple-600 rounded-lg p-6 text-white shadow-lg">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-white/20 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calculator text-white text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold">Total Amount</h3>
                            <p class="text-blue-100 text-sm">Principal + Interest</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-3xl font-bold">KSh <?php echo e(number_format($loan->total_amount, 0)); ?></div>
                        <div class="text-blue-100 text-sm">Due in <?php echo e($loan->term_months); ?> months</div>
                    </div>
                </div>
            </div>

            <!-- Loan Purpose -->
            <?php if($loan->notes): ?>
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                <div class="flex items-start space-x-4">
                    <div class="flex-shrink-0">
                        <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-comment text-gray-600 text-lg"></i>
                        </div>
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="text-base font-semibold text-gray-900 mb-2">Loan Purpose</h3>
                        <p class="text-gray-600 text-sm leading-relaxed"><?php echo e($loan->notes); ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Payment Schedule -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                <div class="px-5 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-base font-semibold text-gray-900">
                        <i class="fas fa-calendar-alt mr-2 text-blue-600"></i>Payment Schedule
                    </h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Month</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payment</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php
                                $balance = $loan->total_amount;
                                $monthlyPayment = $loan->monthly_payment;
                            ?>
                            <?php for($month = 1; $month <= min($loan->term_months, 12); $month++): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($month); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">KSh <?php echo e(number_format($monthlyPayment, 0)); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">
                                    <?php
                                        $balance -= $monthlyPayment;
                                        if($balance < 0) $balance = 0;
                                    ?>
                                    KSh <?php echo e(number_format($balance, 0)); ?>

                                </td>
                            </tr>
                            <?php endfor; ?>
                            <?php if($loan->term_months > 12): ?>
                            <tr class="bg-gray-50">
                                <td colspan="3" class="px-4 py-3 text-center text-sm text-gray-500">
                                    ... and <?php echo e($loan->term_months - 12); ?> more months
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-5">
            <!-- Quick Actions -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                <h3 class="text-base font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-bolt mr-2 text-yellow-500"></i>Quick Actions
                </h3>
                <div class="space-y-3">
                    <?php if($loan->status === 'pending'): ?>
                    <a href="<?php echo e(route('member.loans.edit', $loan)); ?>" class="w-full inline-flex items-center justify-center px-3 py-2.5 text-sm font-medium rounded-lg text-white bg-yellow-600 hover:bg-yellow-700 transition-colors">
                        <i class="fas fa-edit mr-2"></i>Edit Application
                    </a>
                    <button onclick="deleteLoan(<?php echo e($loan->id); ?>)" class="w-full inline-flex items-center justify-center px-3 py-2.5 text-sm font-medium rounded-lg text-white bg-red-600 hover:bg-red-700 transition-colors">
                        <i class="fas fa-trash mr-2"></i>Delete Application
                    </button>
                    <?php elseif($loan->status === 'approved' || $loan->status === 'active'): ?>
                    <button onclick="payLoan(<?php echo e($loan->id); ?>)" class="w-full inline-flex items-center justify-center px-3 py-2.5 text-sm font-medium rounded-lg text-white bg-green-600 hover:bg-green-700 transition-colors" data-toggle="modal" data-target="#paymentModal">
                        <i class="fas fa-credit-card mr-2"></i>Make Payment
                    </button>
                    <?php endif; ?>

                    <a href="<?php echo e(route('member.loans.index')); ?>" class="w-full inline-flex items-center justify-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-700 bg-white border border-gray-300 hover:bg-gray-50 transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Loans
                    </a>
                </div>
            </div>

            <!-- Application Timeline -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                <h3 class="text-base font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-history mr-2 text-blue-600"></i>Timeline
                </h3>
                <div class="space-y-4">
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-paper-plane text-blue-600 text-xs"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900">Application Submitted</p>
                            <p class="text-xs text-gray-500"><?php echo e($loan->created_at->format('M d, Y \a\t H:i')); ?></p>
                            <p class="text-xs text-gray-600 mt-1">Your loan application has been received and is being processed.</p>
                        </div>
                    </div>

                    <?php if($loan->approved_at): ?>
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-green-600 text-xs"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900">Application Approved</p>
                            <p class="text-xs text-gray-500"><?php echo e($loan->approved_at->format('M d, Y \a\t H:i')); ?></p>
                            <p class="text-xs text-gray-600 mt-1">Congratulations! Your loan application has been approved.</p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Support -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-5">
                <h3 class="text-base font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-headset mr-2 text-green-600"></i>Need Help?
                </h3>
                <div class="space-y-3">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-phone text-blue-600 text-sm"></i>
                        <div>
                            <p class="text-sm font-medium text-gray-900">+254 700 000 000</p>
                            <p class="text-xs text-gray-500">Call us</p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-envelope text-purple-600 text-sm"></i>
                        <div>
                            <p class="text-sm font-medium text-gray-900">loans@morio-sacco.co.ke</p>
                            <p class="text-xs text-gray-500">Email us</p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-clock text-orange-600 text-sm"></i>
                        <div>
                            <p class="text-sm font-medium text-gray-900">Mon-Fri: 8AM-5PM</p>
                            <p class="text-xs text-gray-500">Business hours</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="paymentModalLabel">
                    <i class="fas fa-credit-card mr-2"></i>Make Loan Payment
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="paymentForm" onsubmit="submitPayment(event)">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="payment_amount" class="form-label">Payment Amount (KSh)</label>
                        <input type="number" id="payment_amount" name="amount" min="1" step="0.01"
                                class="form-control" placeholder="Enter payment amount" required>
                        <small class="form-text text-muted">Monthly payment: KSh <?php echo e(number_format($loan->monthly_payment, 2)); ?></small>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i>Cancel
                    </button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane mr-1"></i>Send M-Pesa Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
function deleteLoan(loanId) {
    Swal.fire({
        title: 'Are you sure?',
        text: 'This will permanently delete your loan application. This action cannot be undone.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Deleting...',
                text: 'Please wait while we delete your application.',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });

            // Create form for DELETE request
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `<?php echo e(url('member/loans')); ?>/${loanId}`;
            form.style.display = 'none';

            // Add method spoofing for DELETE
            const methodInput = document.createElement('input');
            methodInput.type = 'hidden';
            methodInput.name = '_method';
            methodInput.value = 'DELETE';
            form.appendChild(methodInput);

            // Add CSRF token
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(csrfToken);

            // Add to body and submit
            document.body.appendChild(form);
            form.submit();
        }
    });
}

function payLoan(loanId) {
    $('#payment_amount').val(''); // Clear previous value
    $('#paymentModal').modal('show');
}

function submitPayment(event) {
    event.preventDefault();

    const formData = new FormData(event.target);

    $.ajax({
        url: `<?php echo e(url('member/loans')); ?>/$<?php echo e($loan->id); ?>/pay`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data) {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Payment Initiated!',
                    text: 'Please check your phone and complete the M-Pesa payment.',
                    timer: 3000,
                    showConfirmButton: false
                });
                $('#paymentModal').modal('hide');
                $('#paymentForm')[0].reset();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Payment Failed',
                    text: data.message
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred while processing your payment.'
            });
        }
    });
}

// Reset form when modal is hidden
$('#paymentModal').on('hidden.bs.modal', function() {
    $('#paymentForm')[0].reset();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\member\loans\show.blade.php ENDPATH**/ ?>