<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Morio Sacco')); ?> - <?php echo $__env->yieldContent('title', 'Dashboard'); ?></title>

    <!-- CoreUI CSS -->
    <link href="https://cdn.jsdelivr.net/npm/@coreui/coreui@5.1.2/dist/css/coreui.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@coreui/icons@3.0.1/css/all.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body>
    <div class="min-vh-100 d-flex flex-column">
        <!-- Sidebar -->
        <div class="sidebar sidebar-dark sidebar-fixed border-end" id="sidebar">
            <div class="sidebar-header border-bottom">
                <div class="sidebar-brand d-none d-md-flex">
                    <span class="sidebar-brand-narrow">MS</span>
                </div>
            </div>

            <ul class="sidebar-nav" data-coreui="navigation" data-simplebar>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('home')); ?>">
                        <i class="nav-icon cil-speedometer"></i> Dashboard
                    </a>
                </li>

                <li class="nav-title">Sacco Management</li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('memberships.index')); ?>">
                        <i class="nav-icon cil-id-card"></i> Memberships
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('users.index')); ?>">
                        <i class="nav-icon cil-people"></i> Users
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('branches.index')); ?>">
                        <i class="nav-icon cil-building"></i> Branches
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('loans.index')); ?>">
                        <i class="nav-icon cil-money"></i> Loans
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('savings.index')); ?>">
                        <i class="nav-icon cil-piggy-bank"></i> Savings
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('transactions.index')); ?>">
                        <i class="nav-icon cil-transfer"></i> Transactions
                    </a>
                </li>

                <li class="nav-title">Configuration</li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('system-settings.index')); ?>">
                        <i class="nav-icon cil-settings"></i> System Settings
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('mpesa-credentials.index')); ?>">
                        <i class="nav-icon cil-mobile"></i> M-Pesa Settings
                    </a>
                </li>

                <li class="nav-title">Reports</li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('reports.index')); ?>">
                        <i class="nav-icon cil-chart-bar"></i> Reports
                    </a>
                </li>
            </ul>
        </div>

        <!-- Main content -->
        <div class="wrapper d-flex flex-column min-vh-100">
            <!-- Header -->
            <header class="header header-sticky mb-4">
                <div class="container-fluid">
                    <button class="header-toggler px-md-0 me-md-3 d-none d-md-inline-block" type="button" onclick="CoreUI.Sidebar.getInstance(document.querySelector('#sidebar')).toggle()">
                        <i class="cil-menu"></i>
                    </button>

                    <ul class="header-nav ms-auto">
                        <li class="nav-item dropdown">
                            <a class="nav-link py-0" data-coreui-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
                                <div class="avatar avatar-md">
                                    <i class="cil-user"></i>
                                </div>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end pt-0">
                                <div class="dropdown-header bg-body-tertiary text-body-secondary fw-semibold rounded-top mb-2">
                                    <?php echo e(auth()->user()->full_name ?? 'User'); ?>

                                </div>
                                <a class="dropdown-item" href="#">
                                    <i class="cil-user me-2"></i> Profile
                                </a>
                                <div class="dropdown-divider"></div>
                                <form method="POST" action="<?php echo e(route('logout')); ?>" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item">
                                        <i class="cil-account-logout me-2"></i> Logout
                                    </button>
                                </form>
                            </div>
                        </li>
                    </ul>
                </div>
            </header>

            <!-- Content -->
            <div class="body flex-grow-1 px-3">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <!-- Footer -->
            <footer class="footer">
                <div class="ms-auto">
                    <?php echo \App\Models\SystemSetting::get('system_footer', '&copy; ' . date('Y') . ' Morio Sacco. All rights reserved.'); ?>

                </div>
            </footer>
        </div>
    </div>

    <!-- CoreUI JS -->
    <script src="https://cdn.jsdelivr.net/npm/@coreui/coreui@5.1.2/dist/js/coreui.bundle.min.js"></script>

    <!-- Custom JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        .footer {
            background-color: transparent !important;
            border-top: none !important;
        }
    </style>

    <?php echo $__env->yieldPushContent('js'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\layouts\coreui.blade.php ENDPATH**/ ?>