<?php $__env->startSection('title', 'Savings Account Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Header Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-piggy-bank mr-2"></i><?php echo e(ucfirst($saving->type)); ?> Savings Account
                    </h3>
                    <div class="card-tools">
                        <span class="badge badge-lg
                            <?php if($saving->status === 'active'): ?> badge-success
                            <?php else: ?> badge-secondary <?php endif; ?>">
                            <?php echo e(ucfirst($saving->status)); ?>

                        </span>
                        <small class="text-muted ml-2">Opened <?php echo e($saving->created_at->format('M d, Y')); ?></small>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Main Content -->
                <div class="col-lg-8">
                    <!-- Account Summary -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-chart-line mr-2"></i>Account Summary
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Current Balance</span>
                                            <span class="info-box-number text-success">KSh <?php echo e(number_format($saving->amount, 2)); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Account Type</span>
                                            <span class="info-box-number text-primary"><?php echo e(ucfirst($saving->type)); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="info-box bg-light">
                                        <div class="info-box-content">
                                            <span class="info-box-text">Account Status</span>
                                            <span class="info-box-number text-info"><?php echo e(ucfirst($saving->status)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php if($saving->type === 'fixed' && $saving->maturity_date): ?>
                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="info-box bg-primary">
                                        <div class="info-box-content">
                                            <span class="info-box-text text-white">Maturity Information</span>
                                            <span class="info-box-number text-white"><?php echo e($saving->maturity_date->format('M d, Y')); ?> (<?php echo e(now()->diffInDays($saving->maturity_date)); ?> days remaining)</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Account Information -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-info-circle mr-2"></i>Account Information
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>Account Number:</strong> <?php echo e($saving->id); ?><br>
                                    <strong>Opening Date:</strong> <?php echo e($saving->created_at->format('M d, Y')); ?><br>
                                    <strong>Last Updated:</strong> <?php echo e($saving->updated_at->format('M d, Y')); ?>

                                </div>
                                <div class="col-md-6">
                                    <strong>Account Type:</strong> <?php echo e(ucfirst($saving->type)); ?><br>
                                    <strong>Status:</strong> <?php echo e(ucfirst($saving->status)); ?><br>
                                    <?php if($saving->type === 'fixed' && $saving->maturity_date): ?>
                                    <strong>Maturity Date:</strong> <?php echo e($saving->maturity_date->format('M d, Y')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction History -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-history mr-2"></i>Transaction History
                            </h3>
                        </div>
                        <div class="card-body table-responsive p-0">
                            <?php
                                $transactions = \App\Models\Transaction::where('user_id', auth()->id())
                                    ->where('reference_id', $saving->id)
                                    ->whereIn('type', ['savings_deposit', 'savings_withdrawal'])
                                    ->latest()
                                    ->take(10)
                                    ->get();
                            ?>

                            <?php if($transactions->count() > 0): ?>
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></td>
                                        <td>
                                            <?php if($transaction->type === 'savings_deposit'): ?>
                                                <span class="badge badge-success">Deposit</span>
                                            <?php else: ?>
                                                <span class="badge badge-warning">Withdrawal</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="<?php echo e($transaction->type === 'savings_deposit' ? 'text-success' : 'text-danger'); ?>">
                                                <?php echo e($transaction->type === 'savings_deposit' ? '+' : '-'); ?>KSh <?php echo e(number_format($transaction->amount, 2)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge
                                                <?php if($transaction->status === 'completed'): ?> badge-success
                                                <?php elseif($transaction->status === 'pending'): ?> badge-warning
                                                <?php else: ?> badge-danger <?php endif; ?>">
                                                <?php echo e(ucfirst($transaction->status)); ?>

                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php else: ?>
                            <div class="text-center py-5">
                                <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">No Transactions Yet</h5>
                                <p class="text-muted">Your transaction history will appear here</p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-lg-4">
                    <!-- Quick Actions -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-bolt mr-2"></i>Quick Actions
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php if($saving->status === 'active'): ?>
                            <button onclick="depositToAccount(<?php echo e($saving->id); ?>)" class="btn btn-success btn-block btn-lg mb-3" data-toggle="modal" data-target="#depositModal">
                                <i class="fas fa-plus mr-2"></i>Make Deposit
                            </button>

                            <?php if($saving->type === 'recurring'): ?>
                            <button onclick="withdrawFromAccount(<?php echo e($saving->id); ?>)" class="btn btn-warning btn-block btn-lg mb-3" data-toggle="modal" data-target="#withdrawalModal">
                                <i class="fas fa-minus mr-2"></i>Withdraw Funds
                            </button>
                            <?php endif; ?>
                            <?php endif; ?>

                            <a href="<?php echo e(route('member.savings.index')); ?>" class="btn btn-secondary btn-block">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Accounts
                            </a>
                        </div>
                    </div>

                    <!-- Account Benefits -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-star mr-2"></i>Account Benefits
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php if($saving->type === 'recurring'): ?>
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check text-success mr-3 mt-1"></i>
                                <div>
                                    <strong>Flexible Access</strong><br>
                                    <small class="text-muted">Deposit and withdraw anytime</small>
                                </div>
                            </div>
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check text-success mr-3 mt-1"></i>
                                <div>
                                    <strong>Competitive Rates</strong><br>
                                    <small class="text-muted">Earn interest on your savings</small>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check text-primary mr-3 mt-1"></i>
                                <div>
                                    <strong>Higher Returns</strong><br>
                                    <small class="text-muted">Better interest rates for longer terms</small>
                                </div>
                            </div>
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check text-primary mr-3 mt-1"></i>
                                <div>
                                    <strong>Guaranteed Returns</strong><br>
                                    <small class="text-muted">Fixed returns at maturity</small>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-headset mr-2"></i>Need Help?
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-phone text-primary mr-3"></i>
                                <div>
                                    <div class="font-weight-bold">+254 700 000 000</div>
                                    <small class="text-muted">Call us</small>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-envelope text-info mr-3"></i>
                                <div>
                                    <div class="font-weight-bold">savings@morio-sacco.co.ke</div>
                                    <small class="text-muted">Email us</small>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="fas fa-clock text-warning mr-3"></i>
                                <div>
                                    <div class="font-weight-bold">Mon-Fri: 8AM-5PM</div>
                                    <small class="text-muted">Business hours</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Deposit Modal -->
<div class="modal fade" id="depositModal" tabindex="-1" role="dialog" aria-labelledby="depositModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="depositModalLabel">
                    <i class="fas fa-plus mr-2"></i>Make Deposit
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="depositForm" onsubmit="submitDeposit(event)">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="deposit_amount" class="form-label">Deposit Amount (KSh)</label>
                        <input type="number" id="deposit_amount" name="amount" min="100" step="0.01"
                               class="form-control" placeholder="Enter deposit amount" required>
                        <small class="form-text text-muted">Minimum deposit: KSh 100</small>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i>Cancel
                    </button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane mr-1"></i>Send M-Pesa Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Withdrawal Modal -->
<div class="modal fade" id="withdrawalModal" tabindex="-1" role="dialog" aria-labelledby="withdrawalModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="withdrawalModalLabel">
                    <i class="fas fa-minus mr-2"></i>Withdraw Funds
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="withdrawalForm" onsubmit="submitWithdrawal(event)">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="withdrawal_amount" class="form-label">Withdrawal Amount (KSh)</label>
                        <input type="number" id="withdrawal_amount" name="amount" min="100" max="<?php echo e($saving->amount); ?>" step="0.01"
                               class="form-control" placeholder="Enter withdrawal amount" required>
                        <small class="form-text text-muted">Available balance: KSh <?php echo e(number_format($saving->amount, 2)); ?></small>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i>Cancel
                    </button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-paper-plane mr-1"></i>Process Withdrawal
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
function depositToAccount(savingId) {
    $('#deposit_amount').val(''); // Clear previous value
    $('#depositModal').modal('show');
}

function submitDeposit(event) {
    event.preventDefault();

    const formData = new FormData(event.target);
    formData.append('saving_id', <?php echo e($saving->id); ?>);

    $.ajax({
        url: `<?php echo e(url('member/savings')); ?>/$<?php echo e($saving->id); ?>/deposit`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data) {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Deposit Initiated!',
                    text: 'Please check your phone and complete the M-Pesa payment.',
                    timer: 3000,
                    showConfirmButton: false
                });
                $('#depositModal').modal('hide');
                $('#depositForm')[0].reset();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Deposit Failed',
                    text: data.message
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred while processing your deposit.'
            });
        }
    });
}

function withdrawFromAccount(savingId) {
    $('#withdrawal_amount').val(''); // Clear previous value
    $('#withdrawalModal').modal('show');
}

function submitWithdrawal(event) {
    event.preventDefault();

    const formData = new FormData(event.target);
    formData.append('saving_id', <?php echo e($saving->id); ?>);

    $.ajax({
        url: `<?php echo e(url('member/savings')); ?>/$<?php echo e($saving->id); ?>/withdraw`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data) {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Withdrawal Processed!',
                    text: 'Your withdrawal has been processed successfully.',
                    timer: 3000,
                    showConfirmButton: false
                });
                $('#withdrawalModal').modal('hide');
                $('#withdrawalForm')[0].reset();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Withdrawal Failed',
                    text: data.message
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred while processing your withdrawal.'
            });
        }
    });
}

// Reset forms when modals are hidden
$('#depositModal').on('hidden.bs.modal', function() {
    $('#depositForm')[0].reset();
});

$('#withdrawalModal').on('hidden.bs.modal', function() {
    $('#withdrawalForm')[0].reset();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views/member/savings/show.blade.php ENDPATH**/ ?>