<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Member Activities Report - <?php echo e($membership->membership_number); ?> - <?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .member-info {
            margin-bottom: 20px;
        }
        .member-info table {
            width: 100%;
            border-collapse: collapse;
        }
        .member-info th, .member-info td {
            padding: 5px;
            text-align: left;
            border: 1px solid #ddd;
        }
        .activities-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .activities-table th, .activities-table td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }
        .activities-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-completed {
            color: #28a745;
        }
        .status-pending {
            color: #ffc107;
        }
        .status-approved {
            color: #17a2b8;
        }
        .status-rejected {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?></h1>
        <h2>Member Activities Report</h2>
        <p>Generated on: <?php echo e(date('d M Y H:i:s')); ?></p>
    </div>

    <div class="member-info">
        <h3>Member Information</h3>
        <table>
            <tr>
                <th>Membership Number:</th>
                <td><?php echo e($membership->membership_number); ?></td>
                <th>Full Name:</th>
                <td><?php echo e($membership->user->full_name); ?></td>
            </tr>
            <tr>
                <th>ID Number:</th>
                <td><?php echo e($membership->user->id_number); ?></td>
                <th>Phone:</th>
                <td><?php echo e($membership->user->phone_number); ?></td>
            </tr>
            <tr>
                <th>Email:</th>
                <td><?php echo e($membership->user->email); ?></td>
                <th>Branch:</th>
                <td><?php echo e($membership->user->branch->name ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Joining Date:</th>
                <td><?php echo e($membership->joining_date->format('d M Y')); ?></td>
                <th>Status:</th>
                <td><?php echo e(ucfirst($membership->status)); ?></td>
            </tr>
        </table>
    </div>

    <div>
        <h3>Recent Activities</h3>
        <table class="activities-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Description</th>
                    <th>Module</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e(date('d M Y H:i', strtotime($activity['date']))); ?></td>
                    <td><?php echo e($activity['type']); ?></td>
                    <td class="text-right">KSh <?php echo e(number_format($activity['amount'], 2)); ?></td>
                    <td>
                        <span class="status-<?php echo e(strtolower($activity['status'])); ?>">
                            <?php echo e($activity['status']); ?>

                        </span>
                    </td>
                    <td><?php echo e($activity['description']); ?></td>
                    <td><?php echo e($activity['module']); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center">No activities found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div style="margin-top: 40px; text-align: center; font-size: 10px; color: #666;">
        <p>This report was generated automatically by the <?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?> system.</p>
        <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(\App\Models\SystemSetting::get('system_name', 'Morio Sacco')); ?>. All rights reserved.</p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\memberships\exports\activities_pdf.blade.php ENDPATH**/ ?>