<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Investment Calculator</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('member.money-market.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Investments
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Calculator Form -->
                        <div class="col-md-6">
                            <h5>Calculate Your Investment Returns</h5>
                            <p class="text-muted">Use this calculator to estimate your potential returns on money market investments.</p>

                            <form id="calculatorForm">
                                <div class="form-group">
                                    <label for="calc_principal">Principal Amount (KES)</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo e(\App\Helpers\CurrencyHelper::getSymbol('KES')); ?></span>
                                        </div>
                                        <input type="number" class="form-control" id="calc_principal" min="1000" step="100" value="10000" required>
                                    </div>
                                    <small class="form-text text-muted">Minimum: <?php echo e(\App\Helpers\CurrencyHelper::format(1000, 'KES')); ?></small>
                                </div>

                                <div class="form-group">
                                    <label for="calc_rate">Interest Rate (% per annum)</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="calc_rate" min="0" max="50" step="0.1" value="8.5" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="calc_term">Investment Term (Months)</label>
                                    <select class="form-control" id="calc_term" required>
                                        <option value="3">3 Months</option>
                                        <option value="6" selected>6 Months</option>
                                        <option value="12">12 Months</option>
                                        <option value="24">24 Months</option>
                                        <option value="36">36 Months</option>
                                        <option value="48">48 Months</option>
                                        <option value="60">60 Months</option>
                                    </select>
                                </div>

                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-calculator"></i> Calculate Returns
                                </button>
                            </form>
                        </div>

                        <!-- Results Display -->
                        <div class="col-md-6">
                            <h5>Investment Summary</h5>
                            <div id="results" class="d-none">
                                <div class="card border-success">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">Projected Returns</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-6">
                                                <strong>Principal Amount:</strong><br>
                                                <span id="result-principal" class="text-primary">-</span>
                                            </div>
                                            <div class="col-6">
                                                <strong>Interest Earned:</strong><br>
                                                <span id="result-interest" class="text-success">-</span>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-6">
                                                <strong>Total Amount:</strong><br>
                                                <span id="result-total" class="text-info font-weight-bold">-</span>
                                            </div>
                                            <div class="col-6">
                                                <strong>Monthly Interest:</strong><br>
                                                <span id="result-monthly" class="text-warning">-</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-3">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i>
                                        <strong>Note:</strong> This is an estimate based on simple interest calculation.
                                        Actual returns may vary based on the specific terms and conditions of your investment.
                                    </div>
                                </div>
                            </div>

                            <div id="no-results" class="text-center py-5">
                                <i class="fas fa-calculator fa-3x text-muted mb-3"></i>
                                <h6 class="text-muted">Enter your investment details to see projected returns</h6>
                            </div>
                        </div>
                    </div>

                    <!-- Investment Tips -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5>Investment Tips</h5>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <h6 class="card-title">
                                                <i class="fas fa-clock text-primary"></i> Long-term Benefits
                                            </h6>
                                            <p class="card-text small">Longer investment terms generally offer better interest rates and higher returns.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <h6 class="card-title">
                                                <i class="fas fa-shield-alt text-success"></i> Risk-free Investment
                                            </h6>
                                            <p class="card-text small">Money market investments are low-risk, providing stable returns with capital protection.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <h6 class="card-title">
                                                <i class="fas fa-piggy-bank text-warning"></i> Regular Savings
                                            </h6>
                                            <p class="card-text small">Start with smaller amounts and gradually increase your investment over time.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $('#calculatorForm').on('submit', function(e) {
        e.preventDefault();

        const principal = parseFloat($('#calc_principal').val());
        const rate = parseFloat($('#calc_rate').val());
        const termMonths = parseInt($('#calc_term').val());

        if (principal >= 1000 && rate >= 0 && rate <= 50 && termMonths > 0) {
            // Send AJAX request to calculate
            $.post('<?php echo e(route("member.money-market.calculate")); ?>', {
                _token: '<?php echo e(csrf_token()); ?>',
                principal: principal,
                rate: rate,
                term_months: termMonths
            }).done(function(response) {
                $('#result-principal').text(formatCurrency(response.principal));
                $('#result-interest').text(formatCurrency(response.interest));
                $('#result-total').text(formatCurrency(response.total));
                $('#result-monthly').text(formatCurrency(response.monthly_interest));

                $('#results').removeClass('d-none');
                $('#no-results').addClass('d-none');
            }).fail(function(xhr) {
                alert('Error calculating returns. Please try again.');
            });
        } else {
            alert('Please enter valid values.');
        }
    });

    // Auto-calculate on input change
    $('#calc_principal, #calc_rate, #calc_term').on('input change', function() {
        // Optional: auto-calculate without form submission
    });

    function formatCurrency(amount) {
        return '<?php echo e(\App\Helpers\CurrencyHelper::getSymbol("KES")); ?> ' + amount.toLocaleString();
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views/member/money-market/calculator.blade.php ENDPATH**/ ?>