

<?php $__env->startSection('title', 'M-Pesa Credentials Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa API Configuration Details</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('mpesa-credentials.edit', $mpesaCredential)); ?>" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('mpesa-credentials.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Credentials
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-bordered">
                                <tr>
                                    <th class="bg-light" style="width: 200px;">Credential ID</th>
                                    <td><?php echo e($mpesaCredential->id); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Consumer Key</th>
                                    <td>
                                        <code><?php echo e(substr($mpesaCredential->consumer_key, 0, 10)); ?>...</code>
                                        <small class="text-muted">(hidden for security)</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Consumer Secret</th>
                                    <td>
                                        <code><?php echo e(substr($mpesaCredential->consumer_secret, 0, 10)); ?>...</code>
                                        <small class="text-muted">(hidden for security)</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Shortcode</th>
                                    <td><strong><?php echo e($mpesaCredential->shortcode); ?></strong></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Passkey</th>
                                    <td>
                                        <code><?php echo e(substr($mpesaCredential->passkey, 0, 10)); ?>...</code>
                                        <small class="text-muted">(hidden for security)</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Environment</th>
                                    <td>
                                        <span class="badge badge-<?php echo e($mpesaCredential->environment === 'production' ? 'success' : 'warning'); ?> badge-lg">
                                            <?php echo e(ucfirst($mpesaCredential->environment)); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Status</th>
                                    <td>
                                        <span class="badge badge-<?php echo e($mpesaCredential->is_active ? 'success' : 'secondary'); ?> badge-lg">
                                            <?php echo e($mpesaCredential->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Created</th>
                                    <td><?php echo e($mpesaCredential->created_at->format('d M Y H:i')); ?></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Last Updated</th>
                                    <td><?php echo e($mpesaCredential->updated_at->format('d M Y H:i')); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-mobile-alt"></i> M-Pesa Status
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <?php if($mpesaCredential->is_active): ?>
                                        <div class="text-center">
                                            <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                            <h6 class="text-success">Active Configuration</h6>
                                            <p class="text-muted small">This configuration is currently being used for M-Pesa payments</p>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center">
                                            <i class="fas fa-pause-circle fa-3x text-secondary mb-3"></i>
                                            <h6 class="text-secondary">Inactive Configuration</h6>
                                            <p class="text-muted small">This configuration is not currently active</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="card border-warning mt-3">
                                <div class="card-header bg-warning text-dark">
                                    <h6 class="card-title mb-0">
                                        <i class="fas fa-shield-alt"></i> Security Notice
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled small mb-0">
                                        <li><i class="fas fa-lock text-success"></i> Credentials are encrypted</li>
                                        <li><i class="fas fa-eye-slash text-success"></i> Sensitive data is masked</li>
                                        <li><i class="fas fa-user-shield text-success"></i> Access restricted to admins</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Environment:</strong>
                                <?php if($mpesaCredential->environment === 'sandbox'): ?>
                                    <span class="badge badge-warning">Sandbox - Testing Environment</span>
                                <?php else: ?>
                                    <span class="badge badge-success">Production - Live Environment</span>
                                <?php endif; ?>
                            </small>
                        </div>
                        <div class="col-md-6 text-right">
                            <form action="<?php echo e(route('mpesa-credentials.destroy', $mpesaCredential)); ?>" method="POST" class="d-inline"
                                  onsubmit="return confirm('Are you sure you want to delete these M-Pesa credentials? This action cannot be undone.')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i> Delete Credentials
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Test Connection Section -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Test M-Pesa Connection</h3>
                </div>
                <div class="card-body">
                    <p class="text-muted">Test your M-Pesa configuration to ensure it's working correctly.</p>
                    <button type="button" class="btn btn-info" onclick="testMpesaConnection(<?php echo e($mpesaCredential->id); ?>)" id="testConnectionBtn">
                        <i class="fas fa-plug"></i> Test Connection
                    </button>
                    <div id="testResult" class="mt-3" style="display: none;"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function testMpesaConnection(credentialId) {
    const button = document.getElementById('testConnectionBtn');
    const resultDiv = document.getElementById('testResult');

    // Show loading state
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Testing...';
    button.disabled = true;
    resultDiv.style.display = 'none';

    // Make AJAX request to test connection
    fetch('/mpesa-credentials/' + credentialId + '/test-connection', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        resultDiv.style.display = 'block';
        if (data.success) {
            resultDiv.innerHTML = `
                <div class="alert alert-success">
                    <h5><i class="icon fas fa-check"></i> Connection Successful!</h5>
                    <p>${data.message}</p>
                </div>
            `;
        } else {
            resultDiv.innerHTML = `
                <div class="alert alert-danger">
                    <h5><i class="icon fas fa-times"></i> Connection Failed</h5>
                    <p>${data.message || 'Unknown error occurred'}</p>
                </div>
            `;
        }
    })
    .catch(error => {
        resultDiv.style.display = 'block';
        resultDiv.innerHTML = `
            <div class="alert alert-danger">
                <h5><i class="icon fas fa-exclamation-triangle"></i> Error</h5>
                <p>Failed to test connection: ${error.message}</p>
            </div>
        `;
    })
    .finally(() => {
        button.innerHTML = '<i class="fas fa-plug"></i> Test Connection';
        button.disabled = false;
    });
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\mpesa-credentials\show.blade.php ENDPATH**/ ?>