<?php $__env->startSection('title', 'Transaction Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
<h2 class="mb-4" style="color: black;">Transactions</h2>
    <!-- System Health & Quick Stats -->
    <div class="row mb-3">
        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-primary shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                System Health
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($realTimeData['system_health']['success_rate']); ?>%
                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-heartbeat mr-1"></i>
                                Success Rate
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-heartbeat"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-success shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Members
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($realTimeData['system_health']['active_members']); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-users mr-1"></i>
                                Of <?php echo e($realTimeData['system_health']['total_members']); ?>

                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-users"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-info shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Today's Activity
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($realTimeData['recent_activities']->count() + $realTimeData['recent_shares_purchased']); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-clock mr-1"></i>
                                Last 24 hours
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-clock"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-warning shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Pending Items
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($realTimeData['pending_loans'] + $realTimeData['system_health']['pending_transactions']); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                Loans + Transactions
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Shares Statistics Row -->
    <div class="row mb-3">
        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-info shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Shares
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e(number_format($realTimeData['total_shares'])); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-share-alt mr-1"></i>
                                Shares owned
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-share-alt"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-success shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Shares Value
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                KSh <?php echo e(number_format($realTimeData['total_shares_value'], 0)); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-money-bill-wave mr-1"></i>
                                Total investment
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-primary shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Shareholders
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($realTimeData['total_shareholders']); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-users mr-1"></i>
                                Active members
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-users"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6 col-md-6 col-12">
            <div class="card border-left-secondary shadow-sm compact-top-card">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                                Recent Shares
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($realTimeData['recent_shares_purchased']); ?>

                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-clock mr-1"></i>
                                Last 30 days
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <i class="fas fa-clock"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Dashboard Grid -->
    <div class="row">
        <!-- Financial Overview & Charts -->
        <div class="col-lg-12">
        </div>
    </div>

    <!-- Filters and Table -->
    <div class="row">
        <div class="col-12">
            <!-- Filters Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Filter Transactions</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('transactions.index')); ?>" class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Activity Type</label>
                                <select name="activity_type" class="form-control">
                                    <option value="all" <?php echo e(request('activity_type', 'all') == 'all' ? 'selected' : ''); ?>>All Activities</option>
                                    <option value="transaction" <?php echo e(request('activity_type') == 'transaction' ? 'selected' : ''); ?>>Financial Transactions</option>
                                    <option value="savings" <?php echo e(request('activity_type') == 'savings' ? 'selected' : ''); ?>>Savings Activities</option>
                                    <option value="loan" <?php echo e(request('activity_type') == 'loan' ? 'selected' : ''); ?>>Loan Activities</option>
                                    <option value="shares" <?php echo e(request('activity_type') == 'shares' ? 'selected' : ''); ?>>Shares Activities</option>
                                    <option value="membership" <?php echo e(request('activity_type') == 'membership' ? 'selected' : ''); ?>>Membership Activities</option>
                                    <option value="login" <?php echo e(request('activity_type') == 'login' ? 'selected' : ''); ?>>Login Activities</option>
                                    <option value="system" <?php echo e(request('activity_type') == 'system' ? 'selected' : ''); ?>>System Activities</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Member</label>
                                <select name="user_id" class="form-control">
                                    <option value="">All Members</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                                        <?php echo e($user->full_name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>From Date</label>
                                <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from', now()->subDays(30)->format('Y-m-d'))); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>To Date</label>
                                <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to', now()->format('Y-m-d'))); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-search"></i> Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-secondary btn-block">
                                        <i class="fas fa-times"></i> Clear
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- System Activity Feed -->
            <div class="card compact-activity-card">
                <div class="card-header py-2">
                    <h3 class="card-title mb-0">System Activity Feed</h3>
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="<?php echo e(route('transactions.create')); ?>" class="btn btn-success btn-xs">
                                <i class="fas fa-plus"></i> Add
                            </a>
                        </div>
                        <div class="btn-group ml-1">
                            <button type="button" class="btn btn-info btn-xs dropdown-toggle" data-toggle="dropdown">
                                <i class="fas fa-download"></i> Export
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="<?php echo e(route('transactions.export.csv', request()->query())); ?>" target="_blank">
                                    <i class="fas fa-file-csv text-success"></i> CSV
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('transactions.export.excel', request()->query())); ?>" target="_blank">
                                    <i class="fas fa-file-excel text-success"></i> Excel
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('transactions.export.pdf', request()->query())); ?>" target="_blank">
                                    <i class="fas fa-file-pdf text-danger"></i> PDF
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="activity-feed compact">
                        <?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="activity-item border-bottom py-2 px-3 hover-bg-light" style="transition: background-color 0.2s;">
                            <div class="d-flex align-items-center">
                                <!-- Activity Icon -->
                                <div class="activity-icon mr-2">
                                    <div class="bg-light rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                        <?php if($activity['type'] === 'transaction'): ?>
                                            <i class="<?php echo e($activity['icon']); ?>"></i>
                                        <?php else: ?>
                                            <i class="<?php echo e($activity['icon']); ?>"></i>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Activity Content -->
                                <div class="activity-content flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="flex-grow-1">
                                            <div class="d-flex align-items-center mb-1">
                                                <h6 class="mb-0 font-weight-bold text-dark mr-2" style="font-size: 0.9rem;">
                                                    <?php echo e($activity['title']); ?>

                                                </h6>
                                                <span class="badge badge-<?php echo e($activity['color']); ?> badge-xs">
                                                    <?php echo e(ucfirst($activity['status'])); ?>

                                                </span>
                                            </div>
                                            <p class="mb-1 text-xs text-muted" style="font-size: 0.8rem;">
                                                <?php echo e($activity['description']); ?>

                                            </p>
                                            <small class="text-muted" style="font-size: 0.75rem;">
                                                <i class="fas fa-user mr-1"></i><?php echo e($activity['member']); ?> •
                                                <i class="fas fa-clock mr-1"></i><?php echo e($activity['timestamp']->format('d M Y H:i')); ?> •
                                                <i class="fas fa-cogs mr-1"></i><?php echo e($activity['module']); ?>

                                            </small>
                                        </div>
                                        <div class="text-right ml-2">
                                            <!-- Amount (if applicable) -->
                                            <?php if($activity['amount'] > 0): ?>
                                            <div class="font-weight-bold text-<?php echo e($activity['type'] === 'savings' && $activity['subtype'] === 'withdrawal' ? 'danger' : 'success'); ?>" style="font-size: 0.9rem;">
                                                KSh <?php echo e(number_format($activity['amount'], 0)); ?>

                                            </div>
                                            <?php endif; ?>
                                            <!-- Reference -->
                                            <?php if(isset($activity['reference'])): ?>
                                            <small class="text-muted" style="font-size: 0.7rem;"><?php echo e($activity['reference']); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-4">
                            <div class="text-muted">
                                <i class="fas fa-inbox fa-3x mb-2 text-light"></i>
                                <h6 class="mb-1">No Activities Found</h6>
                                <p class="text-xs mb-0">Try adjusting your filters.</p>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if($activities->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($activities->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>

<style>
.activity-feed {
    max-height: none;
}

.activity-feed.compact .activity-item {
    padding: 0.5rem 0.75rem;
}

.activity-item {
    transition: all 0.2s ease;
}

.activity-item:hover {
    background-color: #f8f9fa !important;
    transform: translateX(1px);
}

.activity-icon {
    flex-shrink: 0;
}

.activity-content h6 {
    font-size: 0.95rem;
    margin-bottom: 0.25rem;
}

.activity-content p {
    font-size: 0.875rem;
    margin-bottom: 0.25rem;
}

.badge-sm {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

.badge-xs {
    font-size: 0.65rem;
    padding: 0.2rem 0.4rem;
}

.hover-bg-light:hover {
    background-color: #f8f9fa !important;
}

.compact-activity-card .card-header {
    padding: 0.5rem 1rem;
}

.compact-activity-card .card-title {
    font-size: 1rem;
}

.btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .activity-item {
        padding: 1rem 0.75rem;
    }

    .activity-icon {
        margin-right: 0.75rem;
    }

    .activity-content h6 {
        font-size: 0.9rem;
    }
}
</style>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.border-left-secondary {
    border-left: 4px solid #6c757d !important;
}

.border-left-danger {
    border-left: 4px solid #e74a3b !important;
}

.card-body {
    padding: 1.5rem;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-secondary {
    color: #6c757d !important;
}

.text-danger {
    color: #e74a3b !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Compact card styling */
.compact-card, .compact-top-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-card .card-body, .compact-top-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-card .h6, .compact-top-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-card .text-xs, .compact-top-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-card {
        height: auto;
        min-height: 70px;
    }

    .compact-card .card-body {
        padding: 0.5rem 0.75rem !important;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<script>

// Add smooth animations to activity items
const activityItems = document.querySelectorAll('.activity-item');

activityItems.forEach((item, index) => {
    item.style.opacity = '0';
    item.style.transform = 'translateY(20px)';

    setTimeout(() => {
        item.style.transition = 'all 0.3s ease';
        item.style.opacity = '1';
        item.style.transform = 'translateY(0)';
    }, index * 50);
});

// Add click animation
activityItems.forEach(item => {
    item.addEventListener('click', function() {
        this.style.transform = 'scale(0.98)';
        setTimeout(() => {
            this.style.transform = '';
        }, 150);
    });
});
</script>
<?php $__env->stopPush(); ?>>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\transactions\index.blade.php ENDPATH**/ ?>