<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Welcome to Morio Sacco</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #247f1b; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; background-color: #f9f9f9; }
        .welcome-message { background-color: white; padding: 15px; border-left: 4px solid #247f1b; margin: 20px 0; }
        .footer { background-color: #333; color: white; padding: 10px; text-align: center; font-size: 12px; }
        .btn { display: inline-block; padding: 10px 20px; background-color: #247f1b; color: white; text-decoration: none; border-radius: 5px; }
        .member-details { background-color: white; padding: 15px; margin: 15px 0; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Welcome to Morio Sacco</h1>
            <p>Your membership is now fully active!</p>
        </div>

        <div class="content">
            <h2>Dear <?php echo e($user->full_name); ?>,</h2>

            <div class="welcome-message">
                <h3>🎉 Congratulations!</h3>
                <p>Your registration fee payment has been successfully processed, and your membership with Morio Sacco is now fully active. You can now enjoy all the benefits of being a member of our sacco.</p>
            </div>

            <div class="member-details">
                <h4>Your Membership Details</h4>
                <p><strong>Membership Number:</strong> <?php echo e($membership->membership_number); ?></p>
                <p><strong>Full Name:</strong> <?php echo e($user->full_name); ?></p>
                <p><strong>Email:</strong> <?php echo e($user->email); ?></p>
                <p><strong>Phone:</strong> <?php echo e($user->phone_number); ?></p>
                <p><strong>Branch:</strong> <?php echo e($membership->user->branch->name ?? 'N/A'); ?></p>
                <p><strong>Joining Date:</strong> <?php echo e($membership->joining_date->format('d M Y')); ?></p>
                <p><strong>Status:</strong> <span style="color: #28a745; font-weight: bold;">Active</span></p>
            </div>

            <h3>What you can do now:</h3>
            <ul>
                <li>✅ Apply for loans</li>
                <li>✅ Make savings deposits</li>
                <li>✅ Access your dashboard</li>
                <li>✅ View transaction history</li>
                <li>✅ Download statements and reports</li>
                <li>✅ Participate in member meetings</li>
                <li>✅ Receive dividends</li>
            </ul>

            <p>You can access your account at: <a href="<?php echo e(url('/login')); ?>" class="btn">Login to Your Account</a></p>

            <p>If you have any questions or need assistance, please don't hesitate to contact our support team.</p>

            <p>Welcome to the Morio Sacco family!</p>

            <p>Best regards,<br>
            Morio Sacco Management Team</p>
        </div>

        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Morio Sacco. All rights reserved.</p>
            <p>This is an automated message. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\emails\member-welcome.blade.php ENDPATH**/ ?>