<?php $__env->startSection('title', 'Money Market Accounts'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Money Market Accounts</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Compact Statistics Cards - Dynamic Financial Data -->
<div class="row mb-3">
    <!-- Total Principal Amount -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Principal
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(\App\Helpers\CurrencyHelper::format($stats['total_principal'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-money-bill-wave mr-1"></i>
                            Invested capital
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Interest Earned -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Interest Earned
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(\App\Helpers\CurrencyHelper::format($stats['total_interest_earned'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-chart-line mr-1"></i>
                            Revenue from investments
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Accounts -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Active Accounts
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(number_format($stats['active_accounts'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-play-circle mr-1"></i>
                            Currently earning interest
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-play-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Nearing Maturity -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Nearing Maturity
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(number_format($stats['nearing_maturity'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            Require attention
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Additional Statistics Row -->
<div class="row mb-3">
    <!-- Total Accounts -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-dark shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">
                            Total Accounts
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(number_format($stats['total_accounts'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-chart-line mr-1"></i>
                            All money market accounts
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-dark text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Matured Accounts -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-secondary shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Matured Accounts
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(number_format($stats['matured_accounts'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-clock mr-1"></i>
                            Ready for withdrawal
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Average Interest Rate -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Avg Interest Rate
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php if($moneyMarketAccounts->count() > 0): ?>
                                <?php echo e(number_format($moneyMarketAccounts->avg('interest_rate'), 2)); ?>%
                            <?php else: ?>
                                0.00%
                            <?php endif; ?>
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-percent mr-1"></i>
                            Current average rate
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-percent"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Value -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-loans-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Portfolio Value
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e(\App\Helpers\CurrencyHelper::format($stats['total_principal'] + $stats['total_interest_earned'])); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-coins mr-1"></i>
                            Principal + Interest
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-coins"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Money Market Accounts</h3>
                    <div class="card-tools">
                        <!-- Export Buttons -->
                        <div class="btn-group mr-2">
                            <button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                    style="background: linear-gradient(45deg, #247f1b, #2d8a1f); border: 2px solid #247f1b; color: white; font-weight: 600; box-shadow: 0 0 10px rgba(36, 113, 27, 0.3); transition: all 0.3s ease;"
                                    onmouseover="this.style.background='linear-gradient(45deg, #2d8a1f, #247f1b)'; this.style.boxShadow='0 0 20px rgba(36, 113, 27, 0.6)'; this.style.transform='translateY(-1px)'"
                                    onmouseout="this.style.background='linear-gradient(45deg, #247f1b, #2d8a1f)'; this.style.boxShadow='0 0 10px rgba(36, 113, 27, 0.3)'; this.style.transform='translateY(0)'">
                                <i class="fas fa-download"></i> Export
                            </button>
                            <div class="dropdown-menu" style="border: 2px solid #247f1b; border-radius: 8px; box-shadow: 0 4px 20px rgba(36, 113, 27, 0.2);">
                                <a class="dropdown-item" href="<?php echo e(route('money-market-accounts.export.pdf')); ?>" target="_blank"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-pdf" style="color: #ff3c30; margin-right: 8px;"></i> Export as PDF
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('money-market-accounts.export.excel')); ?>"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-excel" style="color: #28a745; margin-right: 8px;"></i> Export as Excel
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('money-market-accounts.export.csv')); ?>"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-csv" style="color: #17a2b8; margin-right: 8px;"></i> Export as CSV
                                </a>
                            </div>
                        </div>
                        <!-- Update Interest Button -->
                        <button type="button" class="btn btn-info btn-sm mr-2" onclick="updateInterest()">
                            <i class="fas fa-calculator"></i> Update Interest
                        </button>
                        <!-- Add Account Button -->
                        <a href="<?php echo e(route('money-market-accounts.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Account
                        </a>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <!-- Filters -->
                    <div class="p-3 border-bottom">
                        <form method="GET" class="row">
                            <div class="col-md-3 mb-2">
                                <select name="status" class="form-control form-control-sm">
                                    <option value="">All Status</option>
                                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                    <option value="matured" <?php echo e(request('status') == 'matured' ? 'selected' : ''); ?>>Matured</option>
                                    <option value="withdrawn" <?php echo e(request('status') == 'withdrawn' ? 'selected' : ''); ?>>Withdrawn</option>
                                    <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-2">
                                <select name="membership_id" class="form-control form-control-sm">
                                    <option value="">All Members</option>
                                    <?php $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($membership->id); ?>" <?php echo e(request('membership_id') == $membership->id ? 'selected' : ''); ?>>
                                        <?php echo e(Str::limit($membership->user->full_name ?? 'N/A', 20)); ?> (<?php echo e($membership->membership_number); ?>)
                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3 mb-2">
                                <input type="text" name="search" class="form-control form-control-sm" placeholder="Search by account number or name" value="<?php echo e(request('search')); ?>">
                            </div>
                            <div class="col-md-3 mb-2">
                                <div class="btn-group btn-group-sm">
                                    <button type="submit" class="btn btn-secondary btn-sm">
                                        <i class="fas fa-filter"></i> Filter
                                    </button>
                                    <a href="<?php echo e(route('money-market-accounts.index')); ?>" class="btn btn-outline-secondary btn-sm">
                                        <i class="fas fa-times"></i> Clear
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>

                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th">Account #</th>
                                <th class="compact-th">Member</th>
                                <th class="compact-th">Principal</th>
                                <th class="compact-th d-none d-lg-table-cell">Rate</th>
                                <th class="compact-th d-none d-md-table-cell">Term</th>
                                <th class="compact-th d-none d-lg-table-cell">Interest</th>
                                <th class="compact-th d-none d-xl-table-cell">Total</th>
                                <th class="compact-th d-none d-lg-table-cell">Maturity</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $moneyMarketAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="compact-row">
                                <td class="compact-td">
                                    <div class="font-weight-medium"><?php echo e($account->account_number); ?></div>
                                </td>
                                <td class="compact-td">
                                    <div class="font-weight-medium"><?php echo e(Str::limit($account->membership->user->full_name ?? 'N/A', 18)); ?></div>
                                    <div class="text-xs text-muted"><?php echo e($account->membership->membership_number); ?></div>
                                </td>
                                <td class="compact-td text-nowrap"><?php echo e(\App\Helpers\CurrencyHelper::format($account->principal_amount, $account->currency_code)); ?></td>
                                <td class="compact-td d-none d-lg-table-cell"><?php echo e(number_format($account->interest_rate, 2)); ?>%</td>
                                <td class="compact-td d-none d-md-table-cell"><?php echo e($account->term_months); ?>m</td>
                                <td class="compact-td d-none d-lg-table-cell text-nowrap"><?php echo e(\App\Helpers\CurrencyHelper::format($account->interest_earned, $account->currency_code)); ?></td>
                                <td class="compact-td d-none d-xl-table-cell text-nowrap"><?php echo e(\App\Helpers\CurrencyHelper::format($account->total_amount, $account->currency_code)); ?></td>
                                <td class="compact-td d-none d-lg-table-cell"><?php echo e($account->maturity_date->format('M d, Y')); ?></td>
                                <td class="compact-td">
                                    <span class="badge badge-sm badge-<?php echo e($account->status === 'active' ? 'success' : ($account->status === 'matured' ? 'warning' : ($account->status === 'withdrawn' ? 'info' : 'secondary'))); ?>">
                                        <?php echo e(ucfirst($account->status)); ?>

                                    </span>
                                </td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="<?php echo e(route('money-market-accounts.show', $account)); ?>" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php if($account->status === 'active'): ?>
                                        <a href="<?php echo e(route('money-market-accounts.edit', $account)); ?>" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if($account->status === 'active' || $account->status === 'matured'): ?>
                                        <button type="button" class="btn btn-danger btn-xs" onclick="withdrawAccount(<?php echo e($account->id); ?>, '<?php echo e($account->account_number); ?>')" title="Withdraw">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </button>
                                        <?php endif; ?>
                                        <?php if($account->isMatured() && $account->status === 'active'): ?>
                                        <button type="button" class="btn btn-success btn-xs" onclick="markAsMatured(<?php echo e($account->id); ?>)" title="Mark Matured">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-chart-line fa-3x mb-3"></i>
                                        <h5>No Money Market Accounts Yet</h5>
                                        <p>Start by adding your first money market account to the system.</p>
                                        <a href="<?php echo e(route('money-market-accounts.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add First Account
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($moneyMarketAccounts->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($moneyMarketAccounts->appends(request()->query())->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.border-left-dark {
    border-left: 4px solid #5a5c69 !important;
}

.border-left-secondary {
    border-left: 4px solid #858796 !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact loans card styling */
.compact-loans-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-loans-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-loans-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-loans-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-dark {
    color: #5a5c69 !important;
}

.text-secondary {
    color: #858796 !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.font-weight-medium {
    font-weight: 500;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('js'); ?>
<script>
function updateInterest() {
    Swal.fire({
        title: 'Update Interest',
        text: 'Are you sure you want to update interest for all accounts?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#247f1b',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, Update Interest'
    }).then((result) => {
        if (result.isConfirmed) {
            $.post('<?php echo e(route("money-market-accounts.update-interest")); ?>', {
                _token: '<?php echo e(csrf_token()); ?>'
            }).done(function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: 'Interest updated successfully!',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            }).fail(function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: xhr.responseJSON?.message || 'Failed to update interest'
                });
            });
        }
    });
}

function withdrawAccount(accountId, accountNumber) {
    Swal.fire({
        title: 'Withdraw from Account',
        input: 'number',
        inputLabel: `Enter withdrawal amount for account ${accountNumber}`,
        inputPlaceholder: 'Enter amount',
        inputAttributes: {
            min: 0,
            step: 0.01
        },
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Withdraw',
        inputValidator: (value) => {
            if (!value || value <= 0) {
                return 'Please enter a valid amount!';
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`<?php echo e(url('money-market-accounts')); ?>/${accountId}/withdraw`, {
                _token: '<?php echo e(csrf_token()); ?>',
                withdrawal_amount: result.value
            }).done(function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: 'Withdrawal processed successfully!',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            }).fail(function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: xhr.responseJSON?.message || 'Withdrawal failed'
                });
            });
        }
    });
}

function markAsMatured(accountId) {
    Swal.fire({
        title: 'Mark as Matured',
        text: 'Are you sure you want to mark this account as matured?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, Mark as Matured'
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`<?php echo e(url('money-market-accounts')); ?>/${accountId}/mark-matured`, {
                _token: '<?php echo e(csrf_token()); ?>'
            }).done(function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: 'Account marked as matured!',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            }).fail(function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: xhr.responseJSON?.message || 'Failed to mark account as matured'
                });
            });
        }
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\money-market-accounts\index.blade.php ENDPATH**/ ?>