<?php $__env->startSection('title', 'Branches Management'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Branches Management</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

<!-- Compact Statistics Cards - Branch Overview -->
<div class="row mb-3">
    <!-- Total Branches -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-branches-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Branches
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($branches->count()); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-building mr-1"></i>
                            Active locations
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-building"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Members Across Branches -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-branches-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Members
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($branches->sum(fn($branch) => $branch->users()->count())); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-users mr-1"></i>
                            Across all branches
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Branches with Contact -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-branches-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Contact Info
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($branches->where('contact', '!=', null)->count()); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-phone mr-1"></i>
                            Branches with contact details
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-phone"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Branches with Manager -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-branches-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Managed Branches
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            <?php echo e($branches->where('manager', '!=', null)->count()); ?>

                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-tie mr-1"></i>
                            Branches with assigned managers
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-tie"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Branches Table -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Sacco Branches</h3>
                    <div class="card-tools">
                        <!-- Export Buttons -->
                        <div class="btn-group mr-2">
                            <button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                    style="background: linear-gradient(45deg, #247f1b, #2d8a1f); border: 2px solid #247f1b; color: white; font-weight: 600; box-shadow: 0 0 10px rgba(36, 113, 27, 0.3); transition: all 0.3s ease;"
                                    onmouseover="this.style.background='linear-gradient(45deg, #2d8a1f, #247f1b)'; this.style.boxShadow='0 0 20px rgba(36, 113, 27, 0.6)'; this.style.transform='translateY(-1px)'"
                                    onmouseout="this.style.background='linear-gradient(45deg, #247f1b, #2d8a1f)'; this.style.boxShadow='0 0 10px rgba(36, 113, 27, 0.3)'; this.style.transform='translateY(0)'">
                                <i class="fas fa-download"></i> Export
                            </button>
                            <div class="dropdown-menu" style="border: 2px solid #247f1b; border-radius: 8px; box-shadow: 0 4px 20px rgba(36, 113, 27, 0.2);">
                                <a class="dropdown-item" href="<?php echo e(route('branches.export.pdf')); ?>" target="_blank"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-pdf" style="color: #ff3c30; margin-right: 8px;"></i> Export as PDF
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('branches.export.excel')); ?>"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-excel" style="color: #28a745; margin-right: 8px;"></i> Export as Excel
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('branches.export.csv')); ?>"
                                   style="color: #247f1b; font-weight: 500; transition: all 0.2s ease;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#2d8a1f'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#247f1b'">
                                    <i class="fas fa-file-csv" style="color: #17a2b8; margin-right: 8px;"></i> Export as CSV
                                </a>
                            </div>
                        </div>
                        <!-- Add Branch Button -->
                        <a href="<?php echo e(route('branches.create')); ?>" class="btn btn-primary btn-sm" title="Add New Branch">
                            <i class="fas fa-plus"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <?php if($branches->isNotEmpty()): ?>
                        <table class="table table-hover text-nowrap table-sm compact-table">
                            <thead class="thead-light">
                                <tr>
                                    <th class="compact-th">ID</th>
                                    <th class="compact-th">Branch Name</th>
                                    <th class="compact-th d-none d-md-table-cell">Location</th>
                                    <th class="compact-th d-none d-lg-table-cell">Contact</th>
                                    <th class="compact-th d-none d-md-table-cell">Manager</th>
                                    <th class="compact-th">Members</th>
                                    <th class="compact-th d-none d-lg-table-cell">Created</th>
                                    <th class="compact-th">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="compact-row">
                                    <td class="compact-td"><?php echo e($branch->id); ?></td>
                                    <td class="compact-td">
                                        <div class="font-weight-medium"><?php echo e(Str::limit($branch->name, 20)); ?></div>
                                        <?php if($branch->description): ?>
                                            <small class="text-muted"><?php echo e(Str::limit($branch->description, 25)); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td class="compact-td d-none d-md-table-cell"><?php echo e(Str::limit($branch->location, 15)); ?></td>
                                    <td class="compact-td d-none d-lg-table-cell"><?php echo e($branch->contact ?? 'N/A'); ?></td>
                                    <td class="compact-td d-none d-md-table-cell"><?php echo e(Str::limit($branch->manager ?? 'N/A', 12)); ?></td>
                                    <td class="compact-td">
                                        <span class="badge badge-sm badge-info">
                                            <?php echo e($branch->users()->count()); ?>

                                        </span>
                                    </td>
                                    <td class="compact-td d-none d-lg-table-cell"><?php echo e($branch->created_at->format('d M')); ?></td>
                                    <td class="compact-td">
                                        <div class="btn-group btn-group-xs">
                                            <a href="<?php echo e(route('branches.show', $branch)); ?>" class="btn btn-info btn-xs" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('branches.edit', $branch)); ?>" class="btn btn-warning btn-xs" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('branches.destroy', $branch)); ?>" method="POST" class="d-inline"
                                                  onsubmit="return confirm('Are you sure you want to delete this branch? This will affect all associated members.')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <div class="text-muted">
                                <i class="fas fa-building fa-4x mb-3"></i>
                                <h4>No Branches Found</h4>
                                <p>You haven't added any branches yet. Start by adding your first branch.</p>
                                <a href="<?php echo e(route('branches.create')); ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> Add Branch
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if($branches->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($branches->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact branches card styling */
.compact-branches-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-branches-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-branches-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-branches-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.5rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.5rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 50px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

<?php $__env->startPush('js'); ?>
<?php if(session('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?php echo e(session("success")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>

<?php if(session('error')): ?>
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '<?php echo e(session("error")); ?>',
    timer: 3000,
    showConfirmButton: false
});
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\branches\index.blade.php ENDPATH**/ ?>