<?php $__env->startSection('title', 'Open Savings Account'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-piggy-bank mr-2"></i>Open Savings Account
                    </h3>
                    <div class="card-tools">
                        <span class="badge badge-primary">New Account</span>
                    </div>
                </div>

                <form action="<?php echo e(route('member.savings.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="card-body">
                        <div class="row">
                            <!-- Left Column: Account Details -->
                            <div class="col-md-6">
                                <div class="border-right pr-4">
                                    <h5 class="text-primary mb-3">
                                        <i class="fas fa-file-alt mr-2"></i>Account Details
                                    </h5>

                                    <!-- Account Type -->
                                    <div class="form-group">
                                        <label class="form-label">Account Type</label>
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="form-check">
                                                    <input type="radio" name="type" value="recurring" id="recurring" class="form-check-input" checked>
                                                    <label for="recurring" class="form-check-label">
                                                        <i class="fas fa-calendar-alt text-success mr-1"></i>Recurring Savings
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="form-check">
                                                    <input type="radio" name="type" value="fixed" id="fixed" class="form-check-input">
                                                    <label for="fixed" class="form-check-label">
                                                        <i class="fas fa-lock text-primary mr-1"></i>Fixed Deposit
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Initial Deposit -->
                                    <div class="form-group">
                                        <label for="amount" class="form-label">Initial Deposit (KSh)</label>
                                        <input type="number" name="amount" id="amount" value="<?php echo e(old('amount')); ?>"
                                                class="form-control form-control-sm <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                min="100" step="0.01" required>
                                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">Minimum deposit: KSh 100</small>
                                        <small class="form-text text-info">Payment will be initiated from: <?php echo e(auth()->user()->phone_number); ?></small>
                                    </div>

                                    <!-- Fixed Deposit Term -->
                                    <div class="form-group" id="termSection" style="display: none;">
                                        <label for="term_months" class="form-label">Deposit Term (Months)</label>
                                        <select name="term_months" id="term_months" class="form-control form-control-sm <?php $__errorArgs = ['term_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Select term</option>
                                            <option value="3" <?php echo e(old('term_months') == '3' ? 'selected' : ''); ?>>3 months</option>
                                            <option value="6" <?php echo e(old('term_months') == '6' ? 'selected' : ''); ?>>6 months</option>
                                            <option value="12" <?php echo e(old('term_months') == '12' ? 'selected' : ''); ?>>12 months</option>
                                            <option value="24" <?php echo e(old('term_months') == '24' ? 'selected' : ''); ?>>24 months</option>
                                            <option value="36" <?php echo e(old('term_months') == '36' ? 'selected' : ''); ?>>36 months</option>
                                        </select>
                                        <?php $__errorArgs = ['term_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column: Information -->
                            <div class="col-md-6">
                                <div class="pl-4">
                                    <!-- Account Benefits -->
                                    <h5 class="text-info mb-3">
                                        <i class="fas fa-star mr-2"></i>Account Benefits
                                    </h5>

                                    <div id="recurringBenefits">
                                        <div class="row mb-1">
                                            <div class="col-12">
                                                <div class="form-group mb-1">
                                                    <label class="form-label small">Flexible deposits and withdrawals</label>
                                                    <input type="text" value="✓ Available" class="form-control form-control-sm bg-light" readonly style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-1">
                                            <div class="col-12">
                                                <div class="form-group mb-1">
                                                    <label class="form-label small">Competitive interest rates</label>
                                                    <input type="text" value="✓ Available" class="form-control form-control-sm bg-light" readonly style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-1">
                                            <div class="col-12">
                                                <div class="form-group mb-1">
                                                    <label class="form-label small">Easy access to funds</label>
                                                    <input type="text" value="✓ Available" class="form-control form-control-sm bg-light" readonly style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="fixedBenefits" style="display: none;">
                                        <div class="row mb-1">
                                            <div class="col-12">
                                                <div class="form-group mb-1">
                                                    <label class="form-label small">Higher interest rates</label>
                                                    <input type="text" value="✓ Available" class="form-control form-control-sm bg-light" readonly style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-1">
                                            <div class="col-12">
                                                <div class="form-group mb-1">
                                                    <label class="form-label small">Guaranteed returns</label>
                                                    <input type="text" value="✓ Available" class="form-control form-control-sm bg-light" readonly style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-1">
                                            <div class="col-12">
                                                <div class="form-group mb-1">
                                                    <label class="form-label small">Disciplined savings</label>
                                                    <input type="text" value="✓ Available" class="form-control form-control-sm bg-light" readonly style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Important Information -->
                                    <h5 class="text-secondary mb-3 mt-4">
                                        <i class="fas fa-info-circle mr-2"></i>Important Information
                                    </h5>

                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">All deposits via M-Pesa</label>
                                                <input type="text" value="Required" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Minimum balance</label>
                                                <input type="text" value="KSh 100" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <div class="form-group mb-2">
                                                <label class="form-label small">Interest credited</label>
                                                <input type="text" value="Monthly" class="form-control form-control-sm bg-light" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer text-right">
                        <a href="<?php echo e(route('member.savings.index')); ?>" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-times mr-1"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-mobile-alt mr-1"></i>Create Account & Pay Deposit
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
$(document).ready(function() {
    const $recurringRadio = $('#recurring');
    const $fixedRadio = $('#fixed');
    const $termSection = $('#termSection');
    const $recurringBenefits = $('#recurringBenefits');
    const $fixedBenefits = $('#fixedBenefits');
    const $termSelect = $('#term_months');

    function updateForm() {
        if ($fixedRadio.is(':checked')) {
            $termSection.show();
            $termSelect.prop('required', true);
            $recurringBenefits.hide();
            $fixedBenefits.show();
        } else {
            $termSection.hide();
            $termSelect.prop('required', false);
            $recurringBenefits.show();
            $fixedBenefits.hide();
        }
    }

    $recurringRadio.on('change', updateForm);
    $fixedRadio.on('change', updateForm);

    // Initial state
    updateForm();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\member\savings\create.blade.php ENDPATH**/ ?>