<?php $__env->startSection('title', 'M-Pesa Credentials'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa API Configuration</h3>
                    <div class="card-tools">
                        <?php if($mpesaCredentials->isEmpty()): ?>
                            <a href="<?php echo e(route('mpesa-credentials.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Add M-Pesa Credentials
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <?php if($mpesaCredentials->isNotEmpty()): ?>
                        <table class="table table-hover text-nowrap">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Shortcode</th>
                                    <th>Environment</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $mpesaCredentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credential): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($credential->id); ?></td>
                                    <td><?php echo e($credential->shortcode); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($credential->environment === 'production' ? 'success' : 'warning'); ?>">
                                            <?php echo e(ucfirst($credential->environment)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo e($credential->is_active ? 'success' : 'secondary'); ?>">
                                            <?php echo e($credential->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($credential->created_at->format('d M Y')); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('mpesa-credentials.show', $credential)); ?>" class="btn btn-info btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('mpesa-credentials.edit', $credential)); ?>" class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <?php if($mpesaCredentials->count() > 1): ?>
                                            <form action="<?php echo e(route('mpesa-credentials.destroy', $credential)); ?>" method="POST" class="d-inline"
                                                  onsubmit="return confirm('Are you sure you want to delete these M-Pesa credentials?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <div class="text-muted">
                                <i class="fas fa-mobile-alt fa-4x mb-3"></i>
                                <h4>No M-Pesa Credentials Configured</h4>
                                <p>You need to configure M-Pesa credentials to enable mobile payments.</p>
                                <a href="<?php echo e(route('mpesa-credentials.create')); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Configure M-Pesa Credentials
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if($mpesaCredentials->isNotEmpty()): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa Configuration Guide</h3>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h5><i class="icon fas fa-info"></i> Important Notes:</h5>
                        <ul class="mb-0">
                            <li>Get your M-Pesa credentials from the <a href="https://developer.safaricom.co.ke/" target="_blank">Safaricom Developer Portal</a></li>
                            <li>Use <strong>sandbox</strong> environment for testing and <strong>production</strong> for live payments</li>
                            <li>Only one set of credentials can be active at a time</li>
                            <li>Keep your credentials secure and never share them publicly</li>
                        </ul>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h6>Sandbox Credentials (Testing)</h6>
                            <ul>
                                <li><strong>Consumer Key:</strong> Available on developer portal</li>
                                <li><strong>Consumer Secret:</strong> Available on developer portal</li>
                                <li><strong>Shortcode:</strong> Your test shortcode</li>
                                <li><strong>Passkey:</strong> Your test passkey</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Production Credentials (Live)</h6>
                            <ul>
                                <li><strong>Consumer Key:</strong> From production app</li>
                                <li><strong>Consumer Secret:</strong> From production app</li>
                                <li><strong>Shortcode:</strong> Your business shortcode</li>
                                <li><strong>Passkey:</strong> Your production passkey</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\morio_sacco\resources\views\adminlte\mpesa-credentials\index.blade.php ENDPATH**/ ?>