<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>My Loan Applications - {{ auth()->user()->full_name }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #28a745;
            padding-bottom: 20px;
        }
        .header h1 {
            color: #28a745;
            margin: 0;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .member-info {
            margin-bottom: 20px;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #28a745;
            color: white;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .status-approved {
            color: #28a745;
            font-weight: bold;
        }
        .status-pending {
            color: #ffc107;
            font-weight: bold;
        }
        .status-rejected {
            color: #dc3545;
            font-weight: bold;
        }
        .status-active {
            color: #007bff;
            font-weight: bold;
        }
        .status-defaulted {
            color: #6c757d;
            font-weight: bold;
        }
        .amount {
            font-weight: bold;
            color: #28a745;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 15px;
            background: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            display: table;
            width: 100%;
        }
        .summary-item {
            display: table-cell;
            padding: 5px;
            text-align: center;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #28a745;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <p>My Loan Applications Report</p>
        <p>Generated on: {{ date('F d, Y H:i:s') }}</p>
    </div>

    <div class="member-info">
        <strong>Member:</strong> {{ auth()->user()->full_name }}<br>
        <strong>Membership Number:</strong> {{ auth()->user()->membership->membership_number ?? 'N/A' }}<br>
        <strong>Branch:</strong> {{ auth()->user()->branch->name ?? 'N/A' }}<br>
        <strong>Email:</strong> {{ auth()->user()->email }}<br>
        <strong>Phone:</strong> {{ auth()->user()->phone_number }}
    </div>

    <div class="summary">
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-label">Total Applications</div>
                <div class="summary-value">{{ $loans->count() }}</div>
            </div>
            <div class="summary-item">
                <div class="summary-label">Active Loans</div>
                <div class="summary-value">{{ $loans->whereIn('status', ['approved', 'active'])->count() }}</div>
            </div>
            <div class="summary-item">
                <div class="summary-label">Pending</div>
                <div class="summary-value">{{ $loans->where('status', 'pending')->count() }}</div>
            </div>
            <div class="summary-item">
                <div class="summary-label">Total Amount Applied</div>
                <div class="summary-value">KSh {{ number_format($loans->sum('amount'), 2) }}</div>
            </div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Application Date</th>
                <th>Loan Amount</th>
                <th>Term</th>
                <th>Interest Rate</th>
                <th>Monthly Payment</th>
                <th>Total Amount</th>
                <th>Status</th>
                <th>Return Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($loans as $loan)
            <tr>
                <td>{{ $loan->application_date ? $loan->application_date->format('M d, Y') : 'N/A' }}</td>
                <td class="amount">KSh {{ number_format($loan->amount, 2) }}</td>
                <td>{{ $loan->term_months }} months</td>
                <td>{{ $loan->interest_rate }}%</td>
                <td>KSh {{ number_format($loan->monthly_payment, 2) }}</td>
                <td>KSh {{ number_format($loan->total_amount, 2) }}</td>
                <td>
                    <span class="status-{{ $loan->status }}">
                        {{ ucfirst($loan->status) }}
                    </span>
                </td>
                <td>{{ $loan->return_date ? $loan->return_date->format('M d, Y') : 'N/A' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>This report contains confidential information about your loan applications with Morio Sacco.</p>
        <p>For any questions or concerns, please contact our support team.</p>
        <p>Report generated by Morio Sacco Management System</p>
    </div>
</body>
</html>
