<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Welcome to Morio Sacco</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #247f1b; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; background-color: #f9f9f9; }
        .credentials { background-color: white; padding: 15px; border-left: 4px solid #247f1b; margin: 20px 0; }
        .footer { background-color: #333; color: white; padding: 10px; text-align: center; font-size: 12px; }
        .btn { display: inline-block; padding: 10px 20px; background-color: #247f1b; color: white; text-decoration: none; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Welcome to Morio Sacco</h1>
            <p>Your membership has been successfully registered!</p>
        </div>

        <div class="content">
            <h2>Dear {{ $user->full_name }},</h2>

            <p>Congratulations! Your membership with Morio Sacco has been successfully registered. You can now access your account using the login credentials below:</p>

            <div class="credentials">
                <h3>Your Login Credentials</h3>
                <p><strong>Email:</strong> {{ $user->email }}</p>
                <p><strong>Password:</strong> {{ $password }}</p>
                <p><strong>Role:</strong> {{ ucfirst($user->role) }}</p>
            </div>

            <p><strong>Important:</strong> Please change your password after your first login for security purposes.</p>

            <p>You can access your account at: <a href="{{ url('/login') }}" class="btn">Login to Your Account</a></p>

            <h3>What you can do with your account:</h3>
            <ul>
                <li>View your membership details</li>
                <li>Apply for loans</li>
                <li>Make savings deposits</li>
                <li>View your transaction history</li>
                <li>Access reports and statements</li>
            </ul>

            <p>If you have any questions or need assistance, please contact our support team.</p>

            <p>Best regards,<br>
            Morio Sacco Management Team</p>
        </div>

        <div class="footer">
            <p>&copy; {{ date('Y') }} Morio Sacco. All rights reserved.</p>
            <p>This is an automated message. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
