<div class="container-fluid">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-primary" style="background: linear-gradient(45deg, #247f1b, #17a2b8); border: none; color: white;">
                <h4><i class="fas fa-user"></i> Welcome to Your Dashboard, {{ auth()->user()->full_name }}!</h4>
                <p class="mb-0">Manage your Sacco account, view your finances, and access member services.</p>
            </div>
        </div>
    </div>

    <!-- Account Overview -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>KES {{ number_format($stats['savings'], 0) }}</h3>
                    <p>Total Savings</p>
                </div>
                <div class="icon">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <a href="{{ route('savings.index') }}" class="small-box-footer">
                    View Details <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>KES {{ number_format($stats['shares'], 0) }}</h3>
                    <p>Share Capital</p>
                </div>
                <div class="icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <a href="{{ route('shares.index') }}" class="small-box-footer">
                    View Shares <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $stats['loans']->count() }}</h3>
                    <p>Active Loans</p>
                </div>
                <div class="icon">
                    <i class="fas fa-hand-holding-usd"></i>
                </div>
                <a href="{{ route('loans.index') }}" class="small-box-footer">
                    View Loans <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>KES {{ number_format($stats['dividends'], 0) }}</h3>
                    <p>Dividends Earned</p>
                </div>
                <div class="icon">
                    <i class="fas fa-gift"></i>
                </div>
                <a href="{{ route('dividends.index') }}" class="small-box-footer">
                    View Dividends <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Activity and Quick Actions -->
    <div class="row">
        <!-- Recent Transactions -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Transactions</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stats['recent_transactions'] as $transaction)
                                <tr>
                                    <td>
                                        <span class="badge badge-{{ $transaction->type == 'loan_repayment' ? 'warning' : ($transaction->type == 'savings_deposit' ? 'success' : 'info') }}">
                                            {{ ucfirst(str_replace('_', ' ', $transaction->type)) }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong>KES {{ number_format($transaction->amount, 2) }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $transaction->status == 'completed' ? 'success' : ($transaction->status == 'pending' ? 'warning' : 'danger') }}">
                                            {{ ucfirst($transaction->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $transaction->created_at->format('M d, Y H:i') }}</td>
                                    <td>
                                        <a href="{{ route('transactions.show', $transaction) }}" class="btn btn-sm btn-info">View</a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">No recent transactions</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <a href="{{ route('transactions.index') }}" class="btn btn-sm btn-primary">View All Transactions</a>
                </div>
            </div>

            <!-- Recent Loans -->
            @if($stats['loans']->count() > 0)
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Your Recent Loans</h3>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Loan ID</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Applied Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stats['loans'] as $loan)
                                <tr>
                                    <td>#{{ $loan->id }}</td>
                                    <td>KES {{ number_format($loan->amount, 2) }}</td>
                                    <td>
                                        <span class="badge badge-{{ $loan->status == 'active' ? 'success' : ($loan->status == 'approved' ? 'info' : 'warning') }}">
                                            {{ ucfirst($loan->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $loan->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <a href="{{ route('loans.show', $loan) }}" class="btn btn-sm btn-info">View</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Member Actions and Info -->
        <div class="col-md-4">
            <!-- Membership Status -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Membership Status</h3>
                </div>
                <div class="card-body">
                    @if($stats['membership'])
                    <div class="text-center">
                        <div class="mb-3">
                            <span class="badge badge-{{ $stats['membership']->status == 'active' ? 'success' : 'warning' }} badge-lg">
                                {{ ucfirst($stats['membership']->status) }} Member
                            </span>
                        </div>
                        <p><strong>Member Since:</strong><br>{{ $stats['membership']->created_at->format('F Y') }}</p>
                        <p><strong>Member ID:</strong><br>{{ $stats['membership']->user->id_number ?? 'N/A' }}</p>
                    </div>
                    @else
                    <div class="text-center text-muted">
                        <i class="fas fa-user-times fa-2x mb-2"></i>
                        <p>Membership information not available</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Quick Actions</h3>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('loans.create') }}" class="btn btn-warning">
                            <i class="fas fa-hand-holding-usd"></i> Apply for Loan
                        </a>
                        <a href="{{ route('savings.create') }}" class="btn btn-success">
                            <i class="fas fa-plus"></i> Make Deposit
                        </a>
                        <a href="{{ route('transactions.create') }}" class="btn btn-info">
                            <i class="fas fa-exchange-alt"></i> Transfer Funds
                        </a>
                        <a href="{{ route('users.show', auth()->id()) }}" class="btn btn-secondary">
                            <i class="fas fa-user-edit"></i> Update Profile
                        </a>
                    </div>
                </div>
            </div>

            <!-- Account Summary -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Account Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 border-right">
                            <h5 class="text-success">{{ $stats['loans']->where('status', 'active')->count() }}</h5>
                            <small class="text-muted">Active Loans</small>
                        </div>
                        <div class="col-6">
                            <h5 class="text-info">{{ $stats['recent_transactions']->count() }}</h5>
                            <small class="text-muted">This Month</small>
                        </div>
                    </div>
                    <hr>
                    <div class="text-center">
                        <h6 class="text-primary">Total Portfolio Value</h6>
                        <h4 class="text-success">
                            KES {{ number_format($stats['savings'] + $stats['shares'] + $stats['dividends'], 0) }}
                        </h4>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Member Services -->
    <div class="row mt-3">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Member Services</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-file-invoice-dollar fa-2x text-primary mb-2"></i>
                                <br><small>Loan Statement</small>
                            </a>
                        </div>
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-id-card fa-2x text-success mb-2"></i>
                                <br><small>ID Card</small>
                            </a>
                        </div>
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-envelope fa-2x text-info mb-2"></i>
                                <br><small>Contact Support</small>
                            </a>
                        </div>
                        <div class="col-md-3 text-center">
                            <a href="#" class="text-decoration-none">
                                <i class="fas fa-question-circle fa-2x text-warning mb-2"></i>
                                <br><small>Help & FAQ</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
