@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content')
<div class="container-fluid" style="min-height: calc(100vh - 200px);">

<!-- Welcome Section -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <div class="avatar-circle mr-3">
                            <i class="fas fa-user"></i>
                        </div>
                        <div>
                            <h4 class="mb-1">Welcome back, {{ auth()->user()->full_name }}</h4>
                            <p class="text-muted mb-0">Morio Sacco Management Dashboard</p>
                        </div>
                    </div>
                    <div class="d-flex">
                        <div class="stat-item mr-4">
                            <div class="stat-value">{{ now()->format('M d, Y') }}</div>
                            <div class="stat-label">Today's Date</div>
                        </div>
                        <div class="stat-item mr-4">
                            <div class="stat-value">{{ now()->format('H:i') }}</div>
                            <div class="stat-label">Current Time</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">{{ $stats['system_health']['system_uptime'] }}</div>
                            <div class="stat-label">System Status</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<!-- Row 1: Core Business KPIs -->
<div class="row mb-3">
    <!-- Total Members -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Members
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ number_format($stats['total_members']) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-plus mr-1"></i>
                            +{{ $stats['new_members_this_month'] }} this month
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Loans -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Active Loans
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ number_format($stats['active_loans']) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-hand-holding-usd mr-1"></i>
                            KSh {{ number_format($stats['total_loan_amount'], 0) }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-hand-holding-usd"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Savings -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Savings
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            KSh {{ number_format($stats['total_savings_balance'], 0) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-piggy-bank mr-1"></i>
                            {{ $stats['active_savings_accounts'] }} accounts
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-piggy-bank"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Monthly Revenue -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Monthly Revenue
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ \App\Helpers\CurrencyHelper::formatAmount($stats['monthly_revenue']) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-chart-line mr-1"></i>
                            {{ $stats['completed_transactions'] }} transactions
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Row 2: Performance Leaders -->
<div class="row mb-3">
    <!-- Top Borrower -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Top Borrower
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ Str::limit($stats['top_borrower']['name'], 15) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-money-bill-wave mr-1"></i>
                            KSh {{ number_format($stats['top_borrower']['amount'], 0) }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-trophy"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Saver -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-dark shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">
                            Top Saver
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ Str::limit($stats['top_saver']['name'], 15) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-star mr-1"></i>
                            KSh {{ number_format($stats['top_saver']['amount'], 0) }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-dark text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-medal"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Shareholder -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-secondary shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Top Shareholder
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ Str::limit($stats['top_shareholder']['name'], 15) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-share-alt mr-1"></i>
                            KSh {{ number_format($stats['top_shareholder']['amount'], 0) }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-crown"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Defaulter -->
    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mb-2">
        <div class="card border-left-dark shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">
                            Top Defaulter
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ Str::limit($stats['top_defaulter']['name'], 15) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-user-times mr-1"></i>
                            KSh {{ number_format($stats['top_defaulter']['amount'], 0) }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-dark text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-user-times"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Row 3: Risk & Financial Health -->
<div class="row mb-3">
    <!-- Defaulted Loans -->
    <div class="col-xl-4 col-lg-4 col-md-6 col-12 mb-2">
        <div class="card border-left-danger shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Defaulted Loans
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ number_format($stats['defaulted_loans']['count']) }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            KSh {{ number_format($stats['defaulted_loans']['amount'], 0) }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Health -->
    <div class="col-xl-4 col-lg-4 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            System Health
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $stats['system_health']['system_uptime'] }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-server mr-1"></i>
                            {{ $stats['system_health']['last_backup'] }}
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-server"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Transaction Success Rate -->
    <div class="col-xl-4 col-lg-4 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-dashboard-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Success Rate
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $stats['system_health']['transaction_success_rate'] }}%
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-check-circle mr-1"></i>
                            Transaction success
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity Section -->
    <div class="activity-section">
        <div class="activity-card">
            <div class="card-header">
                <h4>Recent Activity</h4>
                <span class="activity-count">{{ $stats['recent_activities']->count() }}</span>
            </div>
            <div class="card-body">
                <div id="activity-feed" class="activity-list">
                    @forelse($stats['recent_activities'] as $activity)
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="{{ $activity['icon'] }}"></i>
                        </div>
                        <div class="activity-content">
                            <div class="activity-title">{{ $activity['action'] }}</div>
                            <div class="activity-details">{{ $activity['details'] }}</div>
                            <div class="activity-time">{{ $activity['timestamp']->diffForHumans() }}</div>
                        </div>
                        @if($activity['amount'] > 0)
                        <div class="activity-amount">
                            KSh {{ number_format($activity['amount'], 0) }}
                        </div>
                        @endif
                    </div>
                    @empty
                    <div class="no-activity">
                        <i class="fas fa-inbox"></i>
                        <p>No recent activity</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

</div>

@stop

<!-- Minimal Light Theme CSS -->
<style>
/* Dashboard Styles */
.avatar-circle {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);
    flex-shrink: 0;
}

.stat-item {
    text-align: center;
    padding: 0.5rem;
}

.stat-value {
    font-size: 1rem;
    font-weight: 600;
    color: #2d3748;
    display: block;
}

.stat-label {
    font-size: 0.8rem;
    color: #718096;
    margin-top: 0.25rem;
}

/* Compact Dashboard Card Styling - Matching Loans Page */
.compact-dashboard-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-dashboard-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-dashboard-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-dashboard-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

/* Border colors matching loans page */
.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* KPI Overview */
.kpi-overview {
    padding: 2rem;
}

.kpi-grid {
    max-width: 1200px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
}

.kpi-card {
    background: #ffffff;
    border-radius: 12px;
    padding: 1.5rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.06);
    border: 1px solid #e2e8f0;
    transition: all 0.2s ease;
}

.kpi-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0,0,0,0.1);
}

.card-icon {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1rem;
}

.kpi-card:nth-child(1) .card-icon { background: linear-gradient(135deg, #667eea, #764ba2); color: white; }
.kpi-card:nth-child(2) .card-icon { background: linear-gradient(135deg, #f093fb, #f5576c); color: white; }
.kpi-card:nth-child(3) .card-icon { background: linear-gradient(135deg, #4facfe, #00f2fe); color: white; }
.kpi-card:nth-child(4) .card-icon { background: linear-gradient(135deg, #43e97b, #38f9d7); color: white; }

.card-content h3 {
    font-size: 2rem;
    font-weight: 700;
    margin: 0 0 0.5rem 0;
    color: #2d3748;
}

.card-content p {
    font-size: 0.9rem;
    color: #718096;
    margin: 0 0 0.75rem 0;
    font-weight: 500;
}

.trend {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.85rem;
}

.trend-up {
    color: #38a169;
    font-weight: 600;
}

.trend small {
    color: #a0aec0;
}

/* Analytics Section */
.analytics-section {
    padding: 0 2rem 2rem 2rem;
}

.section-header {
    max-width: 1200px;
    margin: 0 auto 2rem auto;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.section-header h3 {
    font-size: 1.5rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
}

.btn-refresh {
    background: #667eea;
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.9rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-refresh:hover {
    background: #5a67d8;
    transform: translateY(-1px);
}

.analytics-grid {
    max-width: 1200px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
}

.charts-grid {
    max-width: 1200px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
    gap: 1.5rem;
}

.chart-card {
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.06);
    border: 1px solid #e2e8f0;
    overflow: hidden;
}

.chart-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e2e8f0;
    background: #f8f9fa;
}

.chart-header h5 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
}

.chart-container {
    padding: 1.5rem;
}

.system-health {
    padding: 1rem 0;
}

.health-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1.5rem;
    padding: 0 1.5rem;
}

.health-item:last-child {
    margin-bottom: 0;
}

.health-label {
    font-weight: 500;
    color: #4a5568;
    flex: 1;
}

.health-bar {
    flex: 2;
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    margin: 0 1rem;
    overflow: hidden;
}

.health-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea, #764ba2);
    border-radius: 4px;
    transition: width 0.3s ease;
}

.health-value {
    font-weight: 600;
    color: #2d3748;
    min-width: 3rem;
    text-align: right;
}

/* Activity & Actions Section */
.activity-actions-section {
    padding: 0 2rem 2rem 2rem;
}

.section-grid {
    max-width: 1200px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
}

.activity-card, .actions-card {
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.06);
    border: 1px solid #e2e8f0;
}

.card-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e2e8f0;
    background: #f8f9fa;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-header h4 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
}

.activity-count {
    background: #667eea;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}

.card-body {
    padding: 1.5rem;
}

.activity-list {
    max-height: 400px;
    overflow-y: auto;
}

.activity-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 0;
    border-bottom: 1px solid #f1f5f9;
}

.activity-item:last-child {
    border-bottom: none;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: #f1f5f9;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #667eea;
    flex-shrink: 0;
}

.activity-content {
    flex: 1;
}

.activity-title {
    font-weight: 500;
    color: #2d3748;
    margin: 0 0 0.25rem 0;
    font-size: 0.9rem;
}

.activity-details {
    color: #718096;
    font-size: 0.85rem;
    margin: 0 0 0.25rem 0;
}

.activity-time {
    color: #a0aec0;
    font-size: 0.8rem;
    margin: 0;
}

.activity-amount {
    font-weight: 600;
    color: #38a169;
    font-size: 0.9rem;
}

.no-activity {
    text-align: center;
    padding: 2rem;
    color: #a0aec0;
}

.no-activity i {
    font-size: 2rem;
    margin-bottom: 0.5rem;
    display: block;
}

.quick-actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
}

.quick-action-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.25rem;
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    text-decoration: none;
    color: #4a5568;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0,0,0,0.06);
    position: relative;
    overflow: hidden;
}

.quick-action-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #667eea, #764ba2);
    transform: scaleX(0);
    transition: transform 0.3s ease;
}

.quick-action-card:hover::before {
    transform: scaleX(1);
}

.quick-action-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    color: #2d3748;
}

.quick-action-card.primary-action {
    border-left: 4px solid #4e73df;
}

.quick-action-card.primary-action:hover {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    color: white;
}

.quick-action-card.success-action {
    border-left: 4px solid #1cc88a;
}

.quick-action-card.success-action:hover {
    background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    color: white;
}

.quick-action-card.info-action {
    border-left: 4px solid #36b9cc;
}

.quick-action-card.info-action:hover {
    background: linear-gradient(135deg, #36b9cc 0%, #2a8a9e 100%);
    color: white;
}

.quick-action-card.warning-action {
    border-left: 4px solid #f6c23e;
}

.quick-action-card.warning-action:hover {
    background: linear-gradient(135deg, #f6c23e 0%, #d4a017 100%);
    color: white;
}

.quick-action-card.secondary-action {
    border-left: 4px solid #6c757d;
}

.quick-action-card.secondary-action:hover {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: white;
}

.quick-action-card.dark-action {
    border-left: 4px solid #343a40;
}

.quick-action-card.dark-action:hover {
    background: linear-gradient(135deg, #343a40 0%, #1d2124 100%);
    color: white;
}

.action-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    flex-shrink: 0;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    transition: all 0.3s ease;
}

.quick-action-card:hover .action-icon {
    transform: scale(1.1);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
}

.primary-action .action-icon { background: linear-gradient(135deg, #4e73df, #224abe); }
.success-action .action-icon { background: linear-gradient(135deg, #1cc88a, #13855c); }
.info-action .action-icon { background: linear-gradient(135deg, #36b9cc, #2a8a9e); }
.warning-action .action-icon { background: linear-gradient(135deg, #f6c23e, #d4a017); }
.secondary-action .action-icon { background: linear-gradient(135deg, #6c757d, #495057); }
.dark-action .action-icon { background: linear-gradient(135deg, #343a40, #1d2124); }

.action-content {
    flex: 1;
    min-width: 0;
}

.action-content h6 {
    margin: 0 0 0.25rem 0;
    font-size: 1rem;
    font-weight: 600;
    color: inherit;
}

.action-content p {
    margin: 0;
    font-size: 0.85rem;
    color: #718096;
    line-height: 1.4;
}

.quick-action-card:hover .action-content p {
    color: rgba(255, 255, 255, 0.8);
}

.action-arrow {
    color: #cbd5e0;
    font-size: 0.9rem;
    transition: all 0.3s ease;
    opacity: 0.6;
}

.quick-action-card:hover .action-arrow {
    color: rgba(255, 255, 255, 0.9);
    transform: translateX(3px);
    opacity: 1;
}

/* Dashboard specific styles */
.kpi-overview, .analytics-section, .activity-actions-section {
    margin-bottom: 2rem;
}

/* Page Layout Fixes */
html, body {
    height: 100%;
    overflow-x: hidden;
}

.content-wrapper {
    min-height: calc(100vh - 60px) !important;
}

/* Responsive Design */
@media (max-width: 768px) {
    .header-content {
        flex-direction: column;
        gap: 1.5rem;
        text-align: center;
    }

    .header-stats {
        justify-content: center;
    }

    .kpi-grid {
        grid-template-columns: 1fr;
    }

    .analytics-grid {
        grid-template-columns: 1fr;
    }

    .charts-grid {
        grid-template-columns: 1fr;
    }

    .section-grid {
        grid-template-columns: 1fr;
    }

    .action-buttons {
        grid-template-columns: 1fr;
    }

    .welcome-text h1 {
        font-size: 1.5rem;
    }
}
</style>


@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
</div>
