@extends('adminlte::page')

@section('title', 'User Profile')

@section('content')
<div class="container-fluid">
    <!-- Header with Actions -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0">{{ $user->full_name }}</h1>
            <p class="text-muted">{{ $user->email }}</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('users.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
            @if(!$user->email_verified_at)
            <form action="{{ route('users.verify', $user) }}" method="POST" class="d-inline">
                @csrf
                @method('PATCH')
                <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to verify this user? This will update all related records.')">
                    <i class="fas fa-check-circle"></i> Verify User
                </button>
            </form>
            @endif
            <a href="{{ route('users.edit', $user) }}" class="btn btn-primary">
                <i class="fas fa-edit"></i> Edit
            </a>
        </div>
    </div>

    <!-- User Information Card -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Avatar and Basic Info -->
                        <div class="col-md-4 text-center">
                            <div class="avatar-circle bg-primary text-white mx-auto mb-3" style="width: 80px; height: 80px; font-size: 32px; display: flex; align-items: center; justify-content: center;">
                                {{ strtoupper(substr($user->first_name, 0, 1)) }}
                            </div>
                            <span class="badge badge-{{ $user->role == 'admin' ? 'danger' : ($user->role == 'manager' ? 'warning' : 'success') }} mb-2">
                                {{ ucfirst($user->role) }}
                            </span>
                            @if($user->email_verified_at)
                                <div><small class="text-success"><i class="fas fa-check-circle"></i> Verified</small></div>
                            @else
                                <div><small class="text-warning"><i class="fas fa-exclamation-triangle"></i> Unverified</small></div>
                            @endif
                        </div>

                        <!-- Details -->
                        <div class="col-md-8">
                            <dl class="row">
                                <dt class="col-sm-4">Full Name:</dt>
                                <dd class="col-sm-8">{{ $user->full_name }}</dd>

                                <dt class="col-sm-4">First Name:</dt>
                                <dd class="col-sm-8">{{ $user->first_name }}</dd>

                                <dt class="col-sm-4">Second Name:</dt>
                                <dd class="col-sm-8">{{ $user->second_name }}</dd>

                                <dt class="col-sm-4">ID Number:</dt>
                                <dd class="col-sm-8">{{ $user->id_number }}</dd>

                                <dt class="col-sm-4">Email:</dt>
                                <dd class="col-sm-8">
                                    <a href="mailto:{{ $user->email }}">{{ $user->email }}</a>
                                </dd>

                                <dt class="col-sm-4">Phone:</dt>
                                <dd class="col-sm-8">
                                    <a href="tel:{{ $user->phone_number }}">{{ $user->phone_number }}</a>
                                </dd>

                                <dt class="col-sm-4">Branch:</dt>
                                <dd class="col-sm-8">
                                    @if($user->branch)
                                        {{ $user->branch->name }}
                                    @else
                                        <span class="text-muted">Not assigned</span>
                                    @endif
                                </dd>

                                <dt class="col-sm-4">Member Since:</dt>
                                <dd class="col-sm-8">{{ $user->created_at->format('M d, Y') }}</dd>

                                <dt class="col-sm-4">Last Updated:</dt>
                                <dd class="col-sm-8">{{ $user->updated_at->format('M d, Y') }}</dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats Sidebar -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title">Quick Stats</h6>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Role:</span>
                        <strong>{{ ucfirst($user->role) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Status:</span>
                        <span class="badge badge-{{ $user->email_verified_at ? 'success' : 'warning' }}">
                            {{ $user->email_verified_at ? 'Verified' : 'Unverified' }}
                        </span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Joined:</span>
                        <small>{{ $user->created_at->diffForHumans() }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

