@extends('adminlte::page')

@section('title', 'Transaction Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        Transaction #{{ $transaction->id }}
                        <span class="badge badge-{{ $transaction->status_color }} ml-2">{{ ucfirst($transaction->status) }}</span>
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('transactions.edit', $transaction) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('transactions.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <dl class="row">
                                <dt class="col-sm-5">Reference Number:</dt>
                                <dd class="col-sm-7"><code>{{ $transaction->reference_number }}</code></dd>

                                <dt class="col-sm-5">Transaction Type:</dt>
                                <dd class="col-sm-7">
                                    <span class="badge badge-{{ $transaction->type_color }}">
                                        {{ $transaction->type_label }}
                                    </span>
                                </dd>

                                <dt class="col-sm-5">Member:</dt>
                                <dd class="col-sm-7">{{ $transaction->user->full_name ?? 'N/A' }}</dd>

                                <dt class="col-sm-5">ID Number:</dt>
                                <dd class="col-sm-7">{{ $transaction->user->id_number ?? 'N/A' }}</dd>

                                <dt class="col-sm-5">Payment Method:</dt>
                                <dd class="col-sm-7">{{ $transaction->payment_method ?? 'N/A' }}</dd>
                            </dl>
                        </div>
                        <div class="col-md-6">
                            <dl class="row">
                                <dt class="col-sm-5">Date & Time:</dt>
                                <dd class="col-sm-7">{{ $transaction->created_at->format('d M Y H:i:s') }}</dd>

                                @if($transaction->processed_at)
                                <dt class="col-sm-5">Processed At:</dt>
                                <dd class="col-sm-7">{{ $transaction->processed_at->format('d M Y H:i:s') }}</dd>
                                @endif

                                <dt class="col-sm-5">M-Pesa ID:</dt>
                                <dd class="col-sm-7">{{ $transaction->mpesa_transaction_id ?? 'N/A' }}</dd>

                                @if($transaction->mpesa_phone_number)
                                <dt class="col-sm-5">M-Pesa Phone:</dt>
                                <dd class="col-sm-7">{{ $transaction->mpesa_phone_number }}</dd>
                                @endif

                                @if($transaction->fromUser)
                                <dt class="col-sm-5">From Member:</dt>
                                <dd class="col-sm-7">{{ $transaction->fromUser->full_name }}</dd>
                                @endif

                                @if($transaction->toUser)
                                <dt class="col-sm-5">To Member:</dt>
                                <dd class="col-sm-7">{{ $transaction->toUser->full_name }}</dd>
                                @endif
                            </dl>
                        </div>
                    </div>

                    <hr>

                    <!-- Amount Breakdown -->
                    <div class="row">
                        <div class="col-md-12">
                            <h4>Amount Breakdown</h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box bg-light">
                                <div class="info-box-content">
                                    <span class="info-box-text">Principal Amount</span>
                                    <span class="info-box-number">{{ $transaction->currency }} {{ number_format($transaction->amount, 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <div class="info-box-content">
                                    <span class="info-box-text">Fee Amount</span>
                                    <span class="info-box-number">{{ $transaction->currency }} {{ number_format($transaction->fee_amount, 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-danger">
                                <div class="info-box-content">
                                    <span class="info-box-text">Tax Amount</span>
                                    <span class="info-box-number">{{ $transaction->currency }} {{ number_format($transaction->tax_amount, 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Amount</span>
                                    <span class="info-box-number">{{ $transaction->currency }} {{ number_format($transaction->total_amount, 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction Details -->
                    @if($transaction->description || $transaction->notes)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <h4>Transaction Details</h4>
                        </div>
                    </div>

                    @if($transaction->description)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Description:</label>
                                <div class="border rounded p-3 bg-light">
                                    {{ $transaction->description }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($transaction->notes)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Internal Notes:</label>
                                <div class="border rounded p-3 bg-warning">
                                    {{ $transaction->notes }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    @endif

                    <!-- M-Pesa Response Data -->
                    @if($transaction->mpesa_response)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h5 class="card-title">M-Pesa Response Data</h5>
                                </div>
                                <div class="card-body">
                                    <pre class="bg-dark text-light p-3 rounded"><code>{{ json_encode($transaction->mpesa_response, JSON_PRETTY_PRINT) }}</code></pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Metadata -->
                    @if($transaction->metadata)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card card-outline card-secondary">
                                <div class="card-header">
                                    <h5 class="card-title">Additional Metadata</h5>
                                </div>
                                <div class="card-body">
                                    <pre class="bg-secondary text-light p-3 rounded"><code>{{ json_encode($transaction->metadata, JSON_PRETTY_PRINT) }}</code></pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Quick Actions</h3>
                </div>
                <div class="card-body">
                    <a href="{{ route('transactions.edit', $transaction) }}" class="btn btn-warning btn-block mb-2">
                        <i class="fas fa-edit"></i> Edit Transaction
                    </a>

                    <form action="{{ route('transactions.destroy', $transaction) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this transaction? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-block">
                            <i class="fas fa-trash"></i> Delete Transaction
                        </button>
                    </form>
                </div>
            </div>

            <!-- Transaction Status -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Transaction Status</h3>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <span class="badge badge-{{ $transaction->status_color }} badge-lg" style="font-size: 16px; padding: 10px 20px;">
                            {{ ucfirst($transaction->status) }}
                        </span>
                    </div>

                    @if($transaction->status === 'pending')
                    <div class="mt-3">
                        <form action="{{ route('transactions.update', $transaction) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="completed">
                            <button type="submit" class="btn btn-success btn-block" onclick="return confirm('Mark this transaction as completed?')">
                                <i class="fas fa-check"></i> Mark as Completed
                            </button>
                        </form>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Transaction Summary Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Summary</h3>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-12">
                            <h4 class="text-primary mb-0">{{ $transaction->formatted_amount }}</h4>
                            <small class="text-muted">Transaction Amount</small>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-6 text-center">
                            <div class="text-warning">
                                <strong>{{ $transaction->currency }} {{ number_format($transaction->fee_amount, 2) }}</strong><br>
                                <small>Fees</small>
                            </div>
                        </div>
                        <div class="col-6 text-center">
                            <div class="text-danger">
                                <strong>{{ $transaction->currency }} {{ number_format($transaction->tax_amount, 2) }}</strong><br>
                                <small>Tax</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

