<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Transaction Report - {{ date('Y-m-d') }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #247f1b;
            padding-bottom: 10px;
        }

        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }

        .header h2 {
            color: #247f1b;
            margin: 5px 0;
            font-size: 14px;
        }

        .header p {
            margin: 2px 0;
            color: #666;
        }

        .filters {
            margin-bottom: 20px;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 4px;
        }

        .filters h3 {
            margin: 0 0 10px 0;
            font-size: 12px;
            color: #247f1b;
        }

        .filters p {
            margin: 2px 0;
            font-size: 9px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 8px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            text-align: center;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .amount {
            text-align: right;
            font-weight: bold;
        }

        .status {
            text-align: center;
        }

        .badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 7px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .badge-success { background-color: #28a745; color: white; }
        .badge-warning { background-color: #ffc107; color: black; }
        .badge-danger { background-color: #dc3545; color: white; }
        .badge-info { background-color: #17a2b8; color: white; }
        .badge-primary { background-color: #247f1b; color: white; }
        .badge-secondary { background-color: #6c757d; color: white; }

        .summary {
            margin-top: 20px;
            padding: 15px;
            background: #247f1b;
            color: white;
            border-radius: 4px;
        }

        .summary h3 {
            margin: 0 0 10px 0;
            font-size: 14px;
            text-align: center;
        }

        .summary-grid {
            display: table;
            width: 100%;
        }

        .summary-item {
            display: table-cell;
            width: 20%;
            text-align: center;
            padding: 5px;
        }

        .summary-value {
            font-size: 12px;
            font-weight: bold;
        }

        .summary-label {
            font-size: 8px;
            opacity: 0.9;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 15px;
            font-size: 8px;
            color: #666;
        }

        .page-break {
            page-break-before: always;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            color: #666;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <h2>Transaction Report</h2>
        <p>Generated on {{ date('l, F j, Y \a\t g:i A') }}</p>
    </div>

    @if(request()->hasAny(['type', 'status', 'user_id', 'date_from', 'date_to']))
    <div class="filters">
        <h3>Applied Filters:</h3>
        @if(request('type')) <p><strong>Type:</strong> {{ $transactionTypes[request('type')] ?? request('type') }}</p> @endif
        @if(request('status')) <p><strong>Status:</strong> {{ ucfirst(request('status')) }}</p> @endif
        @if(request('user_id'))
            @php $user = \App\Models\User::find(request('user_id')) @endphp
            <p><strong>Member:</strong> {{ $user ? $user->full_name : 'N/A' }}</p>
        @endif
        @if(request('date_from') || request('date_to'))
            <p><strong>Date Range:</strong> {{ request('date_from') ?: 'Start' }} to {{ request('date_to') ?: 'End' }}</p>
        @endif
    </div>
    @endif

    @if($transactions->count() > 0)
    <table>
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 10%;">Reference</th>
                <th style="width: 8%;">Date</th>
                <th style="width: 12%;">Type</th>
                <th style="width: 15%;">Member</th>
                <th style="width: 10%;">Amount</th>
                <th style="width: 8%;">Status</th>
                <th style="width: 10%;">Payment Method</th>
                <th style="width: 12%;">M-Pesa ID</th>
                <th style="width: 10%;">Processed</th>
            </tr>
        </thead>
        <tbody>
            @foreach($transactions as $transaction)
            <tr>
                <td style="text-align: center;">{{ $loop->iteration }}</td>
                <td><code>{{ $transaction->reference_number }}</code></td>
                <td>{{ $transaction->created_at->format('d M Y') }}</td>
                <td>{{ $transaction->type_label }}</td>
                <td>{{ $transaction->user->full_name ?? 'N/A' }}</td>
                <td class="amount">{{ $transaction->formatted_amount }}</td>
                <td class="status">
                    <span class="badge badge-{{ $transaction->status_color }}">
                        {{ ucfirst($transaction->status) }}
                    </span>
                </td>
                <td>{{ $transaction->payment_method ?? '-' }}</td>
                <td>{{ $transaction->mpesa_transaction_id ?? '-' }}</td>
                <td>{{ $transaction->processed_at ? $transaction->processed_at->format('d M Y') : '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Summary Section -->
    <div class="summary">
        <h3>Transaction Summary</h3>
        <div class="summary-grid">
            <div class="summary-item">
                <div class="summary-value">{{ $transactions->count() }}</div>
                <div class="summary-label">Total Transactions</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">{{ $transactions->where('status', 'completed')->count() }}</div>
                <div class="summary-label">Completed</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KSh {{ number_format($transactions->sum('amount'), 2) }}</div>
                <div class="summary-label">Total Amount</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KSh {{ number_format($transactions->sum('fee_amount'), 2) }}</div>
                <div class="summary-label">Total Fees</div>
            </div>
            <div class="summary-item">
                <div class="summary-value">KSh {{ number_format($transactions->sum('total_amount'), 2) }}</div>
                <div class="summary-label">Net Total</div>
            </div>
        </div>
    </div>
    @else
    <div class="no-data">
        <h3>No Transactions Found</h3>
        <p>No transactions match the specified criteria.</p>
    </div>
    @endif

    <div class="footer">
        <p><strong>{{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }} Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> {{ \App\Models\SystemSetting::get('contact_phone', '+254 700 000 000') }} |
            <i class="fas fa-envelope"></i> {{ \App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke') }} |
            <i class="fas fa-map-marker-alt"></i> {{ \App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya') }}
        </p>
        <p>
            <i class="fas fa-globe"></i> {{ \App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke') }} |
            Report generated on {{ now()->format('l, F j, Y \a\t g:i A') }} | Page 1 of 1 | Confidential Document
        </p>
        <p>This is an official report. Please keep for your records.</p>
    </div>
</body>
</html>

