@extends('adminlte::page')

@section('title', 'System Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">System Configuration</h3>
                </div>
                <div class="card-body">
                    @php
                        $currentCategory = null;
                    @endphp
                    @foreach($configurations as $config)
                        @if($currentCategory !== $config->category)
                            @if($currentCategory !== null)
                                </div>
                            @endif
                            <div class="mb-4">
                                <h4 class="text-primary">{{ ucfirst($config->category) }} Settings</h4>
                                <hr>
                            </div>
                            @php
                                $currentCategory = $config->category;
                            @endphp
                        @endif
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <form action="{{ route('system-configurations.update', $config->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')

                                    <div class="form-group">
                                        <label for="config_{{ $config->id }}">
                                            <strong>{{ ucwords(str_replace('_', ' ', $config->key)) }}</strong>
                                        </label>
                                        @if($config->description)
                                            <small class="form-text text-muted d-block">{{ $config->description }}</small>
                                        @endif

                                        @if($config->key === 'occupation_options')
                                            <textarea name="value" id="config_{{ $config->id }}" class="form-control" rows="6" required>
{{ is_array($config->parsed_value) ? implode("\n", $config->parsed_value) : $config->value }}
                                            </textarea>
                                            <small class="form-text text-muted">Enter each occupation option on a new line</small>
                                        @elseif($config->type === 'boolean')
                                            <select name="value" id="config_{{ $config->id }}" class="form-control" required>
                                                <option value="true" {{ $config->parsed_value ? 'selected' : '' }}>Yes</option>
                                                <option value="false" {{ !$config->parsed_value ? 'selected' : '' }}>No</option>
                                            </select>
                                        @else
                                            <input type="text" name="value" id="config_{{ $config->id }}"
                                                   class="form-control" value="{{ $config->value }}" required>
                                        @endif
                                    </div>

                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <i class="fas fa-save"></i> Update
                                    </button>
                                </form>
                            </div>
                        </div>
                        @if(!$loop->last)
                            <hr>
                        @endif
                    @endforeach
                    @if($currentCategory !== null)
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@stop

