@extends('adminlte::page')

@section('title', 'Transaction Receipt')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="card-title mb-0">
                                <i class="fas fa-receipt"></i> Transaction Receipt
                            </h3>
                            <small>{{ $transaction->transaction_number }}</small>
                        </div>
                        <div class="text-right">
                            <button onclick="window.print()" class="btn btn-light btn-sm">
                                <i class="fas fa-print"></i> Print
                            </button>
                            <a href="{{ route('savings.transaction.print', $transaction) }}" target="_blank" class="btn btn-light btn-sm">
                                <i class="fas fa-download"></i> Download PDF
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body" id="receipt-content">
                    <!-- Receipt Header -->
                    <div class="text-center mb-4">
                        <h2 class="text-primary mb-1">Morio Sacco</h2>
                        <p class="mb-1">Savings Transaction Receipt</p>
                        <hr class="my-3">
                    </div>

                    <!-- Transaction Details -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5 class="text-primary">Transaction Information</h5>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td width="40%"><strong>Transaction #:</strong></td>
                                    <td>{{ $transaction->transaction_number }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Date & Time:</strong></td>
                                    <td>{{ $transaction->transaction_date->format('d M Y H:i:s') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Transaction Type:</strong></td>
                                    <td>
                                        <span class="badge badge-{{ $transaction->type_color }} badge-lg">
                                            {{ $transaction->type_label }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Processed By:</strong></td>
                                    <td>{{ $transaction->processor->name ?? 'System' }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <h5 class="text-primary">Account Information</h5>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td width="40%"><strong>Member Name:</strong></td>
                                    <td>{{ $transaction->account->user->full_name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>ID Number:</strong></td>
                                    <td>{{ $transaction->account->user->id_number }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Account Type:</strong></td>
                                    <td>{{ $transaction->account->type_label }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Account ID:</strong></td>
                                    <td>#{{ $transaction->account->id }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Transaction Amounts -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card border-primary">
                                <div class="card-body text-center">
                                    <h4 class="mb-3">Transaction Summary</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="border rounded p-3">
                                                <h6 class="text-muted">Balance Before</h6>
                                                <h4 class="text-info mb-0">KSh {{ number_format($transaction->balance_before, 2) }}</h4>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border rounded p-3 {{ $transaction->type === 'deposit' ? 'border-success' : 'border-danger' }}">
                                                <h6 class="text-muted">{{ $transaction->type_label }} Amount</h6>
                                                <h4 class="mb-0 {{ $transaction->type === 'deposit' ? 'text-success' : 'text-danger' }}">
                                                    {{ $transaction->formatted_amount }}
                                                </h4>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border rounded p-3 border-primary">
                                                <h6 class="text-muted">Balance After</h6>
                                                <h4 class="text-primary mb-0">KSh {{ number_format($transaction->balance_after, 2) }}</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction Notes -->
                    @if($transaction->notes)
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5 class="text-primary">Transaction Notes</h5>
                            <div class="border rounded p-3 bg-light">
                                {{ $transaction->notes }}
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Receipt Footer -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="border-top pt-3 text-center">
                                <p class="mb-1"><strong>Morio Sacco Management System</strong></p>
                                <p class="mb-1">Transaction processed on {{ $transaction->created_at->format('l, F j, Y \a\t g:i A') }}</p>
                                <p class="text-muted small">This is an official receipt. Please keep for your records.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer text-center">
                    <a href="{{ route('savings.show', $transaction->account) }}" class="btn btn-primary">
                        <i class="fas fa-arrow-left"></i> Back to Account
                    </a>
                    <button onclick="window.print()" class="btn btn-secondary">
                        <i class="fas fa-print"></i> Print Receipt
                    </button>
                    <a href="{{ route('savings.transaction.print', $transaction) }}" target="_blank" class="btn btn-success">
                        <i class="fas fa-download"></i> Download PDF
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@push('css')
<style>
@media print {
    .card-header,
    .card-footer,
    .btn,
    .fas {
        display: none !important;
    }

    .card {
        border: none !important;
        box-shadow: none !important;
    }

    .card-body {
        padding: 0 !important;
    }

    body {
        background: white !important;
    }

    .container-fluid {
        max-width: none !important;
        margin: 0 !important;
        padding: 0 !important;
    }
}
</style>
@endpush

