<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Savings Plan - {{ $saving->user->full_name }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #2d3748;
            margin: 0;
            padding: 15px;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }

        .container {
            max-width: 850px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .header {
            background: linear-gradient(135deg, #247f1b 0%, #2d8a1f 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255,255,255,0.05) 25%, transparent 25%, transparent 75%, rgba(255,255,255,0.05) 75%);
            background-size: 20px 20px;
            opacity: 0.3;
        }

        .header h1 {
            font-size: 32px;
            margin: 0 0 8px 0;
            font-weight: 700;
            letter-spacing: -0.5px;
            position: relative;
            z-index: 1;
        }

        .header h2 {
            font-size: 18px;
            margin: 0 0 15px 0;
            opacity: 0.95;
            font-weight: 500;
            position: relative;
            z-index: 1;
        }

        .header p {
            margin: 0;
            font-size: 13px;
            opacity: 0.9;
            position: relative;
            z-index: 1;
        }

        .section {
            padding: 30px;
            border-bottom: 1px solid #f1f5f9;
        }

        .section:last-child {
            border-bottom: none;
        }

        .section-title {
            font-size: 20px;
            font-weight: 700;
            color: #1a202c;
            margin: 0 0 25px 0;
            padding-bottom: 12px;
            border-bottom: 3px solid #247f1b;
            display: inline-block;
            letter-spacing: -0.3px;
        }

        .member-profile {
            display: flex;
            align-items: center;
            background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
            padding: 25px;
            border-radius: 12px;
            margin-bottom: 30px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .member-avatar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #247f1b;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 32px;
            font-weight: 700;
            margin-right: 20px;
            border: 3px solid white;
            box-shadow: 0 4px 12px rgba(36, 127, 27, 0.2);
        }

        .member-info h3 {
            font-size: 24px;
            font-weight: 700;
            color: #1a202c;
            margin: 0 0 5px 0;
        }

        .member-info p {
            font-size: 14px;
            color: #718096;
            margin: 0;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }

        .info-card {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            padding: 20px;
            border-radius: 12px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
            transition: transform 0.2s ease;
        }

        .info-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
        }

        .info-label {
            font-size: 11px;
            font-weight: 700;
            color: #718096;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            margin-bottom: 8px;
            display: block;
        }

        .info-value {
            font-size: 16px;
            font-weight: 600;
            color: #2d3748;
            margin: 0;
            line-height: 1.4;
        }

        .highlight-card {
            background: linear-gradient(135deg, #247f1b 0%, #2d8a1f 100%);
            color: white;
            border: none;
        }

        .highlight-card .info-label {
            color: rgba(255, 255, 255, 0.8);
        }

        .highlight-card .info-value {
            color: white;
            font-size: 20px;
        }

        .stats-overview {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
            margin: 25px 0;
        }

        .stat-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
        }

        .stat-box.success {
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            box-shadow: 0 6px 20px rgba(72, 187, 120, 0.3);
        }

        .stat-box.warning {
            background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
            box-shadow: 0 6px 20px rgba(237, 137, 54, 0.3);
        }

        .stat-box.info {
            background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
            box-shadow: 0 6px 20px rgba(66, 153, 225, 0.3);
        }

        .stat-value {
            font-size: 28px;
            font-weight: 800;
            margin-bottom: 8px;
            display: block;
            letter-spacing: -0.5px;
        }

        .stat-label {
            font-size: 12px;
            opacity: 0.95;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: 600;
        }

        .table-container {
            margin: 25px 0;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
            border: 1px solid #e2e8f0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
        }

        th {
            background: linear-gradient(135deg, #2d3748 0%, #1a202c 100%);
            color: white;
            padding: 15px 20px;
            text-align: left;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            font-size: 10px;
            border-bottom: 2px solid #4a5568;
        }

        td {
            padding: 15px 20px;
            border-bottom: 1px solid #f1f5f9;
        }

        tr:nth-child(even) {
            background: #f8fafc;
        }

        tr:hover {
            background: #edf2f7;
        }

        .amount-positive {
            color: #48bb78;
            font-weight: 700;
            font-size: 13px;
        }

        .amount-negative {
            color: #f56565;
            font-weight: 700;
            font-size: 13px;
        }

        .status-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 10px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-active {
            background: #c6f6d5;
            color: #22543d;
        }

        .status-withdrawn {
            background: #fed7d7;
            color: #742a2a;
        }

        .status-matured {
            background: #bee3f8;
            color: #2a4365;
        }

        .timeline {
            position: relative;
            padding-left: 40px;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 20px;
            top: 0;
            bottom: 0;
            width: 3px;
            background: linear-gradient(to bottom, #247f1b, #2d8a1f);
            border-radius: 2px;
        }

        .timeline-item {
            position: relative;
            margin-bottom: 30px;
            padding-left: 35px;
        }

        .timeline-item::before {
            content: '';
            position: absolute;
            left: -28px;
            top: 8px;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: #247f1b;
            border: 4px solid white;
            box-shadow: 0 0 0 3px #e2e8f0;
        }

        .timeline-date {
            font-size: 12px;
            color: #718096;
            font-weight: 600;
            margin-bottom: 8px;
            background: #f7fafc;
            padding: 4px 12px;
            border-radius: 20px;
            display: inline-block;
        }

        .timeline-title {
            font-size: 15px;
            font-weight: 700;
            color: #2d3748;
            margin: 0 0 10px 0;
        }

        .timeline-content {
            font-size: 13px;
            color: #4a5568;
            line-height: 1.6;
            background: #f8fafc;
            padding: 15px;
            border-radius: 8px;
            border-left: 3px solid #247f1b;
        }

        .notes-section {
            background: linear-gradient(135deg, #fef5e7 0%, #fdf2e7 100%);
            border: 1px solid #f6e05e;
            border-radius: 12px;
            padding: 25px;
            margin: 25px 0;
        }

        .notes-section h4 {
            color: #744210;
            margin: 0 0 15px 0;
            font-size: 16px;
            font-weight: 700;
        }

        .notes-section p {
            color: #744210;
            margin: 0;
            line-height: 1.6;
            font-size: 13px;
        }

        .footer {
            background: linear-gradient(135deg, #2d3748 0%, #1a202c 100%);
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 25% 25%, rgba(255,255,255,0.1) 2px, transparent 2px),
                        radial-gradient(circle at 75% 75%, rgba(255,255,255,0.1) 2px, transparent 2px);
            background-size: 30px 30px;
            opacity: 0.3;
        }

        .footer p {
            margin: 0 0 8px 0;
            font-size: 12px;
            opacity: 0.9;
            position: relative;
            z-index: 1;
        }

        .footer strong {
            color: #247f1b;
            font-weight: 700;
        }

        .footer .disclaimer {
            font-size: 10px;
            opacity: 0.7;
            font-style: italic;
        }

        @media print {
            body {
                padding: 0;
                background: white;
            }

            .container {
                box-shadow: none;
                border-radius: 0;
            }

            .info-card:hover {
                transform: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Morio Sacco</h1>
            <h2>Savings Account Statement</h2>
            <p>Account #{{ $saving->id }} | Generated: {{ date('d M Y \a\t H:i:s') }}</p>
        </div>

        <div class="section">
            <h3 class="section-title">👤 Member Profile</h3>
            <div class="member-profile">
                <div class="member-avatar">
                    {{ strtoupper(substr($saving->user->full_name ?? 'U', 0, 1)) }}
                </div>
                <div class="member-info">
                    <h3>{{ $saving->user->full_name ?? 'N/A' }}</h3>
                    <p>Member ID: {{ $saving->user->id_number ?? 'N/A' }} | Membership: {{ $saving->user->membership->membership_number ?? 'N/A' }}</p>
                </div>
            </div>

            <div class="info-grid">
                <!-- Personal Information -->
                <div class="info-card">
                    <span class="info-label">📞 Phone Number</span>
                    <div class="info-value">{{ $saving->user->phone_number ?? 'N/A' }}</div>
                </div>
                <div class="info-card">
                    <span class="info-label">📧 Email Address</span>
                    <div class="info-value">{{ $saving->user->email ?? 'N/A' }}</div>
                </div>
                <div class="info-card">
                    <span class="info-label">🏢 Branch</span>
                    <div class="info-value">{{ $saving->user->branch->name ?? 'N/A' }}</div>
                </div>
                <div class="info-card">
                    <span class="info-label">👤 Gender</span>
                    <div class="info-value">{{ $saving->user->gender ?? 'N/A' }}</div>
                </div>

                <!-- Account Information -->
                <div class="info-card">
                    <span class="info-label">💰 Account Type</span>
                    <div class="info-value">{{ $saving->type_label }}</div>
                </div>
                <div class="info-card">
                    <span class="info-label">📊 Account Status</span>
                    <div class="info-value">
                        <span class="status-badge {{ 'status-' . strtolower(str_replace(' ', '-', $saving->status)) }}">
                            {{ $saving->status_label }}
                        </span>
                    </div>
                </div>
                <div class="info-card highlight-card">
                    <span class="info-label">💵 Current Balance</span>
                    <div class="info-value">KSh {{ number_format($saving->current_balance, 0) }}</div>
                </div>
                <div class="info-card">
                    <span class="info-label">📅 Account Opened</span>
                    <div class="info-value">{{ $saving->created_at->format('d M Y') }}</div>
                </div>
            </div>

            <!-- Account Statistics -->
            <div class="stats-overview">
                <div class="stat-box success">
                    <span class="stat-value">{{ $saving->transactions->where('type', 'deposit')->count() }}</span>
                    <span class="stat-label">Total Deposits</span>
                </div>
                <div class="stat-box warning">
                    <span class="stat-value">{{ $saving->transactions->where('type', 'withdrawal')->count() }}</span>
                    <span class="stat-label">Total Withdrawals</span>
                </div>
                <div class="stat-box info">
                    <span class="stat-value">{{ $saving->created_at->diffInDays(now()) }}</span>
                    <span class="stat-label">Days Active</span>
                </div>
                <div class="stat-box">
                    <span class="stat-value">{{ $saving->transactions->count() }}</span>
                    <span class="stat-label">Total Transactions</span>
                </div>
            </div>
        </div>

        <div class="section">
            <h3 class="section-title">💰 Transaction History</h3>
            @if($saving->transactions->count() > 0)
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>📅 Date & Time</th>
                            <th>🔢 Transaction #</th>
                            <th>📊 Type</th>
                            <th>💵 Amount</th>
                            <th>⚖️ Balance After</th>
                            <th>👤 Processed By</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($saving->transactions->sortByDesc('transaction_date') as $transaction)
                        <tr>
                            <td>{{ $transaction->transaction_date->format('d M Y H:i') }}</td>
                            <td><strong>{{ $transaction->transaction_number }}</strong></td>
                            <td>
                                <span class="status-badge {{ $transaction->type === 'deposit' ? 'status-active' : 'status-withdrawn' }}">
                                    {{ ucfirst($transaction->type) }}
                                </span>
                            </td>
                            <td class="{{ $transaction->type === 'deposit' ? 'amount-positive' : 'amount-negative' }}">
                                {{ $transaction->type === 'deposit' ? '+' : '-' }}KSh {{ number_format($transaction->amount, 0) }}
                            </td>
                            <td><strong>KSh {{ number_format($transaction->balance_after, 0) }}</strong></td>
                            <td>{{ $transaction->processor->name ?? 'System' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @else
            <div style="text-align: center; padding: 50px; background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%); border-radius: 12px; margin: 25px 0; border: 2px solid #e2e8f0;">
                <div style="font-size: 48px; color: #cbd5e0; margin-bottom: 15px;">📭</div>
                <p style="color: #718096; font-style: italic; margin: 0; font-size: 14px; font-weight: 500;">No transactions recorded yet</p>
                <p style="color: #a0aec0; font-size: 12px; margin: 8px 0 0 0;">Transaction history will appear here once activity begins</p>
            </div>
            @endif
        </div>

        <div class="section">
            <h3 class="section-title">📅 Account Timeline</h3>
            <div class="timeline">
                <div class="timeline-item">
                    <div class="timeline-date">{{ $saving->created_at->format('d M Y H:i') }}</div>
                    <div class="timeline-title">🎉 Account Created</div>
                    <div class="timeline-content">
                        <strong>Savings account opened</strong> with initial deposit of <strong>KSh {{ number_format($saving->amount, 0) }}</strong><br>
                        Account Type: <em>{{ $saving->type_label }}</em>
                        @if($saving->maturity_date)
                        <br>Maturity Date: <em>{{ $saving->maturity_date->format('d M Y') }}</em>
                        @endif
                    </div>
                </div>

                @foreach($saving->transactions->sortBy('transaction_date') as $transaction)
                <div class="timeline-item">
                    <div class="timeline-date">{{ $transaction->transaction_date->format('d M Y H:i') }}</div>
                    <div class="timeline-title">{{ $transaction->type === 'deposit' ? '💰' : '💸' }} {{ ucfirst($transaction->type) }} Transaction</div>
                    <div class="timeline-content">
                        <strong>{{ ucfirst($transaction->type) }} of KSh {{ number_format($transaction->amount, 0) }}</strong><br>
                        Transaction #: <code>{{ $transaction->transaction_number }}</code><br>
                        Balance after: <strong>KSh {{ number_format($transaction->balance_after, 0) }}</strong><br>
                        Processed by: <em>{{ $transaction->processor->name ?? 'System' }}</em>
                    </div>
                </div>
                @endforeach

                @if($saving->status === 'withdrawn')
                <div class="timeline-item">
                    <div class="timeline-date">{{ now()->format('d M Y H:i') }}</div>
                    <div class="timeline-title">🏦 Account Withdrawn</div>
                    <div class="timeline-content">
                        <strong>Savings account has been fully withdrawn</strong><br>
                        Final balance: <strong>KSh {{ number_format($saving->current_balance, 0) }}</strong>
                    </div>
                </div>
                @elseif($saving->status === 'matured')
                <div class="timeline-item">
                    <div class="timeline-date">{{ now()->format('d M Y H:i') }}</div>
                    <div class="timeline-title">🎊 Account Matured</div>
                    <div class="timeline-content">
                        <strong>Fixed deposit account has reached maturity</strong><br>
                        Available for withdrawal: <strong>KSh {{ number_format($saving->current_balance, 0) }}</strong>
                    </div>
                </div>
                @endif
            </div>
        </div>

       @if($saving->notes)
       <div class="section">
           <h3 class="section-title">📝 Account Notes</h3>
           <div class="notes-section">
               <h4>📋 Important Notes</h4>
               <p>{{ $saving->notes }}</p>
           </div>
       </div>
       @endif

       <div class="footer">
           <p><strong>Morio Sacco</strong> - Official Savings Account Statement</p>
           <p>Account #{{ $saving->id }} | Generated on {{ date('d M Y \a\t H:i:s') }}</p>
           <p class="disclaimer">This document contains confidential financial information. Handle with care and store securely.</p>
       </div>
    </div>
</body>
</html>
