<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Savings Report - Morio Sacco</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            border-bottom: 3px solid #247f1b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header h1 {
            color: #247f1b;
            font-size: 24px;
            margin: 0;
            font-weight: bold;
        }

        .header p {
            color: #666;
            margin: 5px 0;
            font-size: 14px;
        }

        .report-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #247f1b;
        }

        .report-info p {
            margin: 5px 0;
            font-size: 12px;
        }

        .stats {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .stats-row {
            display: table-row;
        }

        .stats-cell {
            display: table-cell;
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
            background: #f8f9fa;
        }

        .stats-cell strong {
            font-size: 16px;
            color: #247f1b;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 10px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            text-align: center;
            font-size: 11px;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        tr:hover {
            background-color: #e8f5e8;
        }

        .amount {
            text-align: right;
            font-weight: bold;
            color: #247f1b;
        }

        .status-active {
            color: #28a745;
            font-weight: bold;
        }

        .status-withdrawn {
            color: #ffc107;
            font-weight: bold;
        }

        .status-matured {
            color: #17a2b8;
            font-weight: bold;
        }

        .type-regular {
            color: #6c757d;
        }

        .type-fixed {
            color: #247f1b;
            font-weight: bold;
        }

        .type-emergency {
            color: #dc3545;
            font-weight: bold;
        }

        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #247f1b;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .page-break {
            page-break-before: always;
        }

        @media print {
            body {
                font-size: 11px;
            }

            table {
                font-size: 9px;
            }

            th {
                font-size: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Morio Sacco</h1>
        <p>Savings Accounts Report</p>
        <p>Generated on: {{ date('d M Y H:i:s') }}</p>
    </div>

    <div class="report-info">
        <p><strong>Report Period:</strong> All Time</p>
        <p><strong>Total Savings Accounts:</strong> {{ $savings->count() }}</p>
        <p><strong>Total Savings Amount:</strong> KSh {{ number_format($savings->sum('amount'), 2) }}</p>
        <p><strong>Active Accounts:</strong> {{ $savings->where('status', 'active')->count() }}</p>
        <p><strong>Generated By:</strong> {{ auth()->user()->full_name }}</p>
    </div>

    <div class="stats">
        <div class="stats-row">
            <div class="stats-cell">
                <strong>{{ $savings->count() }}</strong><br>
                Total Accounts
            </div>
            <div class="stats-cell">
                <strong>{{ $savings->where('status', 'active')->count() }}</strong><br>
                Active Accounts
            </div>
            <div class="stats-cell">
                <strong>{{ $savings->where('status', 'withdrawn')->count() }}</strong><br>
                Withdrawn Accounts
            </div>
            <div class="stats-cell">
                <strong>{{ $savings->where('status', 'matured')->count() }}</strong><br>
                Matured Accounts
            </div>
        </div>
        <div class="stats-row">
            <div class="stats-cell">
                <strong>KSh {{ number_format($savings->sum('amount'), 2) }}</strong><br>
                Total Savings
            </div>
            <div class="stats-cell">
                <strong>KSh {{ number_format($savings->where('status', 'active')->sum('amount'), 2) }}</strong><br>
                Active Savings
            </div>
            <div class="stats-cell">
                <strong>{{ $savings->where('type', 'fixed')->count() }}</strong><br>
                Fixed Accounts
            </div>
            <div class="stats-cell">
                <strong>{{ $savings->where('type', 'regular')->count() }}</strong><br>
                Regular Accounts
            </div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Member Name</th>
                <th>Membership No.</th>
                <th>Amount (KSh)</th>
                <th>Type</th>
                <th>Status</th>
                <th>Maturity Date</th>
                <th>Created Date</th>
                <th>Branch</th>
                <th>Phone</th>
                <th>Email</th>
            </tr>
        </thead>
        <tbody>
            @foreach($savings as $saving)
            <tr>
                <td style="text-align: center;">{{ $saving->id }}</td>
                <td>{{ $saving->user->full_name ?? 'N/A' }}</td>
                <td style="text-align: center;">{{ $saving->user->membership->membership_number ?? 'N/A' }}</td>
                <td class="amount">{{ number_format($saving->amount, 2) }}</td>
                <td style="text-align: center;">
                    <span class="type-{{ $saving->type }}">
                        {{ ucfirst($saving->type) }}
                    </span>
                </td>
                <td style="text-align: center;">
                    <span class="status-{{ $saving->status }}">
                        {{ ucfirst($saving->status) }}
                    </span>
                </td>
                <td style="text-align: center;">
                    {{ $saving->maturity_date ? $saving->maturity_date->format('d M Y') : 'N/A' }}
                </td>
                <td style="text-align: center;">{{ $saving->created_at->format('d M Y') }}</td>
                <td>{{ $saving->user->branch->name ?? 'N/A' }}</td>
                <td>{{ $saving->user->phone_number ?? 'N/A' }}</td>
                <td>{{ $saving->user->email ?? 'N/A' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p><strong>{{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }} - Savings Accounts Report</strong></p>
        <p>
            <i class="fas fa-phone"></i> {{ \App\Models\SystemSetting::get('contact_phone', '+254 700 000 000') }} |
            <i class="fas fa-envelope"></i> {{ \App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke') }} |
            <i class="fas fa-map-marker-alt"></i> {{ \App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya') }}
        </p>
        <p>
            <i class="fas fa-globe"></i> {{ \App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke') }} |
            Generated on {{ now()->format('d M Y \a\t H:i:s') }} | Page 1 of 1 | Confidential Document
        </p>
        <p>For Internal Use Only</p>
    </div>
</body>
</html>
