@extends('adminlte::page')

@section('title', 'Edit Savings Account')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Savings Account #{{ $saving->id }}</h3>
                </div>

                <form action="{{ route('savings.update', $saving) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="user_id">Member <span class="text-danger">*</span></label>
                                    <select name="user_id" id="user_id" class="form-control @error('user_id') is-invalid @enderror" required>
                                        <option value="">Select Member</option>
                                        @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id', $saving->user_id) == $user->id ? 'selected' : '' }}>
                                            {{ $user->full_name }} ({{ $user->id_number }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('user_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Initial Savings Amount (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror"
                                           value="{{ old('amount', $saving->amount) }}" min="100" step="0.01" required readonly>
                                    <small class="form-text text-muted">
                                        Initial amount set when account was created. Use deposits/withdrawals to change balance.
                                    </small>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="type">Savings Type <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-control @error('type') is-invalid @enderror" required>
                                        <option value="">Select Type</option>
                                        <option value="regular" {{ old('type', $saving->type) == 'regular' ? 'selected' : '' }}>Regular Savings</option>
                                        <option value="fixed" {{ old('type', $saving->type) == 'fixed' ? 'selected' : '' }}>Fixed Deposit</option>
                                        <option value="emergency" {{ old('type', $saving->type) == 'emergency' ? 'selected' : '' }}>Emergency Fund</option>
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="status">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="active" {{ old('status', $saving->status) == 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="withdrawn" {{ old('status', $saving->status) == 'withdrawn' ? 'selected' : '' }}>Withdrawn</option>
                                        <option value="matured" {{ old('status', $saving->status) == 'matured' ? 'selected' : '' }}>Matured</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group" id="maturity_date_group" style="display: none;">
                                    <label for="maturity_date">Maturity Date</label>
                                    <input type="date" name="maturity_date" id="maturity_date" class="form-control @error('maturity_date') is-invalid @enderror"
                                           value="{{ old('maturity_date', $saving->maturity_date ? $saving->maturity_date->format('Y-m-d') : '') }}">
                                    @error('maturity_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">Notes</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror"
                                              rows="3" placeholder="Additional notes about the savings account">{{ old('notes', $saving->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Current Account Information -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-warning">
                                    <div class="card-header">
                                        <h5 class="card-title">Current Account Information</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Account ID</span>
                                                        <span class="info-box-number">#{{ $saving->id }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Created Date</span>
                                                        <span class="info-box-number">{{ $saving->created_at->format('d M Y') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Current Balance</span>
                                                        <span class="info-box-number">KSh {{ number_format($saving->current_balance, 2) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Total Deposits</span>
                                                        <span class="info-box-number">KSh {{ number_format($saving->transactions()->where('type', 'deposit')->sum('amount'), 2) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-2">
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Total Withdrawals</span>
                                                        <span class="info-box-number">KSh {{ number_format($saving->transactions()->where('type', 'withdrawal')->sum('amount'), 2) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Transaction Count</span>
                                                        <span class="info-box-number">{{ $saving->transactions()->count() }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="info-box bg-light">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Days Active</span>
                                                        <span class="info-box-number">{{ $saving->created_at->diffInDays(now()) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Recent Transactions -->
                                        @if($saving->transactions()->count() > 0)
                                        <div class="row mt-3">
                                            <div class="col-md-12">
                                                <div class="card card-outline card-info">
                                                    <div class="card-header">
                                                        <h5 class="card-title">Recent Transactions</h5>
                                                    </div>
                                                    <div class="card-body p-0">
                                                        <div class="table-responsive">
                                                            <table class="table table-sm mb-0">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Date</th>
                                                                        <th>Type</th>
                                                                        <th>Amount</th>
                                                                        <th>Balance After</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @foreach($saving->transactions()->latest()->take(5) as $transaction)
                                                                    <tr>
                                                                        <td>{{ $transaction->transaction_date->format('d M Y') }}</td>
                                                                        <td>
                                                                            <span class="badge badge-{{ $transaction->type === 'deposit' ? 'success' : 'warning' }}">
                                                                                {{ ucfirst($transaction->type) }}
                                                                            </span>
                                                                        </td>
                                                                        <td>KSh {{ number_format($transaction->amount, 2) }}</td>
                                                                        <td>KSh {{ number_format($transaction->balance_after, 2) }}</td>
                                                                    </tr>
                                                                    @endforeach
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Update Savings Account</button>
                        <a href="{{ route('savings.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@push('js')
<script>
$(document).ready(function() {
    // Show/hide maturity date based on savings type
    $('#type').on('change', function() {
        if ($(this).val() === 'fixed') {
            $('#maturity_date_group').show();
        } else {
            $('#maturity_date_group').hide();
        }
    });

    // Trigger change on page load
    $('#type').trigger('change');
});
</script>
@endpush

