@extends('adminlte::page')

@section('title', 'Create Savings Account')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Savings Account Form</h3>
                </div>

                <form action="{{ route('savings.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="user_id">Member <span class="text-danger">*</span></label>
                                    <select name="user_id" id="user_id" class="form-control @error('user_id') is-invalid @enderror" required>
                                        <option value="">Select Member</option>
                                        @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                            {{ $user->full_name }} ({{ $user->id_number }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('user_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Savings Amount (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror"
                                           value="{{ old('amount') }}" min="100" step="0.01" required>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">Savings Type <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-control @error('type') is-invalid @enderror" required>
                                        <option value="">Select Type</option>
                                        <option value="regular" {{ old('type') == 'regular' ? 'selected' : '' }}>Regular Savings</option>
                                        <option value="fixed" {{ old('type') == 'fixed' ? 'selected' : '' }}>Fixed Deposit</option>
                                        <option value="emergency" {{ old('type') == 'emergency' ? 'selected' : '' }}>Emergency Fund</option>
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group" id="maturity_date_group" style="display: none;">
                                    <label for="maturity_date">Maturity Date</label>
                                    <input type="date" name="maturity_date" id="maturity_date" class="form-control @error('maturity_date') is-invalid @enderror"
                                           value="{{ old('maturity_date') }}" min="{{ date('Y-m-d', strtotime('+1 day')) }}">
                                    @error('maturity_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                    <small class="form-text text-muted">Required for Fixed Deposit accounts</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">Notes</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror"
                                              rows="3" placeholder="Additional notes about the savings account">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Savings Type Information -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card card-outline card-info">
                                    <div class="card-header">
                                        <h5 class="card-title">Savings Account Types</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="info-box bg-primary">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Regular Savings</span>
                                                        <span class="info-box-number">Flexible</span>
                                                        <div class="progress">
                                                            <div class="progress-bar bg-primary" style="width: 100%"></div>
                                                        </div>
                                                        <span class="progress-description">
                                                            Withdraw anytime
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="info-box bg-info">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Fixed Deposit</span>
                                                        <span class="info-box-number">High Interest</span>
                                                        <div class="progress">
                                                            <div class="progress-bar bg-info" style="width: 100%"></div>
                                                        </div>
                                                        <span class="progress-description">
                                                            Locked until maturity
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="info-box bg-danger">
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Emergency Fund</span>
                                                        <span class="info-box-number">Quick Access</span>
                                                        <div class="progress">
                                                            <div class="progress-bar bg-danger" style="width: 100%"></div>
                                                        </div>
                                                        <span class="progress-description">
                                                            For urgent needs
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Create Savings Account</button>
                        <a href="{{ route('savings.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@push('js')
<script>
$(document).ready(function() {
    // Show/hide maturity date based on savings type
    $('#type').on('change', function() {
        if ($(this).val() === 'fixed') {
            $('#maturity_date_group').show();
            $('#maturity_date').attr('required', true);
        } else {
            $('#maturity_date_group').hide();
            $('#maturity_date').attr('required', false);
        }
    });

    // Trigger change on page load if value is already selected
    $('#type').trigger('change');
});
</script>
@endpush

