@extends('adminlte::page')

@section('title', 'Edit Occupation')

@section('content')
<div class="row">
    <div class="col-md-8 offset-md-2">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Edit Occupation</h5>
                <div class="card-toolbar">
                    <a href="{{ route('occupations.index') }}" class="btn btn-secondary btn-sm">
                        <i class="cil-arrow-left"></i> Back to Occupations
                    </a>
                </div>
            </div>
            <form action="{{ route('occupations.update', $occupation) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="name">Occupation Name <span class="text-danger">*</span></label>
                                <input type="text" name="name" id="name"
                                       class="form-control @error('name') is-invalid @enderror"
                                       value="{{ old('name', $occupation->name) }}" required>
                                <small class="form-text text-muted">Enter the occupation name (e.g., Teacher, Doctor, Engineer)</small>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="sort_order">Sort Order</label>
                                <input type="number" name="sort_order" id="sort_order"
                                       class="form-control @error('sort_order') is-invalid @enderror"
                                       value="{{ old('sort_order', $occupation->sort_order) }}" min="0">
                                <small class="form-text text-muted">Order for display (lower numbers appear first)</small>
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="description">Description (Optional)</label>
                        <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror"
                                  rows="3" placeholder="Describe this occupation...">{{ old('description', $occupation->description) }}</textarea>
                        <small class="form-text text-muted">Provide additional details about this occupation</small>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="hidden" name="is_active" value="0">
                            <input type="checkbox" name="is_active" value="1" {{ old('is_active', $occupation->is_active) ? 'checked' : '' }}
                                   class="custom-control-input @error('is_active') is-invalid @enderror" id="is_active">
                            <label class="custom-control-label" for="is_active">Active Status</label>
                        </div>
                        <small class="form-text text-muted">Only active occupations will be available for selection</small>
                        @error('is_active')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="cil-save"></i> Update Occupation
                    </button>
                    <a href="{{ route('occupations.index') }}" class="btn btn-secondary ms-2">
                        <i class="cil-x"></i> Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
@stop
