@extends('adminlte::page')

@section('title', 'M-Pesa Credentials')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa API Configuration</h3>
                    <div class="card-tools">
                        @if($mpesaCredentials->isEmpty())
                            <a href="{{ route('mpesa-credentials.create') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> Add M-Pesa Credentials
                            </a>
                        @endif
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    @if($mpesaCredentials->isNotEmpty())
                        <table class="table table-hover text-nowrap">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Shortcode</th>
                                    <th>Environment</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($mpesaCredentials as $credential)
                                <tr>
                                    <td>{{ $credential->id }}</td>
                                    <td>{{ $credential->shortcode }}</td>
                                    <td>
                                        <span class="badge badge-{{ $credential->environment === 'production' ? 'success' : 'warning' }}">
                                            {{ ucfirst($credential->environment) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $credential->is_active ? 'success' : 'secondary' }}">
                                            {{ $credential->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>{{ $credential->created_at->format('d M Y') }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('mpesa-credentials.show', $credential) }}" class="btn btn-info btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('mpesa-credentials.edit', $credential) }}" class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($mpesaCredentials->count() > 1)
                                            <form action="{{ route('mpesa-credentials.destroy', $credential) }}" method="POST" class="d-inline"
                                                  onsubmit="return confirm('Are you sure you want to delete these M-Pesa credentials?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <div class="text-center py-5">
                            <div class="text-muted">
                                <i class="fas fa-mobile-alt fa-4x mb-3"></i>
                                <h4>No M-Pesa Credentials Configured</h4>
                                <p>You need to configure M-Pesa credentials to enable mobile payments.</p>
                                <a href="{{ route('mpesa-credentials.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Configure M-Pesa Credentials
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if($mpesaCredentials->isNotEmpty())
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">M-Pesa Configuration Guide</h3>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h5><i class="icon fas fa-info"></i> Important Notes:</h5>
                        <ul class="mb-0">
                            <li>Get your M-Pesa credentials from the <a href="https://developer.safaricom.co.ke/" target="_blank">Safaricom Developer Portal</a></li>
                            <li>Use <strong>sandbox</strong> environment for testing and <strong>production</strong> for live payments</li>
                            <li>Only one set of credentials can be active at a time</li>
                            <li>Keep your credentials secure and never share them publicly</li>
                        </ul>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h6>Sandbox Credentials (Testing)</h6>
                            <ul>
                                <li><strong>Consumer Key:</strong> Available on developer portal</li>
                                <li><strong>Consumer Secret:</strong> Available on developer portal</li>
                                <li><strong>Shortcode:</strong> Your test shortcode</li>
                                <li><strong>Passkey:</strong> Your test passkey</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Production Credentials (Live)</h6>
                            <ul>
                                <li><strong>Consumer Key:</strong> From production app</li>
                                <li><strong>Consumer Secret:</strong> From production app</li>
                                <li><strong>Shortcode:</strong> Your business shortcode</li>
                                <li><strong>Passkey:</strong> Your production passkey</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

</div>
@stop

