<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Memberships Report - {{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }}</title>
    <style>
        @page {
            margin: 20mm;
            size: A4 landscape;
        }

        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 3px solid #247f1b;
            padding-bottom: 10px;
        }

        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }

        .header p {
            margin: 5px 0;
            color: #666;
            font-size: 12px;
        }

        .report-info {
            margin-bottom: 15px;
            font-size: 11px;
        }

        .stats {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }

        .stat-box {
            display: table-cell;
            width: 20%;
            text-align: center;
            padding: 8px;
            margin: 0 2px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .stat-number {
            font-size: 14px;
            font-weight: bold;
            color: #247f1b;
            display: block;
        }

        .stat-label {
            font-size: 10px;
            color: #666;
            margin-top: 2px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 8px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 4px 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #247f1b;
            color: white;
            font-weight: bold;
            text-align: center;
            font-size: 9px;
        }

        tr:nth-child(even) {
            background-color: #fff8f8;
        }

        tr:nth-child(odd) {
            background-color: #ffffff;
        }

        .status-active {
            color: #28a745;
            font-weight: bold;
        }

        .status-inactive {
            color: #ffc107;
            font-weight: bold;
        }

        .status-suspended {
            color: #dc3545;
            font-weight: bold;
        }

        .fee-paid {
            color: #28a745;
        }

        .fee-pending {
            color: #ffc107;
        }

        .fee-waived {
            color: #17a2b8;
        }

        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 9px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }

        .amount {
            text-align: right;
            font-weight: bold;
        }

        .center-text {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header">
        @if(\App\Models\SystemSetting::get('logo_path'))
            <img src="{{ public_path(\App\Models\SystemSetting::get('logo_path')) }}" alt="{{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }} Logo" style="height: 50px; margin-bottom: 10px;">
        @endif
        <h1>{{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }} - Memberships Report</h1>
        <p>Comprehensive Member Information Report</p>
    </div>

    <div class="report-info">
        <strong>Report Generated:</strong> {{ now()->format('d M Y H:i:s') }} |
        <strong>Total Members:</strong> {{ $memberships->count() }} |
        <strong>Active Members:</strong> {{ $memberships->where('status', 'active')->count() }} |
        <strong>Period:</strong> All Time
    </div>

    <div class="stats">
        <div class="stat-box">
            <span class="stat-number">{{ $memberships->count() }}</span>
            <span class="stat-label">Total Members</span>
        </div>
        <div class="stat-box">
            <span class="stat-number">{{ $memberships->where('status', 'active')->count() }}</span>
            <span class="stat-label">Active Members</span>
        </div>
        <div class="stat-box">
            <span class="stat-number">{{ $memberships->where('status', 'inactive')->count() }}</span>
            <span class="stat-label">Inactive Members</span>
        </div>
        <div class="stat-box">
            <span class="stat-number">{{ $memberships->where('status', 'suspended')->count() }}</span>
            <span class="stat-label">Suspended Members</span>
        </div>
        <div class="stat-box">
            <span class="stat-number">KSh {{ number_format($memberships->sum('share_capital'), 2) }}</span>
            <span class="stat-label">Total Share Capital</span>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 3%;">ID</th>
                <th style="width: 8%;">Membership #</th>
                <th style="width: 12%;">Member Name</th>
                <th style="width: 5%;">Gender</th>
                <th style="width: 8%;">ID Number</th>
                <th style="width: 10%;">Phone</th>
                <th style="width: 12%;">Email</th>
                <th style="width: 8%;">Branch</th>
                <th style="width: 7%;">Join Date</th>
                <th style="width: 6%;">Status</th>
                <th style="width: 8%;">Share Capital</th>
                <th style="width: 8%;">Savings</th>
                <th style="width: 5%;">Reg Fee Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($memberships as $membership)
            <tr>
                <td class="center-text">{{ $membership->id }}</td>
                <td class="center-text">{{ $membership->membership_number }}</td>
                <td>{{ $membership->user->full_name ?? 'N/A' }}</td>
                <td class="center-text">{{ ucfirst($membership->gender) }}</td>
                <td>{{ $membership->user->id_number ?? 'N/A' }}</td>
                <td>{{ $membership->user->phone_number ?? 'N/A' }}</td>
                <td>{{ $membership->user->email ?? 'N/A' }}</td>
                <td>{{ $membership->user->branch->name ?? 'N/A' }}</td>
                <td class="center-text">{{ $membership->joining_date ? $membership->joining_date->format('d/m/Y') : 'N/A' }}</td>
                <td class="center-text">
                    <span class="status-{{ $membership->status }}">
                        {{ ucfirst($membership->status) }}
                    </span>
                </td>
                <td class="amount">KSh {{ number_format($membership->share_capital, 2) }}</td>
                <td class="amount">KSh {{ number_format($membership->savings_balance, 2) }}</td>
                <td class="center-text">
                    <span class="fee-{{ $membership->registration_fee_status }}">
                        {{ ucfirst($membership->registration_fee_status) }}
                    </span>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p><strong>{{ \App\Models\SystemSetting::get('system_name', 'Morio Sacco') }} Management System</strong></p>
        <p>
            <i class="fas fa-phone"></i> {{ \App\Models\SystemSetting::get('contact_phone', '+254 700 000 000') }} |
            <i class="fas fa-envelope"></i> {{ \App\Models\SystemSetting::get('contact_email', 'info@morio-sacco.co.ke') }} |
            <i class="fas fa-map-marker-alt"></i> {{ \App\Models\SystemSetting::get('contact_address', 'Koinange Street, Nairobi, Kenya') }}
        </p>
        <p>
            <i class="fas fa-globe"></i> {{ \App\Models\SystemSetting::get('app_url', 'https://morio-sacco.co.ke') }} |
            Report generated on {{ now()->format('l, F j, Y \a\t g:i A') }} | Confidential Document
        </p>
    </div>
</body>
</html>

