<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Loan Details - {{ $loan->user->full_name }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 15px;
            background: #fff;
        }

        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 3px solid #247f1b;
            padding-bottom: 8px;
        }

        .header h1 {
            color: #247f1b;
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }

        .header h2 {
            color: #247f1b;
            margin: 3px 0;
            font-size: 16px;
        }

        .header p {
            margin: 2px 0;
            color: #666;
            font-size: 10px;
        }

        .section {
            margin-bottom: 12px;
            padding: 8px;
            border: 1px solid #e9ecef;
            border-radius: 6px;
            background: #f8f9fa;
        }

        .section-title {
            font-size: 12px;
            font-weight: bold;
            color: #247f1b;
            margin-bottom: 6px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .member-info {
            display: table;
            width: 100%;
            margin-bottom: 8px;
        }

        .member-avatar {
            display: table-cell;
            width: 80px;
            text-align: center;
            vertical-align: top;
            padding-right: 10px;
        }

        .avatar-circle {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #247f1b 0%, #1e6b16 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            font-weight: bold;
            margin: 0 auto 5px;
        }

        .member-details {
            display: table-cell;
            vertical-align: top;
        }

        .member-name {
            font-size: 14px;
            font-weight: bold;
            color: #247f1b;
            margin-bottom: 4px;
        }

        .member-meta {
            font-size: 9px;
            color: #666;
            margin-bottom: 2px;
        }

        .loan-summary {
            display: table;
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }

        .loan-summary-item {
            display: table-cell;
            width: 25%;
            text-align: center;
            padding: 6px;
            background: white;
            border: 1px solid #e9ecef;
            border-radius: 4px;
            margin: 2px;
        }

        .summary-value {
            font-size: 13px;
            font-weight: bold;
            color: #247f1b;
            display: block;
        }

        .summary-label {
            font-size: 8px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .progress-section {
            margin: 8px 0;
        }

        .progress-label {
            font-size: 9px;
            color: #666;
            margin-bottom: 3px;
        }

        .progress-bar {
            height: 8px;
            background: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #28a745 0%, #20c997 100%);
            border-radius: 4px;
        }

        .repayment-history {
            margin-top: 8px;
        }

        .history-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8px;
            margin-top: 4px;
        }

        .history-table th,
        .history-table td {
            border: 1px solid #ddd;
            padding: 3px 4px;
            text-align: left;
        }

        .history-table th {
            background: #247f1b;
            color: white;
            font-weight: bold;
            text-align: center;
            font-size: 8px;
        }

        .amount-cell {
            text-align: right;
            font-weight: bold;
            color: #28a745;
        }

        .status-badge {
            padding: 1px 4px;
            border-radius: 2px;
            font-size: 7px;
            font-weight: bold;
            text-transform: uppercase;
            text-align: center;
        }

        .badge-success { background: #28a745; color: white; }
        .badge-warning { background: #ffc107; color: black; }
        .badge-info { background: #17a2b8; color: white; }

        .footer {
            margin-top: 15px;
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 8px;
            font-size: 8px;
            color: #666;
        }

        .footer p {
            margin: 2px 0;
        }

        .notes-section {
            margin-top: 8px;
            padding: 6px;
            background: white;
            border-left: 3px solid #247f1b;
            font-style: italic;
        }

        .notes-section p {
            margin: 0;
            font-size: 9px;
            color: #555;
        }

        .status-indicator {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 8px;
            font-weight: bold;
            text-transform: uppercase;
            color: white;
        }

        .status-approved { background: #28a745; }
        .status-active { background: #17a2b8; }
        .status-pending { background: #ffc107; color: #000; }
        .status-rejected { background: #dc3545; }
        .status-paid { background: #6f42c1; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>Morio Sacco</h1>
        <h2>Loan Details Report</h2>
        <p>Application #{{ $loan->id }} | Generated on {{ date('d M Y \a\t H:i') }}</p>
    </div>

    <!-- Member Information -->
    <div class="section">
        <div class="section-title">Member Information</div>
        <div class="member-info">
            <div class="member-avatar">
                <div class="avatar-circle">
                    {{ strtoupper(substr($loan->user->first_name, 0, 1)) }}{{ strtoupper(substr($loan->user->second_name, 0, 1)) }}
                </div>
                <div style="font-size: 8px; color: #666;">ID: {{ $loan->user->membership->membership_number ?? 'N/A' }}</div>
            </div>
            <div class="member-details">
                <div class="member-name">{{ $loan->user->full_name }}</div>
                <div class="member-meta"><strong>Phone:</strong> {{ $loan->user->phone_number }}</div>
                <div class="member-meta"><strong>Email:</strong> {{ $loan->user->email }}</div>
                <div class="member-meta"><strong>ID Number:</strong> {{ $loan->user->id_number }}</div>
                <div class="member-meta"><strong>Branch:</strong> {{ $loan->user->branch->name ?? 'N/A' }}</div>
                <div class="member-meta">
                    <strong>Application Date:</strong> {{ $loan->created_at->format('d M Y') }}
                    @if($loan->approved_at)
                        | <strong>Approved:</strong> {{ $loan->approved_at->format('d M Y') }}
                    @endif
                </div>
                <div class="member-meta">
                    <strong>Status:</strong>
                    <span class="status-indicator status-{{ $loan->status }}">
                        {{ ucfirst($loan->status) }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Loan Financial Summary -->
    <div class="section">
        <div class="section-title">Loan Financial Summary</div>
        <div class="loan-summary">
            <div class="loan-summary-item">
                <span class="summary-value">KSh {{ number_format($loan->amount, 0) }}</span>
                <span class="summary-label">Principal Amount</span>
            </div>
            <div class="loan-summary-item">
                <span class="summary-value">{{ $loan->interest_rate }}%</span>
                <span class="summary-label">Interest Rate</span>
            </div>
            <div class="loan-summary-item">
                <span class="summary-value">{{ $loan->term_months }}</span>
                <span class="summary-label">Term (Months)</span>
            </div>
            <div class="loan-summary-item">
                <span class="summary-value">KSh {{ number_format($loan->total_amount, 0) }}</span>
                <span class="summary-label">Total Amount</span>
            </div>
        </div>

        <div class="loan-summary" style="margin-top: 4px;">
            <div class="loan-summary-item">
                <span class="summary-value">KSh {{ number_format($loan->monthly_payment, 0) }}</span>
                <span class="summary-label">Monthly Payment</span>
            </div>
            <div class="loan-summary-item">
                <span class="summary-value">KSh {{ number_format($loan->balance, 0) }}</span>
                <span class="summary-label">Outstanding Balance</span>
            </div>
            <div class="loan-summary-item">
                <span class="summary-value">KSh {{ number_format($loan->paid_amount, 0) }}</span>
                <span class="summary-label">Amount Paid</span>
            </div>
            <div class="loan-summary-item">
                <span class="summary-value">{{ number_format((($loan->total_amount - $loan->balance) / $loan->total_amount) * 100, 1) }}%</span>
                <span class="summary-label">Repayment Progress</span>
            </div>
        </div>

        @if($loan->status !== 'paid')
        <div class="progress-section">
            <div class="progress-label">Repayment Progress</div>
            <div class="progress-bar">
                <div class="progress-fill" style="width: {{ number_format((($loan->total_amount - $loan->balance) / $loan->total_amount) * 100, 1) }}%"></div>
            </div>
        </div>
        @endif
    </div>

    <!-- Repayment History -->
    @if($loan->repayments->count() > 0)
    <div class="section">
        <div class="section-title">Recent Repayment History</div>
        <div class="repayment-history">
            <table class="history-table">
                <thead>
                    <tr>
                        <th style="width: 15%;">Date</th>
                        <th style="width: 20%;">Amount</th>
                        <th style="width: 25%;">Payment Method</th>
                        <th style="width: 15%;">Status</th>
                        <th style="width: 25%;">Reference</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($loan->repayments->sortByDesc('created_at')->take(8) as $repayment)
                    <tr>
                        <td>{{ $repayment->created_at->format('d M') }}</td>
                        <td class="amount-cell">KSh {{ number_format($repayment->amount, 0) }}</td>
                        <td>
                            @if($repayment->payment_method === 'mpesa_stk')
                                M-Pesa STK
                            @elseif($repayment->payment_method === 'mpesa_manual')
                                M-Pesa Manual
                            @elseif($repayment->payment_method === 'bank_transfer')
                                Bank Transfer
                            @else
                                {{ ucfirst(str_replace('_', ' ', $repayment->payment_method ?? 'cash')) }}
                            @endif
                        </td>
                        <td>
                            <span class="status-badge badge-{{ $repayment->status === 'completed' ? 'success' : 'warning' }}">
                                {{ $repayment->status === 'completed' ? '✓' : '○' }}
                            </span>
                        </td>
                        <td style="font-size: 7px;">
                            @if($repayment->payment_method === 'mpesa_stk' || $repayment->payment_method === 'mpesa_manual')
                                {{ $repayment->mpesa_phone_number ?: $repayment->reference_number ?: 'N/A' }}
                            @else
                                {{ $repayment->reference_number ?: 'N/A' }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @if($loan->repayments->count() > 8)
            <div style="text-align: center; margin-top: 4px; font-size: 8px; color: #666;">
                ... and {{ $loan->repayments->count() - 8 }} more payments
            </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Loan Security/Guarantees -->
    @if($loan->guarantees->count() > 0)
    <div class="section">
        <div class="section-title">Loan Security & Guarantees</div>
        @foreach($loan->guarantees as $guarantee)
        <div style="margin-bottom: 8px; padding: 6px; background: white; border-radius: 4px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 4px;">
                <strong style="color: #247f1b;">{{ $guarantee->type_label }}</strong>
                <span style="padding: 2px 6px; border-radius: 10px; font-size: 7px; font-weight: bold; text-transform: uppercase; background: {{ $guarantee->status === 'approved' ? '#28a745' : ($guarantee->status === 'pending' ? '#ffc107' : '#dc3545') }}; color: {{ $guarantee->status === 'pending' ? 'black' : 'white' }};">
                    {{ ucfirst($guarantee->status) }}
                </span>
            </div>

            @if($guarantee->guarantee_type === 'guarantor')
                @foreach($guarantee->guarantors as $guarantor)
                <div style="margin-left: 10px; padding-left: 8px; border-left: 2px solid #247f1b; margin-bottom: 4px;">
                    <div style="font-size: 9px;">
                        <strong>{{ $guarantor->guarantor->full_name }}</strong> |
                        {{ $guarantor->relationship_label }} |
                        Guarantee: KSh {{ number_format($guarantor->guarantee_amount, 0) }}
                    </div>
                    @if($guarantor->relationship_details)
                    <div style="font-size: 8px; color: #666; margin-top: 2px;">
                        {{ $guarantor->relationship_details }}
                    </div>
                    @endif
                </div>
                @endforeach
            @elseif($guarantee->guarantee_type === 'collateral')
                @foreach($guarantee->collateral as $item)
                <div style="margin-left: 10px; padding-left: 8px; border-left: 2px solid #247f1b; margin-bottom: 4px;">
                    <div style="font-size: 9px;">
                        <strong>{{ $item->item_type_label }}: {{ $item->item_description }}</strong><br>
                        {{ $item->document_type_label }} #{{ $item->ownership_document_number }} |
                        Value: KSh {{ number_format($item->estimated_value, 0) }}
                    </div>
                    @if($item->ownership_details)
                    <div style="font-size: 8px; color: #666; margin-top: 2px;">
                        {{ Str::limit($item->ownership_details, 150) }}
                    </div>
                    @endif
                </div>
                @endforeach
            @elseif($guarantee->guarantee_type === 'salary')
                @if($guarantee->salaryGuarantee)
                <div style="margin-left: 10px; padding-left: 8px; border-left: 2px solid #247f1b; margin-bottom: 4px;">
                    <div style="font-size: 9px;">
                        <strong>{{ $guarantee->salaryGuarantee->employer_name }}</strong><br>
                        {{ $guarantee->salaryGuarantee->employer_address }} |
                        Position: {{ $guarantee->salaryGuarantee->employee_position }}<br>
                        Monthly Salary: KSh {{ number_format($guarantee->salaryGuarantee->monthly_salary, 0) }} |
                        Since: {{ $guarantee->salaryGuarantee->employment_start_date->format('M Y') }}
                    </div>
                    <div style="font-size: 8px; color: #28a745; margin-top: 2px;">
                        ✓ Employment Letter, Confirmation Letter & 2 Months Payslips Attached
                    </div>
                </div>
                @endif
            @endif

            @if($guarantee->notes)
            <div style="font-size: 8px; color: #666; margin-top: 4px;">
                <strong>Notes:</strong> {{ $guarantee->notes }}
            </div>
            @endif
        </div>
        @endforeach
    </div>
    @endif

    <!-- Additional Notes -->
    @if($loan->notes)
    <div class="section">
        <div class="section-title">Additional Notes</div>
        <div class="notes-section">
            <p>{{ $loan->notes }}</p>
        </div>
    </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <p><strong>Morio Sacco Management System</strong></p>
        <p>This is an official loan document. Please keep for your records.</p>
        <p>Report generated on {{ date('l, F j, Y \a\t g:i A') }}</p>
    </div>
</body>
</html>
