@extends('adminlte::page')

@section('title', 'Currencies')

@section('content_header')
    <h1>Currency Management</h1>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-3">
        <!-- Total Currencies -->
        <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
            <div class="card border-left-primary shadow-sm">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Currencies
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                {{ $currencies->total() }}
                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-dollar-sign mr-1"></i>
                                Available currencies
                            </div>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Active Currencies -->
        <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
            <div class="card border-left-success shadow-sm">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Currencies
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                {{ $currencies->where('is_active', true)->count() }}
                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-check-circle mr-1"></i>
                                Currently available
                            </div>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                <i class="fas fa-check-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Primary Currency -->
        <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
            <div class="card border-left-warning shadow-sm">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Primary Currency
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                {{ $primaryCurrency ? $primaryCurrency->code : 'None' }}
                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-star mr-1"></i>
                                System default
                            </div>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inactive Currencies -->
        <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
            <div class="card border-left-secondary shadow-sm">
                <div class="card-body py-2 px-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="flex-grow-1">
                            <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                                Inactive Currencies
                            </div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                {{ $currencies->where('is_active', false)->count() }}
                            </div>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-pause-circle mr-1"></i>
                                Temporarily disabled
                            </div>
                        </div>
                        <div class="flex-shrink-0 ml-2">
                            <div class="bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                <i class="fas fa-pause-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Currencies Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Currency List</h3>
                    <div class="card-tools">
                        <a href="{{ route('currencies.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Currency
                        </a>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Code</th>
                                <th>Symbol</th>
                                <th>Primary</th>
                                <th>Status</th>
                                <th>Sort Order</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($currencies as $currency)
                            <tr>
                                <td>{{ $currency->id }}</td>
                                <td>
                                    <div class="font-weight-medium">{{ $currency->name }}</div>
                                </td>
                                <td>
                                    <span class="badge badge-info">{{ $currency->code }}</span>
                                </td>
                                <td>
                                    <strong>{{ $currency->symbol }}</strong>
                                </td>
                                <td>
                                    @if($currency->is_primary)
                                        <span class="badge badge-warning">
                                            <i class="fas fa-star"></i> Primary
                                        </span>
                                    @else
                                        <form action="{{ route('currencies.set-primary', $currency) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-outline-warning btn-xs" title="Set as Primary">
                                                <i class="fas fa-star"></i> Set Primary
                                            </button>
                                        </form>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge badge-{{ $currency->is_active ? 'success' : 'secondary' }}">
                                        {{ $currency->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>{{ $currency->sort_order }}</td>
                                <td>{{ $currency->created_at->format('d M Y') }}</td>
                                <td>
                                    <div class="btn-group btn-group-xs">
                                        <a href="{{ route('currencies.show', $currency) }}" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('currencies.edit', $currency) }}" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('currencies.toggle-status', $currency) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-{{ $currency->is_active ? 'secondary' : 'success' }} btn-xs"
                                                    title="{{ $currency->is_active ? 'Deactivate' : 'Activate' }}">
                                                <i class="fas fa-{{ $currency->is_active ? 'pause' : 'play' }}"></i>
                                            </button>
                                        </form>
                                        @if(!$currency->is_primary)
                                        <form action="{{ route('currencies.destroy', $currency) }}" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this currency?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-dollar-sign fa-3x mb-3"></i>
                                        <h5>No Currencies Found</h5>
                                        <p>Start by adding your first currency to the system.</p>
                                        <a href="{{ route('currencies.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add First Currency
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($currencies->hasPages())
                <div class="card-footer">
                    {{ $currencies->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});

@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
