@extends('adminlte::page')

@section('title', 'Edit Currency')

@section('content_header')
    <h1>Edit Currency: {{ $currency->name }}</h1>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Currency Information</h3>
                </div>
                <form action="{{ route('currencies.update', $currency) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Currency Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                           id="name" name="name" value="{{ old('name', $currency->name) }}" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Full name of the currency (e.g., US Dollar)</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="code">Currency Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('code') is-invalid @enderror"
                                           id="code" name="code" value="{{ old('code', $currency->code) }}" maxlength="3" required>
                                    @error('code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">ISO currency code (e.g., USD, EUR, KES)</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="symbol">Currency Symbol <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('symbol') is-invalid @enderror"
                                           id="symbol" name="symbol" value="{{ old('symbol', $currency->symbol) }}" maxlength="10" required>
                                    @error('symbol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Symbol for the currency (e.g., $, €, KSh)</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sort_order">Sort Order</label>
                                    <input type="number" class="form-control @error('sort_order') is-invalid @enderror"
                                           id="sort_order" name="sort_order" value="{{ old('sort_order', $currency->sort_order) }}" min="0">
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Order for displaying currencies (lower numbers appear first)</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="hidden" name="is_active" value="0">
                                        <input type="checkbox" class="custom-control-input" id="is_active"
                                               name="is_active" value="1" {{ old('is_active', $currency->is_active) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">Active Currency</label>
                                    </div>
                                    <small class="form-text text-muted">Enable this currency for use in the system</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="hidden" name="is_primary" value="0">
                                        <input type="checkbox" class="custom-control-input" id="is_primary"
                                               name="is_primary" value="1" {{ old('is_primary', $currency->is_primary) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_primary">Set as Primary Currency</label>
                                    </div>
                                    <small class="form-text text-muted">Make this the default currency for the system</small>
                                    @if($currency->is_primary)
                                        <div class="alert alert-warning mt-2">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            This is currently the primary currency. Unchecking this will require setting another currency as primary.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Currency
                        </button>
                        <a href="{{ route('currencies.index') }}" class="btn btn-secondary ml-2">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Currency Details</h3>
                </div>
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-5">ID:</dt>
                        <dd class="col-sm-7">{{ $currency->id }}</dd>

                        <dt class="col-sm-5">Created:</dt>
                        <dd class="col-sm-7">{{ $currency->created_at->format('d M Y H:i') }}</dd>

                        <dt class="col-sm-5">Last Updated:</dt>
                        <dd class="col-sm-7">{{ $currency->updated_at->format('d M Y H:i') }}</dd>
                    </dl>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Help & Guidelines</h3>
                </div>
                <div class="card-body">
                    <h6><i class="fas fa-info-circle text-info"></i> Currency Information</h6>
                    <ul class="list-unstyled">
                        <li><strong>Name:</strong> Full currency name (e.g., "Kenyan Shilling")</li>
                        <li><strong>Code:</strong> ISO 4217 code (3 letters, e.g., "KES")</li>
                        <li><strong>Symbol:</strong> Display symbol (e.g., "KSh", "$", "€")</li>
                    </ul>

                    <hr>

                    <h6><i class="fas fa-star text-warning"></i> Primary Currency</h6>
                    <p class="mb-2">The primary currency is used as the default throughout the system. Only one currency can be primary at a time.</p>

                    <h6><i class="fas fa-toggle-on text-success"></i> Active Status</h6>
                    <p class="mb-0">Inactive currencies are not available for selection but remain in the system for historical data.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
