@extends('adminlte::page')

@section('title', 'Communications')

@section('content_header')
    <h1>Communications Management</h1>
@stop

@section('content')
<div class="container-fluid">
<!-- Compact Statistics Cards - Communications Overview -->
<div class="row mb-3">
    <!-- Total Communications -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-primary shadow-sm compact-comm-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Communications
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $totalCommunications }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-envelope mr-1"></i>
                            All communications
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-envelope"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Sent Communications -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-success shadow-sm compact-comm-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Sent Communications
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $sentCommunications }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-paper-plane mr-1"></i>
                            Successfully sent
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-paper-plane"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Draft Communications -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-warning shadow-sm compact-comm-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Draft Communications
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $draftCommunications }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-edit mr-1"></i>
                            Pending review
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-edit"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scheduled Communications -->
    <div class="col-xl-3 col-lg-6 col-md-6 col-12 mb-2">
        <div class="card border-left-info shadow-sm compact-comm-card">
            <div class="card-body py-2 px-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Scheduled Communications
                        </div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">
                            {{ $scheduledCommunications }}
                        </div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-clock mr-1"></i>
                            Time-based sends
                        </div>
                    </div>
                    <div class="flex-shrink-0 ml-2">
                        <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Communications Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">System Communications</h3>
                    <div class="card-tools">
                        <a href="{{ route('communications.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Create Communication
                        </a>
                    </div>
                </div>

                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap table-sm compact-table">
                        <thead class="thead-light">
                            <tr>
                                <th class="compact-th">Subject</th>
                                <th class="compact-th d-none d-lg-table-cell">Recipient Type</th>
                                <th class="compact-th">Status</th>
                                <th class="compact-th d-none d-md-table-cell">Priority</th>
                                <th class="compact-th d-none d-lg-table-cell">Created By</th>
                                <th class="compact-th d-none d-md-table-cell">Sent At</th>
                                <th class="compact-th">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($communications as $communication)
                            <tr class="compact-row">
                                <td class="compact-td">
                                    <div class="font-weight-medium">{{ Str::limit($communication->subject, 40) }}</div>
                                </td>
                                <td class="compact-td d-none d-lg-table-cell">
                                    <span class="badge badge-sm badge-info">{{ ucfirst(str_replace('_', ' ', $communication->recipient_type)) }}</span>
                                </td>
                                <td class="compact-td">
                                    @if($communication->status === 'sent')
                                        <span class="badge badge-sm badge-success">Sent</span>
                                    @elseif($communication->status === 'scheduled')
                                        <span class="badge badge-sm badge-warning">Scheduled</span>
                                    @else
                                        <span class="badge badge-sm badge-secondary">Draft</span>
                                    @endif
                                </td>
                                <td class="compact-td d-none d-md-table-cell">
                                    @if($communication->priority === 'urgent')
                                        <span class="badge badge-sm badge-danger">Urgent</span>
                                    @elseif($communication->priority === 'high')
                                        <span class="badge badge-sm badge-warning">High</span>
                                    @elseif($communication->priority === 'normal')
                                        <span class="badge badge-sm badge-info">Normal</span>
                                    @else
                                        <span class="badge badge-sm badge-light">Low</span>
                                    @endif
                                </td>
                                <td class="compact-td d-none d-lg-table-cell">{{ Str::limit($communication->creator->full_name ?? 'Unknown', 15) }}</td>
                                <td class="compact-td d-none d-md-table-cell">
                                    @if($communication->sent_at)
                                        {{ $communication->sent_at->format('d M H:i') }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="compact-td">
                                    <div class="btn-group btn-group-xs">
                                        <a href="{{ route('communications.show', $communication) }}" class="btn btn-info btn-xs" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($communication->status !== 'sent')
                                        <a href="{{ route('communications.edit', $communication) }}" class="btn btn-warning btn-xs" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('communications.destroy', $communication) }}" method="POST" class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this communication?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-xs" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endif
                                        @if($communication->status === 'draft')
                                        <form action="{{ route('communications.send', $communication) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-success btn-xs" title="Send">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-envelope fa-3x mb-3"></i>
                                        <h5>No Communications Found</h5>
                                        <p>Start by creating your first communication to members.</p>
                                        <a href="{{ route('communications.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Create First Communication
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($communications->hasPages())
                <div class="card-footer">
                    {{ $communications->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>

</div>

<style>
/* Sleek Statistics Cards Styling */
.card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 12px;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

.border-left-primary {
    border-left: 4px solid #4e73df !important;
}

.border-left-warning {
    border-left: 4px solid #f6c23e !important;
}

.border-left-success {
    border-left: 4px solid #1cc88a !important;
}

.border-left-info {
    border-left: 4px solid #36b9cc !important;
}

.card-body {
    padding: 1.5rem;
}

/* Compact communications card styling */
.compact-comm-card {
    height: 80px;
    margin-bottom: 0.5rem !important;
}

.compact-comm-card .card-body {
    padding: 0.75rem 1rem !important;
    height: 100%;
    display: flex;
    align-items: center;
}

.compact-comm-card .h6 {
    font-size: 1.1rem;
    line-height: 1.2;
}

.compact-comm-card .text-xs {
    font-size: 0.7rem;
    line-height: 1.1;
}

/* Compact Table Styling */
.compact-table {
    font-size: 0.85rem;
    margin-bottom: 0;
}

.compact-table .compact-th {
    padding: 0.25rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #dee2e6;
    vertical-align: middle;
}

.compact-table .compact-td {
    padding: 0.25rem 0.75rem;
    vertical-align: middle;
    border-top: 1px solid #f1f3f4;
}

.compact-table .compact-row {
    height: 40px;
}

.compact-table .btn-xs {
    padding: 0.2rem 0.4rem;
    font-size: 0.75rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

.compact-table .btn-group-xs .btn {
    margin-right: 0.1rem;
}

.compact-table .badge-sm {
    font-size: 0.7rem;
    padding: 0.25rem 0.4rem;
}

.compact-table .text-xs {
    font-size: 0.65rem;
    line-height: 1.1;
}

.text-primary {
    color: #4e73df !important;
}

.text-warning {
    color: #f6c23e !important;
}

.text-success {
    color: #1cc88a !important;
}

.text-info {
    color: #36b9cc !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.font-weight-bold {
    font-weight: 700 !important;
}

.font-weight-bolder {
    font-weight: 800 !important;
}

.text-xs {
    font-size: 0.75rem;
}

.text-uppercase {
    text-transform: uppercase;
}

.mb-1 {
    margin-bottom: 0.5rem !important;
}

.mb-0 {
    margin-bottom: 0 !important;
}

.mt-1 {
    margin-top: 0.5rem !important;
}

.mr-1 {
    margin-right: 0.5rem !important;
}

.d-flex {
    display: flex !important;
}

.justify-content-between {
    justify-content: space-between !important;
}

.align-items-center {
    align-items: center !important;
}

.flex-grow-1 {
    flex-grow: 1 !important;
}

.flex-shrink-0 {
    flex-shrink: 0 !important;
}

.rounded-circle {
    border-radius: 50% !important;
}

.h-100 {
    height: 100% !important;
}

.h5 {
    font-size: 1.25rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }

    .h5 {
        font-size: 1.1rem;
    }

    .text-xs {
        font-size: 0.7rem;
    }

    .compact-table {
        font-size: 0.8rem;
    }

    .compact-table .compact-th,
    .compact-table .compact-td {
        padding: 0.4rem 0.5rem;
    }

    .compact-table .compact-row {
        height: 45px;
    }
}
</style>

@push('js')
@if(session('success'))
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '{{ session("success") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif

@if(session('error'))
Swal.fire({
    icon: 'error',
    title: 'Error!',
    text: '{{ session("error") }}',
    timer: 3000,
    showConfirmButton: false
});
@endif
@endpush
@stop
