@extends('adminlte::page')

@section('title', 'Branch Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $branch->name }} Branch</h3>
                    <div class="card-tools">
                        <a href="{{ route('branches.edit', $branch) }}" class="btn btn-outline-warning btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                        <a href="{{ route('branches.index') }}" class="btn btn-outline-secondary btn-sm ml-1">
                            <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-bordered">
                                <tr>
                                    <th class="bg-light" style="width: 200px;">Branch ID</th>
                                    <td>{{ $branch->id }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Branch Name</th>
                                    <td><strong>{{ $branch->name }}</strong></td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Location</th>
                                    <td>{{ $branch->location }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Contact</th>
                                    <td>{{ $branch->contact ?? 'Not specified' }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Manager</th>
                                    <td>{{ $branch->manager ?? 'Not assigned' }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Description</th>
                                    <td>{{ $branch->description ?? 'No description available' }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Total Members</th>
                                    <td>
                                        <span class="badge badge-info badge-lg">
                                            {{ $branch->users()->count() }} members
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Created</th>
                                    <td>{{ $branch->created_at->format('d M Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <th class="bg-light">Last Updated</th>
                                    <td>{{ $branch->updated_at->format('d M Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-users"></i> Branch Members
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <h2 class="text-primary">{{ $branch->users()->count() }}</h2>
                                        <p class="text-muted mb-0">Total registered members</p>
                                    </div>
                                    @if($branch->users()->count() > 0)
                                        <hr>
                                        <p class="small text-muted">Recent members:</p>
                                        <ul class="list-unstyled">
                                            @foreach($branch->users()->latest()->take(3) as $user)
                                            <li class="small">
                                                <i class="fas fa-user text-primary"></i>
                                                {{ $user->first_name }} {{ $user->second_name }}
                                            </li>
                                            @endforeach
                                            @if($branch->users()->count() > 3)
                                            <li class="small text-muted">... and {{ $branch->users()->count() - 3 }} more</li>
                                            @endif
                                        </ul>
                                    @endif
                                </div>
                            </div>

                            <div class="card border-success mt-3">
                                <div class="card-header bg-success text-white">
                                    <h6 class="card-title mb-0">
                                        <i class="fas fa-info-circle"></i> Branch Status
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled small mb-0">
                                        <li><i class="fas fa-check-circle text-success"></i> Branch is active</li>
                                        <li><i class="fas fa-map-marker-alt text-success"></i> Location: {{ $branch->location }}</li>
                                        @if($branch->contact)
                                        <li><i class="fas fa-phone text-success"></i> Contact available</li>
                                        @endif
                                        @if($branch->manager)
                                        <li><i class="fas fa-user-tie text-success"></i> Manager assigned</li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <strong>Branch Code:</strong> BR{{ str_pad($branch->id, 3, '0', STR_PAD_LEFT) }}
                            </small>
                        </div>
                        <div class="col-md-6 text-right">
                            <form action="{{ route('branches.destroy', $branch) }}" method="POST" class="d-inline"
                                  onsubmit="return confirm('Are you sure you want to delete this branch? This will affect all associated members.')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Members List -->
    @if($branch->users()->count() > 0)
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Branch Members</h3>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Member Name</th>
                                <th>ID Number</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Membership Status</th>
                                <th>Joined</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($branch->users as $user)
                            <tr>
                                <td>{{ $user->id }}</td>
                                <td>{{ $user->first_name }} {{ $user->second_name }}</td>
                                <td>{{ $user->id_number }}</td>
                                <td>{{ $user->phone_number }}</td>
                                <td>{{ $user->email }}</td>
                                <td>
                                    @if($user->membership)
                                        <span class="badge badge-{{ $user->membership->status === 'active' ? 'success' : 'warning' }}">
                                            {{ ucfirst($user->membership->status) }}
                                        </span>
                                    @else
                                        <span class="badge badge-secondary">No Membership</span>
                                    @endif
                                </td>
                                <td>{{ $user->created_at->format('d M Y') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@stop

