@extends('adminlte::page')

@section('title', 'Add New Branch')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Branch Information</h3>
                    <div class="card-tools">
                        <a href="{{ route('branches.index') }}" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
                <form action="{{ route('branches.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Branch Name <span class="text-danger">*</span></label>
                                    <input type="text" name="name" id="name"
                                           class="form-control @error('name') is-invalid @enderror"
                                           value="{{ old('name') }}" required>
                                    <small class="form-text text-muted">Enter the full name of the branch</small>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="location">Location <span class="text-danger">*</span></label>
                                    <input type="text" name="location" id="location"
                                           class="form-control @error('location') is-invalid @enderror"
                                           value="{{ old('location') }}" required>
                                    <small class="form-text text-muted">City, town, or area where the branch is located</small>
                                    @error('location')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contact">Branch Contact</label>
                                    <input type="text" name="contact" id="contact"
                                           class="form-control @error('contact') is-invalid @enderror"
                                           value="{{ old('contact') }}"
                                           placeholder="Phone number or email">
                                    <small class="form-text text-muted">Primary contact information for the branch</small>
                                    @error('contact')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="manager">Branch Manager</label>
                                    <input type="text" name="manager" id="manager"
                                           class="form-control @error('manager') is-invalid @enderror"
                                           value="{{ old('manager') }}"
                                           placeholder="Full name of the branch manager">
                                    <small class="form-text text-muted">Name of the person managing this branch</small>
                                    @error('manager')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror"
                                      rows="4" placeholder="Additional information about this branch...">{{ old('description') }}</textarea>
                            <small class="form-text text-muted">Optional description of the branch, its services, or special features</small>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-save"></i> Create
                        </button>
                        <a href="{{ route('branches.index') }}" class="btn btn-outline-secondary btn-sm ml-2">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

